/* The client: we proxy for a particular port. 
 */
/* Connect to the server. When a packet arrives, check the source port
   and transmit that to the server. Then just forward packets. */

#include "common.h"

int main(int argn, char *args[]) {
  int pfrom, pto;
  unsigned long hfrom, hto;

  if (argn != 5) {
    printf("Syntax: %s [listen address] [listen port] [proxy ip] [proxy port]\n", args[0]);
    exit(0);
  }

  {
    unsigned long cur_delay = DELAY;
    unsigned long total, busy;
    int done;
    int tcpfd, udpfd, maxfd;
    unsigned char *mybuf=NULL;
    unsigned long bfwp;
    unsigned long bfhost;
    struct sockaddr_in addr;
    struct sockaddr_in them;
    int tl, r2, ret;
    unsigned char pckt[4*MAX_PACKET_SZ+256];
    unsigned long pptr = 0;
    unsigned int state = -1;
    unsigned char *buf;
    int i;
    unsigned long host;
    unsigned int port;
    unsigned char rdbuf[1024];
    fd_set rfds, wfds;


    hfrom = primaryIP(args[1]);
    pfrom = atoi(args[2]);
    
    hto = primaryIP(args[3]);
    pto = atoi(args[4]);
    
    /* Establish TCP with the proxy */
    tcpfd = socket(AF_INET, SOCK_STREAM, 0);
    if (tcpfd < 0) {
      perror("Can't create TCP socket");
    }

    /* bind it to any old thing */
    printf("Binding TCP socket to any old address.\n");
    addr.sin_family = AF_INET;
    addr.sin_addr.s_addr = 0;
    addr.sin_port = 0;

    ret = bind(tcpfd, (struct sockaddr *)&addr, sizeof(struct sockaddr_in));
    if (ret < 0) {
      perror("Help ! Can't bind()");
      exit(1);
    }
    
    /* Now connect it .. */
    them.sin_family = AF_INET;
    them.sin_addr.s_addr = hto;
    them.sin_port = htons(pto);

    printf("Trying to connect to %x (%s), port %d\n", hto, args[3], pto);

    ret = connect(tcpfd,  (struct sockaddr *)&them, sizeof(struct sockaddr_in));
    if (ret < 0) {
      perror("Help ! Can't connect()");
      exit(1);
    }
    
    printf("Connected TCP. Opening UDP socket %d... \n", pfrom);
    
    udpfd = getQuakeSocket(pfrom);
    
    /* ... and wait */
    printf("Waiting for first packet from %x ...\n", hfrom);
    host = hfrom; port = 0;
    maxfd = (udpfd > tcpfd ? udpfd : tcpfd) + 1;

    while (1) {
      usleep(DELAY);
      buf = rcvPacket(udpfd, &tl, &host, &port, &mybuf);
      if (buf != NULL) {
	printf("Got from %x (%d)\n", host, port);
      }
      if (buf != NULL && host == hfrom) {
	printf("Starting packet forwarding for %x (port %d)..\n", hfrom, port);
	pfrom =port;
	port = htonl(port);
	
	ret = write(tcpfd, &port, 4);
	port = pfrom;
	if (ret != 4) {
	  perror("Can't write proxy port.\n");
	  exit(1);
	}
	break;
      } else {
	usleep(DELAY);
      }
    }
    
    /* Now write the packet .. */
    buf -= 4;
    (*(unsigned long *)(buf)) = htonl(tl);
    done = 0;
    while (done < (tl+4)) {
      ret = write(tcpfd, &buf[done], tl+4-done);
      if (ret < 0) {
	if (!(errno==EAGAIN || errno==EINTR)) {
	  perror("Can't write packet to TCP");
	  exit(2);
	}
      } else { done+= ret; }
    }


    fcntl(tcpfd, F_SETFL, O_NONBLOCK);
    
    printf("From port now fixed at %d\n", pfrom);
    total = 0; busy = 0;
   

      while (1) {
	float ratio;

#ifdef OLD_THROTTLE
	ratio = ((float)busy)/((float)total);
	if (total > 65535) { total -=65535; busy -= (int)(65535.0*ratio); }
	if (ratio < 0.1) { cur_delay = cur_delay * 2; }
	if (ratio > 0.3) { cur_delay = cur_delay/2; }
 	if (cur_delay < 100) { cur_delay = 100; }
	if (cur_delay > DELAY) { cur_delay = DELAY; }
#ifdef STATS
      if ((total%256)==0) {
	printf("%d/%d -> %d\n", busy, total, cur_delay);
      }
#endif
#endif
      /* usleep(38); */

	total+=2;
	FD_ZERO(&wfds);
	FD_SET(udpfd , &wfds);
	FD_SET(tcpfd , &wfds);
	FD_ZERO(&rfds);
	FD_SET(udpfd , &rfds);
	FD_SET(tcpfd , &rfds);
	
	ret = select(maxfd, &rfds, NULL, NULL, NULL);
	if (ret == -1) {
	  perror("Exceptional condition in select()");
	  exit(1);
	}

	if (FD_ISSET(udpfd, &rfds)) {
	  buf = rcvPacket(udpfd, &tl, &host, &port, &mybuf);
	  if (buf != NULL) {
	    if (host==hfrom && port ==pfrom) {
#ifdef DEBUG
	      printf("Trying to fwd %d packet\n", tl);
#endif
	      busy++;
	      buf -= 4;
	      (*(unsigned long *)(buf)) = htonl(tl);
	      done = 0;
	      if (1) { 
		while (done < (tl+4)) {
		  ret = write(tcpfd, &buf[done], tl+4-done);
		  if (ret < 0) {
		    if (!(errno==EAGAIN || errno==EINTR)) {
		      perror("Can't write packet to TCP");
		      exit(2);
		    }
		  } else { done+= ret; }
		}
#ifdef DEBUG
	      printPacket(buf, tl+4);
	      printf("Forwarded packet to TCP stream (%d)...\n", tl);
#endif
		
	      }
	    } else {
	      printf("Won't forward packet from %x (%d)\n", host, port);
	    }
	  }
	}
	
	if (FD_ISSET(tcpfd, &rfds)) {
	  /* Now recieve some of a packet from TCP/IP */
	  ret = read(tcpfd,  &pckt[pptr], MAX_PACKET_SZ*4 - pptr);
	  if (ret == 0) {
	    printf("Other side closed TCP connection. Bye.\n");
	    close(tcpfd); close(udpfd);
	    exit(0);
	  }
	  if (ret < 0 && (errno != EAGAIN) && (errno != EINTR)) {
	    perror("Can't read() from TCP socket");
	    close(tcpfd); close(udpfd);
	    exit(1);
	  }
	  if (ret > 0) {
	    pptr+=ret;
	    busy++;
	    
	    if (pptr > 4*MAX_PACKET_SZ) { 
	      fprintf(stderr, "Help ! Packet overflow - %d\n", pptr);
	      exit(2);
	    }
	  }
	  
	  while (pptr > 4) {
	    unsigned int sz = ntohl(*((unsigned long *)pckt));
	    
#ifdef DEBUG
	    printf("Size is %d\n", sz);
#endif
	    
	    if (pptr > 4 && pptr-4 >= sz) {
	      // We've got a full packet. output it.
	      r2 = sendPacket(udpfd, &pckt[4], sz, hfrom, pfrom);
	      if (r2 < 0) {
		perror("Can't forward packet to UDP");
	      }
#ifdef DEBUG
	      printPacket(pckt+4, sz);
	      printf("Forwarded packet from TCP stream (%d, %d)...\n",pptr, sz);
#endif
	      if (pptr > (4+sz)) { 
		memmove(&pckt[0], &pckt[4+sz], pptr-(4+sz));
	      }
	      pptr -= (4+sz);
	    }
	  }
	}
      }
  }
	
	
  return 0;
}

