#include "g_local.h"



/*
======================================================================

INTERMISSION

======================================================================
*/

void MoveClientToIntermission (edict_t *ent)
{
	ent->client->showscores = true;
	VectorCopy (level.intermission_origin, ent->s.origin);
	ent->client->ps.pmove.origin[0] = level.intermission_origin[0]*8;
	ent->client->ps.pmove.origin[1] = level.intermission_origin[1]*8;
	ent->client->ps.pmove.origin[2] = level.intermission_origin[2]*8;
	VectorCopy (level.intermission_angle, ent->client->ps.viewangles);
	ent->client->ps.pmove.pm_type = PM_FREEZE;
	ent->client->ps.gunindex = 0;
	ent->client->ps.blend[3] = 0;

	// clean up powerup info
	ent->client->quad_framenum = 0;
	ent->client->invincible_framenum = 0;
	ent->client->breather_framenum = 0;
	ent->client->enviro_framenum = 0;
	ent->client->grenade_blew_up = false;
	ent->client->grenade_time = 0;

	ent->viewheight = 0;
	ent->s.modelindex = 0;
	ent->s.modelindex2 = 0;
	ent->s.modelindex3 = 0;
	ent->s.modelindex = 0;
	ent->s.effects = 0;
	ent->s.sound = 0;
	ent->solid = SOLID_NOT;

	// add the layout

	if (deathmatch->value)
	{
		DeathmatchScoreboardMessage (ent, NULL);
		gi.unicast (ent, true);
	}

}

void BeginIntermission (edict_t *targ)
{
	int		i;
	edict_t	*ent, *client;

	if (level.intermissiontime)
		return;		// allready activated


	level.intermissiontime = level.time;
	level.changemap = targ->map;

	// if on same unit, return immediately
	if (!deathmatch->value && (targ->map && targ->map[0] != '*') )
	{	// go immediately to the next level
		level.exitintermission = 1;
		return;
	}
	level.exitintermission = 0;

	// find an intermission spot
	ent = G_Find (NULL, FOFS(classname), "info_player_intermission");
	if (!ent)
	{	// the map creator forgot to put in an intermission point...
		ent = G_Find (NULL, FOFS(classname), "info_player_start");
		if (!ent)
			ent = G_Find (NULL, FOFS(classname), "info_player_deathmatch");
	}
	else
	{	// chose one of four spots
		i = rand() & 3;
		while (i--)
		{
			ent = G_Find (ent, FOFS(classname), "info_player_intermission");
			if (!ent)	// wrap around the list
				ent = G_Find (ent, FOFS(classname), "info_player_intermission");
		}
	}

	VectorCopy (ent->s.origin, level.intermission_origin);
	VectorCopy (ent->s.angles, level.intermission_angle);

	// move all clients to the intermission point
	for (i=0 ; i<maxclients->value ; i++)
	{
		client = g_edicts + 1 + i;
		if (!client->inuse)
			continue;
		MoveClientToIntermission (client);
	}
}


/*
==================
DeathmatchScoreboardMessage

==================
*/

#define MAXOUTPUTSTRLEN 1024

#define VERTICAL_INDENTION 3
#define LINEHEIGHT 8
#define MAX_CHAR_KILLS 4

#define LINE_1_OFFSET_1 16
#define LINE_1_INDENT_1 15
#define OBSERVER_LINE_OFFSET  16
#define PLAYERS_VERT_INDENT LINEHEIGHT

#define OBSERVER_LINE_LEN 34

/*line1
012345678901234567890123456789
TEAM------------KILS----AVGP
line 2
****************************
line3-n
[NAMEOFCHARXXX]-KILS----PING
*/

void DeathmatchScoreboardMessage (edict_t *ent, edict_t *killer)
{
	char	entry[MAXOUTPUTSTRLEN+400];
	char	string[MAXOUTPUTSTRLEN+400];
	int		stringlength;
	int		i, j, k, l;
	int		sorted[MAX_CLIENTS];
	char	*teamnames[255];
	int		sortedscores[MAX_CLIENTS], sortedteamscores[MAX_CLIENTS];
	int		score, total, teamscore, totalteams;
	int		picnum;
	int		x, y, g;
	int		vertpixloc;
	char	line[255],playerline[255];
	char	t_buff[255];
	int		t_ping;
	int		t_totalmembers=0;

	gclient_t	*cl;
	edict_t		*cl_ent;
	char	*tag;

	string[0] = 0;
	stringlength = strlen(string);

	// sort the clients by score
	total = 0;
	for (i=0 ; i<game.maxclients ; i++)
	{
		cl_ent = g_edicts + 1 + i;
		if (!cl_ent->inuse)
			continue;
		score = game.clients[i].resp.score;
		for (j=0 ; j<total ; j++)
		{
			if (score > sortedscores[j])
				break;
		}
		for (k=total ; k>j ; k--)
		{
			sorted[k] = sorted[k-1];
			sortedscores[k] = sortedscores[k-1];
		}
		sorted[j] = i;
		sortedscores[j] = score;
		total++;
	}

	//Shameless plug....
	Com_sprintf (entry, sizeof(entry), "xv 1 yv 1 cstring2 \"LA QuakeII v0.7\" ");
	if (strlen(entry) > MAXOUTPUTSTRLEN)
		return;
	strcpy (string + stringlength, entry);
	stringlength += strlen(entry);

	if (config_server.teamcomp)
	{
		strcpy(line,"[TEAM]       [FRAGS]");
		for (i=0;i<strlen(line);i++)
		{
			if (line[i]==91)
				line[i]= 29;
			else if (line[i]==93)
				line[i]= 31;
			else
				line[i]+=128;
		}

		Com_sprintf (entry, sizeof(entry), "xv 1 yv %i cstring2 \"%s\" ",LINEHEIGHT*2,line);
		if (strlen(entry) > MAXOUTPUTSTRLEN)
			return;
		strcpy (string + stringlength, entry);
		stringlength += strlen(entry);

		vertpixloc = LINEHEIGHT*VERTICAL_INDENTION; 

		// sort the teams by score
		totalteams = 0;
		for (i=0 ; i<game.maxclients ; i++)
		{
			cl_ent = g_edicts + 1 + i;
			if ((!cl_ent->inuse) ||  (cl_ent->teamstruct.teammaster != cl_ent) || cl_ent->observer.observer)
				continue;
			teamscore = cl_ent->teamstruct.teamscore;
			for (j=0 ; j<totalteams ; j++)
			{
				if (teamscore > sortedteamscores[j])
					break;
			}
			for (k=totalteams ; k>j ; k--)
			{
				teamnames[k] = teamnames[k-1];
				sortedteamscores[k] = sortedteamscores[k-1];
			}
			teamnames[j] = cl_ent->teamstruct.teamname;
			sortedteamscores[j] = teamscore;
			totalteams++;
		}


		strcpy(playerline,"[NAME]       [FRAGS]    [PING]");
		for (i=0;i<strlen(playerline);i++)
		{
			if (playerline[i]==91)
				playerline[i]= 29;
			else if (playerline[i]==93)
				playerline[i]= 31;
			else
				playerline[i]+=128;
		}

		for (i=0 ; i < totalteams ; i++)
		{
			if (sortedteamscores[i]>9999)
				sortedteamscores[i]=9999;
			if (sortedteamscores[i]< -999)
				sortedteamscores[i]= -999;
			strcpy(line,teamnames[i]);
			for(j=strlen(teamnames[i]);j<LINE_1_INDENT_1;j++)
				line[j]=' ';

			sprintf(t_buff, "%d", sortedteamscores[i]);
			for(k=0;k< (4-strlen(t_buff));k++)
				line[j++]=' ';
			strcpy(line+j,t_buff);
			j+=strlen(t_buff);
			
			Com_sprintf (entry, sizeof(entry), "xv 0 yv %i cstring2 \"%s\" ",i*LINEHEIGHT+vertpixloc,line);
			strcpy (string + stringlength, entry);
			stringlength += strlen(entry);
			if (stringlength>=MAXOUTPUTSTRLEN)
			{
				string[MAXOUTPUTSTRLEN]=0;
				break;//out of for loop
			}
		}
		vertpixloc=vertpixloc+totalteams*LINEHEIGHT;

		for (j=0;j< totalteams;j++)
		{
			vertpixloc+=PLAYERS_VERT_INDENT;
			strcpy(line,teamnames[j]);

			for (i=0;i<strlen(line);i++)
			{
				if (line[i]==91)
					line[i]= 29;
				else if (line[i]==93)
					line[i]= 31;
				else
					line[i]+=128;
			}

			Com_sprintf (entry, sizeof(entry), "xv 0 yv %i cstring2 \"%s\" ",vertpixloc,line);
			strcpy (string + stringlength, entry);
			stringlength += strlen(entry);

			vertpixloc+=LINEHEIGHT;

			Com_sprintf (entry, sizeof(entry), "xv 1 yv %i cstring2 \"%s\" ",vertpixloc,playerline);
			if (strlen(entry) > MAXOUTPUTSTRLEN)
				return;
			strcpy (string + stringlength, entry);
			stringlength += strlen(entry);
			vertpixloc+=LINEHEIGHT;
			t_totalmembers=0;
			for (i=0 ; i<total ; i++)
			{
				cl = &game.clients[sorted[i]];
				cl_ent = g_edicts + 1 + sorted[i];
				if (cl_ent->observer.observer || (stricmp(cl_ent->teamstruct.teamname,teamnames[j])))
					continue;
				if (cl->resp.score>9999)
					cl->resp.score=9999;
				if (cl->resp.score< -999)
					cl->resp.score= -999;
				strcpy(line,cl->pers.netname);
				for(l=strlen(cl->pers.netname);l<LINE_1_INDENT_1;l++)
					line[l]=' ';

				if (cl_ent->teamstruct.teammaster == cl_ent) //make team leader white name....
				{
					for (g=0;g<strlen(line);g++)
					{
						line[g]+=128;
					}
				}

				sprintf(t_buff, "%d", cl->resp.score);
				for(k=0;k< (4-strlen(t_buff));k++)
					line[l++]=' ';
				strcpy(line+l,t_buff);
				l+=strlen(t_buff);
				strcpy(line+l,"          ");
				l+=10;

				t_ping=cl->ping;
				if (t_ping>9999)
					t_ping=9999;
				if (t_ping< 0)
					t_ping= 0;

				sprintf(t_buff, "%d", cl->ping);
				strcpy(line+l-strlen(t_buff),t_buff);

				Com_sprintf (entry, sizeof(entry), "xv 0 yv %i cstring2 \"%s\" ",t_totalmembers*LINEHEIGHT+vertpixloc,line);
				strcpy (string + stringlength, entry);
				stringlength += strlen(entry);

				if (stringlength>=MAXOUTPUTSTRLEN)
				{
					string[MAXOUTPUTSTRLEN]=0;
					break;//out of for loop
				}
				t_totalmembers++;
			}
			vertpixloc=t_totalmembers*LINEHEIGHT+vertpixloc;
		}
		vertpixloc+=t_totalmembers*LINEHEIGHT;
		//observers

		strcpy(line,"[observers]");
		for (i=0;i<strlen(line);i++)
		{
			if (line[i]==91)
				line[i]= 29;
			else if (line[i]==93)
				line[i]= 31;
			else
				line[i]+=128;
		}

		vertpixloc+=LINEHEIGHT;
		Com_sprintf (entry, sizeof(entry), "xv 0 yv %i cstring2 \"%s\" ",vertpixloc,line);
		strcpy (string + stringlength, entry);
		stringlength += strlen(entry);

		t_totalmembers=0;
		for (i=0 ; i<total ; i++)
		{
			cl = &game.clients[sorted[i]];
			cl_ent = g_edicts + 1 + sorted[i];
			if (!cl_ent->observer.observer)
				continue;
			strcpy(line,cl->pers.netname);
			if (cl_ent->observer.observertarget)
			{
				strcat(line,"->");
				strcat(line,cl_ent->observer.observertarget->client->pers.netname);
			}
			j=strlen(line);

			t_totalmembers++;

			Com_sprintf (entry, sizeof(entry), "xv 0 yv %i cstring2 \"%s\" ",t_totalmembers*LINEHEIGHT+vertpixloc,line);
			strcpy (string + stringlength, entry);
			stringlength += strlen(entry);

			if (stringlength>=MAXOUTPUTSTRLEN)
			{
				string[MAXOUTPUTSTRLEN]=0;
				break;//out of for loop
			}
		}


	}
	else
	{
		// print level name and exit rules
		// add the clients in sorted order
		if (total > 12)
			total = 12;

		for (i=0 ; i<total ; i++)
		{
			cl = &game.clients[sorted[i]];
			cl_ent = g_edicts + 1 + sorted[i];

			picnum = gi.imageindex ("i_fixme");
			x = (i>=6) ? 160 : 0;
			y = 32 + 32 * (i%6);

			// add a dogtag
			if (cl_ent == ent)
				tag = "tag1";
			else if (cl_ent == killer)
				tag = "tag2";
			else
				tag = NULL;
			if (tag)
			{
				Com_sprintf (entry, sizeof(entry),
					"xv %i yv %i picn %s ",x+32, y, tag);
				j = strlen(entry);
				if (stringlength + j > 1024)
					break;
				strcpy (string + stringlength, entry);
				stringlength += j;
			}

			// send the layout
			Com_sprintf (entry, sizeof(entry),
				"client %i %i %i %i %i %i ",
				x, y, sorted[i], cl->resp.score, cl->ping, ((level.framenum - cl->resp.enterframe)/600));
			j = strlen(entry);
			if (stringlength + j > 1024)
				break;
			strcpy (string + stringlength, entry);
			stringlength += j;
		}
	}

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}


/*
==================
DeathmatchScoreboard

Draw instead of help message.
Note that it isn't that hard to overflow the 1400 byte message limit!
==================
*/
void DeathmatchScoreboard (edict_t *ent)
{
	DeathmatchScoreboardMessage (ent, ent->enemy);
	gi.unicast (ent, true);
}


/*
==================
Cmd_Help_f

Display the current help message
==================
*/
void Cmd_Help_f (edict_t *ent)
{
	char	string[1024];
	char	*sk;

	if (ent->client->showscores && !game.helpchanged)
	{
		ent->client->showscores = false;
		return;
	}

	// remove help icon
	game.helpchanged = false;

	ent->client->showscores = true;
	ent->client->showinventory = false;

	if (deathmatch->value)
	{
		DeathmatchScoreboard (ent);
		return;
	}

	if (skill->value == 0)
		sk = "easy";
	else if (skill->value == 1)
		sk = "medium";
	else
		sk = "hard";

	// send the layout
	Com_sprintf (string, sizeof(string),
		"xv 32 yv 8 picn help "			// background
		"xv 202 yv 12 string2 \"%s\" "		// skill
		"xv 0 yv 24 cstring2 \"%s\" "		// level name
		"xv 0 yv 54 cstring2 \"%s\" "		// help 1
		"xv 0 yv 110 cstring2 \"%s\" "		// help 2
		"xv 50 yv 164 string2 \" kills     goals    secrets\" "
		"xv 50 yv 172 string2 \"%3i/%3i     %i/%i       %i/%i\" ", 
		sk,
		level.level_name,
		game.helpmessage1,
		game.helpmessage2,
		level.killed_monsters, level.total_monsters, 
		level.found_goals, level.total_goals,
		level.found_secrets, level.total_secrets);

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
	gi.unicast (ent, true);
}




//=======================================================================

/*
===============
G_SetStats
===============
*/
void G_SetStats (edict_t *ent)
{
	gitem_t		*item;
	int			index, cells;
	int			power_armor_type;
	edict_t		*observertarget = NULL;

	if ((ent->observer.observermode) && (ent->observer.observertarget))
		observertarget = ent->observer.observertarget;

	//
	// health
	//
	if (observertarget)
	{
		ent->client->ps.stats[STAT_HEALTH_ICON] = level.pic_health;
		ent->client->ps.stats[STAT_HEALTH] = observertarget->health;
	}
	else
	{
		ent->client->ps.stats[STAT_HEALTH_ICON] = level.pic_health;
		ent->client->ps.stats[STAT_HEALTH] = ent->health;
	}

	//
	// ammo
	//
	if (observertarget)
	{
		ent->client->ps.stats[STAT_AMMO_ICON] = observertarget->client->ps.stats[STAT_AMMO_ICON];
		ent->client->ps.stats[STAT_AMMO] = observertarget->client->ps.stats[STAT_AMMO];
	}
	else
	{
		if (!ent->client->ammo_index /* || !ent->client->pers.inventory[ent->client->ammo_index] */)
		{
			ent->client->ps.stats[STAT_AMMO_ICON] = 0;
			ent->client->ps.stats[STAT_AMMO] = 0;
		}
		else
		{
			item = &itemlist[ent->client->ammo_index];
			ent->client->ps.stats[STAT_AMMO_ICON] = gi.imageindex (item->icon);
			ent->client->ps.stats[STAT_AMMO] = ent->client->pers.inventory[ent->client->ammo_index];
		}
	
	}
	//
	// armor
	//
	if (observertarget)
	{
		ent->client->ps.stats[STAT_ARMOR_ICON] = observertarget->client->ps.stats[STAT_ARMOR_ICON];
		ent->client->ps.stats[STAT_ARMOR] = observertarget->client->ps.stats[STAT_ARMOR];
	}
	else
	{
		power_armor_type = PowerArmorType (ent);
		if (power_armor_type)
		{
			cells = ent->client->pers.inventory[ITEM_INDEX(FindItem ("cells"))];
			if (cells == 0)
			{	// ran out of cells for power armor
				ent->flags &= ~FL_POWER_ARMOR;
				gi.sound(ent, CHAN_ITEM, gi.soundindex("misc/power1.wav"), 1, ATTN_NORM, 0);	//FIXME powering down sound
				power_armor_type = 0;;
			}
		}

		index = ArmorIndex (ent);
		if (power_armor_type && (!index || (level.framenum & 8) ) )
		{	// flash between power armor and other armor icon
			ent->client->ps.stats[STAT_ARMOR_ICON] = gi.imageindex ("i_powershield");
			ent->client->ps.stats[STAT_ARMOR] = cells;
		}
		else if (index)
		{
			item = GetItemByIndex (index);
			ent->client->ps.stats[STAT_ARMOR_ICON] = gi.imageindex (item->icon);
			ent->client->ps.stats[STAT_ARMOR] = ent->client->pers.inventory[index];
		}
		else
		{
			ent->client->ps.stats[STAT_ARMOR_ICON] = 0;
			ent->client->ps.stats[STAT_ARMOR] = 0;
		}
	}

	

	//
	// pickup message
	//
	if (observertarget)
	{
		ent->client->ps.stats[STAT_PICKUP_ICON] = observertarget->client->ps.stats[STAT_PICKUP_ICON];
		ent->client->pickup_msg_time = observertarget->client->pickup_msg_time;
		ent->client->ps.stats[STAT_PICKUP_STRING] = 0;
	}
	else if (level.time > ent->client->pickup_msg_time)
	{
		ent->client->ps.stats[STAT_PICKUP_ICON] = 0;
		ent->client->ps.stats[STAT_PICKUP_STRING] = 0;
	}

	//
	// timers
	//
	if (observertarget)
	{
		ent->client->ps.stats[STAT_TIMER_ICON] = observertarget->client->ps.stats[STAT_TIMER_ICON];
		ent->client->ps.stats[STAT_TIMER] = observertarget->client->ps.stats[STAT_TIMER];
	}
	else
	{
		if (ent->client->quad_framenum > level.framenum)
		{
			ent->client->ps.stats[STAT_TIMER_ICON] = gi.imageindex ("p_quad");
			ent->client->ps.stats[STAT_TIMER] = (ent->client->quad_framenum - level.framenum)/10;
		}
		else if (ent->client->invincible_framenum > level.framenum)
		{
			ent->client->ps.stats[STAT_TIMER_ICON] = gi.imageindex ("p_invulnerability");
			ent->client->ps.stats[STAT_TIMER] = (ent->client->invincible_framenum - level.framenum)/10;
		}
		else if (ent->client->enviro_framenum > level.framenum)
		{
			ent->client->ps.stats[STAT_TIMER_ICON] = gi.imageindex ("p_envirosuit");
			ent->client->ps.stats[STAT_TIMER] = (ent->client->enviro_framenum - level.framenum)/10;
		}
		else if (ent->client->breather_framenum > level.framenum)
		{
			ent->client->ps.stats[STAT_TIMER_ICON] = gi.imageindex ("p_rebreather");
			ent->client->ps.stats[STAT_TIMER] = (ent->client->breather_framenum - level.framenum)/10;
		}
		else
		{
			ent->client->ps.stats[STAT_TIMER_ICON] = 0;
			ent->client->ps.stats[STAT_TIMER] = 0;
		}
	}

	//
	// selected item
	//
	if (observertarget)
	{
		ent->client->ps.stats[STAT_SELECTED_ICON] = observertarget->client->ps.stats[STAT_SELECTED_ICON];
		ent->client->ps.stats[STAT_SELECTED_ITEM] = observertarget->client->ps.stats[STAT_SELECTED_ITEM];
	}
	else
	{
		if (ent->client->pers.selected_item == -1)
			ent->client->ps.stats[STAT_SELECTED_ICON] = 0;
		else
			ent->client->ps.stats[STAT_SELECTED_ICON] = gi.imageindex (itemlist[ent->client->pers.selected_item].icon);

		ent->client->ps.stats[STAT_SELECTED_ITEM] = ent->client->pers.selected_item;
	}
	
	//
	// layouts
	//
	ent->client->ps.stats[STAT_LAYOUTS] = 0;

	if (deathmatch->value)
	{		
		if (ent->client->pers.health <= 0 || level.intermissiontime
			|| ent->client->showscores)
			ent->client->ps.stats[STAT_LAYOUTS] |= 1;
		if (ent->client->showinventory && ent->client->pers.health > 0)
			ent->client->ps.stats[STAT_LAYOUTS] |= 2;
	}
	else
	{
		if (ent->client->showscores)
			ent->client->ps.stats[STAT_LAYOUTS] |= 1;
		if (ent->client->showinventory && ent->client->pers.health > 0)
			ent->client->ps.stats[STAT_LAYOUTS] |= 2;
	}

	//
	// frags
	//
	if (observertarget)
		ent->client->ps.stats[STAT_FRAGS] = observertarget->client->resp.score;
	else
		ent->client->ps.stats[STAT_FRAGS] = ent->client->resp.score;

	//
	// help icon
	//
	if (observertarget)
	{
		ent->client->ps.stats[STAT_HELPICON] = observertarget->client->ps.stats[STAT_HELPICON];
	}
	else
	{
		if (game.helpchanged && (level.framenum&8) )
			ent->client->ps.stats[STAT_HELPICON] = gi.imageindex ("i_help");
		else if (ent->client->pers.hand == CENTER_HANDED && ent->client->pers.weapon)
			ent->client->ps.stats[STAT_HELPICON] = gi.imageindex (ent->client->pers.weapon->icon);
		else
			ent->client->ps.stats[STAT_HELPICON] = 0;
	}
}

