#include "g_local.h"


/*
==============
MotdRun

This will be called when the users MOTD time is not up.
==============
*/
void MotdRun (edict_t *ent)
{
	if (!config_server.motd)
		return;

	if (ent->client->motd_count_time > level.time)
		return;

	ent->client->motd_count_time = level.time + 1.7;
	if (config_server.motdtime == -1)
		ent->client->motd_time = level.time + 400;

	// print our message.
	gi.centerprintf (ent, config_server.motd_string);

}


/*
==============
MotdStart

This Setus up users MOTD
==============
*/
void MotdStart (edict_t *ent)
{
	FILE *motd_file;
	char line[80];

	if (!config_server.motd)
		return;

	if (motd_file = fopen(config_server.motd_file, "r"))
	{
		strcpy(config_server.motd_string, "");
		// we successfully opened the file "motd.txt"
		while ( fgets(line, 80, motd_file) )
		{
			// add each new line to motd, to create a BIG message string.
			// we are using strcat: STRing conCATenation function here.
			strcat(config_server.motd_string, line);
		}
		
		// be good now ! ... close the file
    	fclose(motd_file);
	}
	else
	{
		strcpy(config_server.motd_string, "LA Quake2 v0.7 - By CLAN LA\n\nBind a key to +use to use the turret!");
	}

	//gi.bprintf(PRINT_HIGH, "MOTD HIT!\n");

	if (config_server.motdtime == -1)
		ent->client->motd_time = level.time + 400;
	else
		ent->client->motd_time = level.time + config_server.motdtime;
	//FIXME:  include blink rate, and blinking text, 

}


