/****************************************************************************\
;                                                                            ;
;  tools.h  -  projekt LMP control center                                    ;
;  header file of tools.c                                                    ;
;                                                                            ;
;  general tool routines                                                     ;
;                                                                            ;
;  Uwe Girlich                                                               ;
;  Erika-von-Brockdorff-Strasse 2                                            ;
;  04159 Leipzig                                                             ;
;  Deutschland / Germany                                                     ;
;  E-mail: girlich@aix520.informatik.uni-leipzig.de                          ;
;                                                                            ;
\****************************************************************************/


#ifndef __TOOLS_H
#define __TOOLS_H


#include <stdio.h>

#define err_base (sys_nerr+10)

#define FEWARGS  err_base
#define MANYARGS err_base+ 1
#define FREAD    err_base+ 2
#define FWRITE   err_base+ 3
#define DEFTYPE  err_base+ 4
#define UKTYPE   err_base+ 5
#define WLMP     err_base+ 6
#define WVER     err_base+ 7 
#define UKVER    err_base+ 8
#define IMPVCH   err_base+ 9
#define ARGMIS   err_base+10
#define MANYACT  err_base+11
#define INVOPT   err_base+12
#define ILLOPT   err_base+13
#define MISIFN   err_base+14
#define MISOFN   err_base+15
#define LASTERR  err_base+16

#define TRUE  1
#define FALSE 0

#define arraylength(array) ((int)(sizeof(array)/sizeof(array[0])))

extern void syserror(int errno, char* message);
extern void syswarning(int errno, char* message);
extern void syntaxerror(long linenumber, char *message);
extern void syntaxwarning(long linenumber, char *message);
extern char *Time2String(double time, char *buf);
extern void copyopenfiles(FILE *f1, FILE *f2);
extern char *delspaces(char *a);


#endif /* __TOOLS_H */


/*-- file end tools.h --------------------------------------------------------*/
