@ECHO OFF
IF EXIST rheresy.wad GOTO patched
IF NOT EXIST deutex.exe GOTO nopat
IF NOT EXIST herpatch.wad GOTO nopat
set nowad=0
IF NOT EXIST heretic.wad echo Could not find your registered version of HERETIC(tm).
IF NOT EXIST heretic.wad set nowad=1
IF NOT EXIST doom2.wad echo Could not find your copy of DOOM2(tm).
IF NOT EXIST doom2.wad set nowad=1
IF %nowad%==1 GOTO abort
cls
echo Heretic found...
echo Doom2 found...
echo Deutex found...
echo.
echo ROMERO'S HERESY v0.15 PATCH FOR HERETIC
echo.
echo This will downgrade your HERETIC: SOTSR(tm) 1.3 registered version to
echo ROMERO'S HERETIC 0.666 ALPHA.
echo.
echo This will take some time depending on your computer.
echo Hit CTRL+C now if you want to abort.
pause
GOTO install

:nopat
echo Could not find DEUTEX or data file. Patch aborted.
pause
GOTO end

:abort
echo Patch aborted. Both DOOM2 and HERETIC iwads must be present in
echo the patch folder. You'll need to copy the missing files.
pause
GOTO end

:patched
echo Patch failed. Already patched.
pause
GOTO end

:fail
echo.
echo Patch failed. May be herpatch.wad is bad or your OS is not compatible.
echo Only DOS, Win9x, 2k and XP are supported. Check herpatch.log.
echo For DOS you'd need CSDPMI and SMARTDRV.
GOTO clean

:older
echo.
echo Wrong game version, HERETIC: SOTSR 1.3 required.
GOTO clean

:pass
del herpatch.log
echo Done!
echo Patch seems successful, rheresy.wad should be 17 mb in size.
echo Read the help file!
pause
GOTO end

:install
echo.
echo Extracting resources from HERPATCH.WAD...
deutex -rgb 0 255 255 -lumps -sprites -sounds -musics -xtract herpatch.wad > herpatch.log
IF NOT EXIST wadinfo.txt GOTO fail
echo Extracting resources from HERETIC...
del wadinfo.txt
deutex -rgb 0 255 255 -textures -patches -flats -sounds -musics -levels -xtract heretic.wad >> herpatch.log
IF NOT EXIST wadinfo.txt GOTO fail
IF NOT EXIST .\levels\e4m1.wad GOTO older
echo Extracting resources from DOOM2...
del wadinfo.txt
deutex -rgb 0 255 255 -patches -flats -graphics -sprites -xtract doom2.wad >> herpatch.log
IF NOT EXIST wadinfo.txt GOTO fail
echo Applying custom palette...
move .\lumps\palette.lmp playpal.wad >> herpatch.log
del wadinfo.txt
deutex -xtract playpal.wad >> herpatch.log
IF NOT EXIST wadinfo.txt GOTO fail
deutex -doom . -join doom2.wad playpal.wad >> herpatch.log
echo Extracting skies and graphics from HERPATCH.WAD...
del .\graphics\titlepic.bmp
rem del .\graphics\bossback.bmp
del .\graphics\credit.bmp
del .\graphics\interpic.bmp
del .\graphics\m_doom.bmp
del .\graphics\help.bmp
del .\flats\ceil4_1.bmp
del wadinfo.txt
deutex -doom . -rgb 0 255 255 -patches -graphics -flats -xtract herpatch.wad >> herpatch.log
IF NOT EXIST wadinfo.txt GOTO fail
echo Creating rheresy.wad with HERETIC and DOOM2 resources.
echo Converting DOOM2 graphics to custom palette...
move .\lumps\herspl.lmp herspl.wad >> herpatch.log
del wadinfo.txt
deutex -doom . -rgb 0 255 255 -xtract herspl.wad >> herpatch.log
IF NOT EXIST wadinfo.txt GOTO fail
move .\lumps\herdat.lmp rheretic.dat >> herpatch.log
move .\lumps\hertext1.lmp .\textures\hertext1.txt >> herpatch.log
deutex -doom . -rgb 0 255 255 -make rheretic.dat rheresy.wad >> herpatch.log
IF NOT EXIST rheresy.wad deutex -doom . -res doom2.wad >> herpatch.log
IF NOT EXIST rheresy.wad GOTO fail
echo Converting levels to DOOM2...
move .\lumps\herlev.lmp herlev.dat >> herpatch.log
move .\lumps\shadlev.lmp shadlev.dat >> herpatch.log
deutex -make herlev.dat herlev.wad >> herpatch.log
deutex -make shadlev.dat shadlev.wad >> herpatch.log
move .\lumps\mconvrsp.lmp rheretic.rsp >> herpatch.log
move .\lumps\dm2conv.lmp dm2conv.exe >> herpatch.log
dm2conv herlev.wad @rheretic >> herpatch.log
dm2conv shadlev.wad @rheretic >> herpatch.log
echo Applying critical and miscellaneous patches...
move .\lumps\miscpat.lmp miscpat.bat >> herpatch.log
move .\lumps\cled.lmp cled.exe >> herpatch.log
rem move .\lumps\patcher.lmp patcher.exe >> herpatch.log
call miscpat
echo Appending levels to rheresy.wad...
dm2conv shadlev.wad /remap=28 >> herpatch.log
deutex -join rheresy.wad herlev.wad >> herpatch.log
deutex -join rheresy.wad shadlev.wad >> herpatch.log
echo Appending fonts and title graphics...
move .\lumps\titlegr.lmp titlegr.wad >> herpatch.log
deutex -join rheresy.wad titlegr.wad >> herpatch.log
echo Restoring your DOOM2 iwad...
deutex -doom . -res doom2.wad >> herpatch.log
rem IF NOT EXIST rheresy.wad GOTO fail

:clean
echo Cleaning up...
IF EXIST sounds del .\sounds\*.wav
IF EXIST sounds rd sounds
IF EXIST sounds rd /s /q sounds
IF EXIST textures del .\textures\*.txt
IF EXIST textures rd textures
IF EXIST textures rd /s /q textures
IF EXIST musics del .\musics\*.mus
IF EXIST musics rd musics
IF EXIST musics rd /s /q musics
IF EXIST flats del .\flats\*.bmp
IF EXIST flats rd flats
IF EXIST flats rd /s /q flats
IF EXIST patches del .\patches\*.bmp
IF EXIST patches rd patches
IF EXIST patches rd /s /q patches
IF EXIST levels del .\levels\*.wad
IF EXIST levels rd levels
IF EXIST levels rd /s /q levels
IF EXIST sprites del .\sprites\*.bmp
IF EXIST sprites rd sprites
IF EXIST sprites rd /s /q sprites
IF EXIST graphics del .\graphics\*.bmp
IF EXIST graphics rd graphics
IF EXIST graphics rd /s /q graphics
IF EXIST lumps del .\lumps\*.lmp
IF EXIST lumps rd lumps
IF EXIST lumps rd /s /q lumps
del wadinfo.txt
del rheretic.dat
del herlev.dat
del shadlev.dat
del herspl.wad
del herlev.wad
del shadlev.wad
del playpal.wad
del titlegr.wad
del rheretic.rsp
del dm2conv.exe
del cled.exe
del miscpat.bat
del license
set nowad=
IF EXIST rheresy.wad GOTO pass
IF NOT EXIST rheresy.wad pause

:end
