/*==========================================================================
//  x_score.c -- by various                     Last updated:  4-16-1999
//--------------------------------------------------------------------------
//  This file contains code that displays the various scoreboards in DM.
//  NOTE:  The CTF scoreboards are in "x_ctf.c".
//========================================================================*/

#include "g_local.h"
#include "x_hud.h"
#include "x_score.h"


/*========================/  Scoreboard Toggle  /========================*/

/*----------------------------------------------------/ New Code /--------//
//  This toggles the player's scoreboard display.
//------------------------------------------------------------------------*/
void Coven_ToggleScores (edict_t *ent)
{
        if (!deathmatch->value)
                return;

        if (ent->client->resp.alt_score)
        {       ent->client->resp.alt_score = false;
                gi.cprintf (ent, PRINT_HIGH, "Normal scoreboard\n");
                return;
        }

        ent->client->resp.alt_score = true;
        gi.cprintf (ent, PRINT_HIGH, "Alternate scoreboard\n");
}


/*========================/  Normal Scoreboard  /========================*/

/*----------------------------------------------------/ New Code /--------//
//  Display standard scoreboard.  The twelve best players are shown.
//------------------------------------------------------------------------*/
void Coven_NormalScoreboardMessage (edict_t *ent, edict_t *killer)
{
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		i, j, k;
	int		sorted[MAX_CLIENTS];
	int		sortedscores[MAX_CLIENTS];
	int		score, total;
	int		x, y;
	gclient_t	*cl;
	edict_t		*cl_ent;
	char	*tag;
// COVEN:  Suit mug variables.
        char    mugname[16];
// COVEN

	// sort the clients by score
	total = 0;
	for (i=0 ; i<game.maxclients ; i++)
	{
		cl_ent = g_edicts + 1 + i;
// COVEN:  Count spectators as well.
//                if (!cl_ent->inuse || game.clients[i].resp.spectator)
                if (!cl_ent->inuse)
			continue;
// COVEN
		score = game.clients[i].resp.score;
		for (j=0 ; j<total ; j++)
		{
			if (score > sortedscores[j])
				break;
		}
		for (k=total ; k>j ; k--)
		{
			sorted[k] = sorted[k-1];
			sortedscores[k] = sortedscores[k-1];
		}
		sorted[j] = i;
		sortedscores[j] = score;
		total++;
	}

	// print level name and exit rules
	string[0] = 0;
	stringlength = strlen(string);

	// add the clients in sorted order
	if (total > 12)
		total = 12;

	for (i=0 ; i<total ; i++)
	{
		cl = &game.clients[sorted[i]];
		cl_ent = g_edicts + 1 + sorted[i];

		x = (i>=6) ? 160 : 0;
		y = 32 + 32 * (i%6);

		// add a dogtag
		if (cl_ent == ent)
			tag = "tag1";
		else if (cl_ent == killer)
			tag = "tag2";
		else
			tag = NULL;
		if (tag)
		{
			Com_sprintf (entry, sizeof(entry),
				"xv %i yv %i picn %s ",x+32, y, tag);
			j = strlen(entry);
			if (stringlength + j > 1024)
				break;
			strcpy (string + stringlength, entry);
			stringlength += j;
		}

		// send the layout
// COVEN:  Draw suit mug over PPM mug.
                Coven_MugName (mugname, cl_ent, true);

		Com_sprintf (entry, sizeof(entry),
                        "client %i %i %i %i %i %i xv %i yv %i picn %s ",
                        x, y, sorted[i], cl->resp.score, cl->ping, (level.framenum - cl->resp.enterframe)/600, x, y, mugname);
// COVEN
		j = strlen(entry);
		if (stringlength + j > 1024)
			break;
		strcpy (string + stringlength, entry);
		stringlength += j;
	}

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}


/*=========================/  Team Scoreboard  /=========================*/

/*----------------------------------------------------/ New Code /--------//
//  Display scoreboard for team Armourback.  The scoreboard displays
//  team information plus the scores of up to ten more players.
//------------------------------------------------------------------------*/
void Coven_TeamScoreboardMessage (edict_t *ent, edict_t *killer)
{
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		i, j, k;
	int		sorted[MAX_CLIENTS];
	int		sortedscores[MAX_CLIENTS];
	int		score, total;
	int		x, y;
	gclient_t	*cl;
	edict_t		*cl_ent;
/////////
	char	*tag;
        int     sizeindex[MAX_AB_SKINS];
        int     fragindex[MAX_AB_SKINS];
        char    mugname[16];
/////////

        for (i=0; i<MAX_AB_SKINS; i++)
        {       sizeindex[i] = 0;
                fragindex[i] = 0;
        }

	// sort the clients by score
	total = 0;
	for (i=0 ; i<game.maxclients ; i++)
	{
		cl_ent = g_edicts + 1 + i;
		if (!cl_ent->inuse)
			continue;

                cl = &game.clients[i];
                sizeindex[cl->resp.suitcolor]++;
                fragindex[cl->resp.suitcolor] += cl->resp.score;

		score = game.clients[i].resp.score;
		for (j=0 ; j<total ; j++)
		{
			if (score > sortedscores[j])
				break;
		}
		for (k=total ; k>j ; k--)
		{
			sorted[k] = sorted[k-1];
			sortedscores[k] = sortedscores[k-1];
		}
		sorted[j] = i;
		sortedscores[j] = score;
		total++;
	}

	// print level name and exit rules
	string[0] = 0;
	stringlength = strlen(string);

/////////
        if (ab_teams == 2)
        {        Com_sprintf (entry, sizeof(entry),
                        "xv 0 yv 32 picn teaminfo "
                        "xv 56 yv 46 string \"%4i %4i\" "
                        "xv 56 yv 54 string \"%4i %4i\" ",
                        sizeindex[1], sizeindex[2],
                        fragindex[1], fragindex[2]);
        }
        else if (ab_teams == 3)
        {        Com_sprintf (entry, sizeof(entry),
                        "xv 0 yv 32 picn teaminfo "
                        "xv 56 yv 46 string \"%4i %4i %4i\" "
                        "xv 56 yv 54 string \"%4i %4i %4i\" ",
                        sizeindex[1], sizeindex[2], sizeindex[3],
                        fragindex[1], fragindex[2], fragindex[3]);
        }
        else if (ab_teams == 4)
        {        Com_sprintf (entry, sizeof(entry),
                        "xv 0 yv 32 picn teaminfo "
                        "xv 56 yv 46 string \"%4i %4i %4i %4i\" "
                        "xv 56 yv 54 string \"%4i %4i %4i %4i\" ",
                        sizeindex[1], sizeindex[2], sizeindex[3], sizeindex[4],
                        fragindex[1], fragindex[2], fragindex[3], fragindex[4]);
        }
        else //if (ab_teams == 5)
        {        Com_sprintf (entry, sizeof(entry),
                        "xv 0 yv 32 picn teaminfo "
                        "xv 56 yv 46 string \"%4i %4i %4i %4i %4i\" "
                        "xv 56 yv 54 string \"%4i %4i %4i %4i %4i\" ",
                        sizeindex[1], sizeindex[2], sizeindex[3], sizeindex[4], sizeindex[5],
                        fragindex[1], fragindex[2], fragindex[3], fragindex[4], fragindex[5]);
        }
        j = strlen(entry);
        if (stringlength + j > 1024)
                return;
        strcpy (string + stringlength, entry);
        stringlength += j;
/////////
        // If level is over, point to the winning team.
        if (level.intermissiontime && winning_team)
        {       // PM:  Draw little green arrow pointing to winning team.
                x = 40 * winning_team + 16;
                y = 34;
                Com_sprintf (entry, sizeof(entry),
                        "xv %i yv %i string \"\" ", x, y);
                j = strlen(entry);
                if (stringlength + j > 1024)
                        return;
                strcpy (string + stringlength, entry);
                stringlength += j;
        }
/////////

	// add the clients in sorted order
        if (total > 10)
                total = 10;

	for (i=0 ; i<total ; i++)
	{
		cl = &game.clients[sorted[i]];
		cl_ent = g_edicts + 1 + sorted[i];

                x = (i>=5) ? 160 : 0;
                y = 64 + 32 * (i%5);

		// add a dogtag
		if (cl_ent == ent)
                        tag = "tag1";
		else if (cl_ent == killer)
                        tag = "tag2";
		else
			tag = NULL;
		if (tag)
		{
                        Com_sprintf (entry, sizeof(entry),
                                "xv %i yv %i picn %s ",x+32, y, tag);
			j = strlen(entry);
			if (stringlength + j > 1024)
				break;
			strcpy (string + stringlength, entry);
			stringlength += j;
		}

		// send the layout
/////////
                Coven_MugName (mugname, cl_ent, true);

		Com_sprintf (entry, sizeof(entry),
                        "client %i %i %i %i %i %i xv %i yv %i picn %s ",
                        x, y, sorted[i], cl->resp.score, cl->ping, (level.framenum - cl->resp.enterframe)/600, x, y, mugname);
/////////
		j = strlen(entry);
		if (stringlength + j > 1024)
			break;
		strcpy (string + stringlength, entry);
		stringlength += j;
	}

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}

/*----------------------------------------------------/ New Code /--------//
//  Display text only scoreboard for team Armourback.  The scoreboard
//  displays team information plus the scores of up to ten more players.
//  Display text only scoreboard.  Up to 32 players are shown.
//------------------------------------------------------------------------*/
void Coven_TeamAltScoreboardMessage (edict_t *ent, edict_t *killer)
{
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	int		i, j, k;
	int		sorted[MAX_CLIENTS];
	int		sortedscores[MAX_CLIENTS];
	int		score, total;
	int		x, y;
	gclient_t	*cl;
	edict_t		*cl_ent;
/////////
	char	*tag;
        int     sizeindex[MAX_AB_SKINS];
        int     fragindex[MAX_AB_SKINS];
        char    mugname[16];
/////////

        for (i=0; i<MAX_AB_SKINS; i++)
        {       sizeindex[i] = 0;
                fragindex[i] = 0;
        }

	// sort the clients by score
	total = 0;
	for (i=0 ; i<game.maxclients ; i++)
	{
		cl_ent = g_edicts + 1 + i;
		if (!cl_ent->inuse)
			continue;

                cl = &game.clients[i];
                sizeindex[cl->resp.suitcolor]++;
                fragindex[cl->resp.suitcolor] += cl->resp.score;

                // Show only team members.
                if (cl->resp.suitcolor != ent->client->resp.suitcolor)
			continue;

		score = game.clients[i].resp.score;
		for (j=0 ; j<total ; j++)
		{
			if (score > sortedscores[j])
				break;
		}
		for (k=total ; k>j ; k--)
		{
			sorted[k] = sorted[k-1];
			sortedscores[k] = sortedscores[k-1];
		}
		sorted[j] = i;
		sortedscores[j] = score;
		total++;
	}

	// print level name and exit rules
	string[0] = 0;
	stringlength = strlen(string);

/////////
        if (ab_teams == 2)
        {        Com_sprintf (entry, sizeof(entry),
                        "xv 0 yv 32 picn teaminfo "
                        "xv 56 yv 46 string \"%4i %4i\" "
                        "xv 56 yv 54 string \"%4i %4i\" ",
                        sizeindex[1], sizeindex[2],
                        fragindex[1], fragindex[2]);
        }
        else if (ab_teams == 3)
        {        Com_sprintf (entry, sizeof(entry),
                        "xv 0 yv 32 picn teaminfo "
                        "xv 56 yv 46 string \"%4i %4i %4i\" "
                        "xv 56 yv 54 string \"%4i %4i %4i\" ",
                        sizeindex[1], sizeindex[2], sizeindex[3],
                        fragindex[1], fragindex[2], fragindex[3]);
        }
        else if (ab_teams == 4)
        {        Com_sprintf (entry, sizeof(entry),
                        "xv 0 yv 32 picn teaminfo "
                        "xv 56 yv 46 string \"%4i %4i %4i %4i\" "
                        "xv 56 yv 54 string \"%4i %4i %4i %4i\" ",
                        sizeindex[1], sizeindex[2], sizeindex[3], sizeindex[4],
                        fragindex[1], fragindex[2], fragindex[3], fragindex[4]);
        }
        else //if (ab_teams == 5)
        {        Com_sprintf (entry, sizeof(entry),
                        "xv 0 yv 32 picn teaminfo "
                        "xv 56 yv 46 string \"%4i %4i %4i %4i %4i\" "
                        "xv 56 yv 54 string \"%4i %4i %4i %4i %4i\" ",
                        sizeindex[1], sizeindex[2], sizeindex[3], sizeindex[4], sizeindex[5],
                        fragindex[1], fragindex[2], fragindex[3], fragindex[4], fragindex[5]);
        }
        j = strlen(entry);
        if (stringlength + j > 1024)
                return;
        strcpy (string + stringlength, entry);
        stringlength += j;
/////////
        // If level is over, point to the winning team.
        if (level.intermissiontime && winning_team)
        {       // PM:  Draw little green arrow pointing to winning team.
                x = 40 * winning_team + 16;
                y = 34;
                Com_sprintf (entry, sizeof(entry),
                        "xv %i yv %i string \"\" ", x, y);
                j = strlen(entry);
                if (stringlength + j > 1024)
                        return;
                strcpy (string + stringlength, entry);
                stringlength += j;
        }
/////////

	// add the clients in sorted order
        if (total > 10)
                total = 10;

	for (i=0 ; i<total ; i++)
	{
		cl = &game.clients[sorted[i]];
		cl_ent = g_edicts + 1 + sorted[i];

                x = (i>=5) ? 160 : 0;
                y = 64 + 32 * (i%5);

		// add a dogtag
		if (cl_ent == ent)
                        tag = "tag1";
		else if (cl_ent == killer)
                        tag = "tag2";
		else
			tag = NULL;
		if (tag)
		{
                        Com_sprintf (entry, sizeof(entry),
                                "xv %i yv %i picn %s ",x+32, y, tag);
			j = strlen(entry);
			if (stringlength + j > 1024)
				break;
			strcpy (string + stringlength, entry);
			stringlength += j;
		}

		// send the layout
/////////
                Coven_MugName (mugname, cl_ent, true);

		Com_sprintf (entry, sizeof(entry),
                        "client %i %i %i %i %i %i xv %i yv %i picn %s ",
                        x, y, sorted[i], cl->resp.score, cl->ping, (level.framenum - cl->resp.enterframe)/600, x, y, mugname);
/////////
		j = strlen(entry);
		if (stringlength + j > 1024)
			break;
		strcpy (string + stringlength, entry);
		stringlength += j;
	}

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}


/*===========================/  END OF FILE  /===========================*/
