/*==========================================================================
//  x_newent.c -- by Patrick Martin             Last updated:  4-14-1999
//
//  (Teleporter brush code written by Warren Marshall.)
//--------------------------------------------------------------------------
//  This file contains code that creates Quake1 style light decor
//  (e.g., flames) and teleporter brushes.
//========================================================================*/

#include "g_local.h"
#include "x_newent.h"


/*=============================/  Torches  /=============================*/

/*QUAKED light_torch_small_walltorch (0 .5 0) (-4 -4 -16) (4 4 32)
Short wall torch.  Quake1 style.
*/

void small_walltorch_animate (edict_t *self)
{
        if (++self->s.frame > FRAME_LAST_WALLTORCH)
                self->s.frame = FRAME_FIRST_TORCH;

	self->nextthink = level.time + FRAMETIME;
}

void SP_light_torch_small_walltorch (edict_t *ent)
{
	ent->movetype     = MOVETYPE_NONE;
	ent->solid        = SOLID_NOT;
	VectorSet (ent->mins, -4, -4, 16);
	VectorSet (ent->maxs, 4, 4, 32);
        ent->s.modelindex = MD2_WALLTORCH;
        ent->s.frame      = FRAME_FIRST_TORCH + (rand() % (FRAME_LAST_WALLTORCH - FRAME_FIRST_TORCH + 1));
        ent->s.skinnum    = 0;
	ent->s.renderfx   = RF_FULLBRIGHT;
        ent->s.sound      = WAV_FIRE;
        ent->think        = small_walltorch_animate;
	ent->nextthink    = level.time + FRAMETIME;
	gi.linkentity (ent);
}

/*QUAKED light_torch_small_bowltorch (0 .5 0) (-3 -3 -4) (3 3 16)
Short bowl torch.  .md2 done by Andrew.
*/

void small_bowltorch_animate (edict_t *self)
{
        if (++self->s.frame > FRAME_LAST_BOWLTORCH)
                self->s.frame = FRAME_FIRST_TORCH;

	self->nextthink = level.time + FRAMETIME;
}

void SP_light_torch_small_bowltorch (edict_t *ent)
{
	ent->movetype     = MOVETYPE_NONE;
	ent->solid        = SOLID_NOT;
	VectorSet (ent->mins, -3, -3, -4);
	VectorSet (ent->maxs, 3, 3, 16);
        ent->s.modelindex = MD2_BOWLTORCH;
        ent->s.frame      = FRAME_FIRST_TORCH + (rand() % (FRAME_LAST_BOWLTORCH - FRAME_FIRST_TORCH + 1));
        ent->s.skinnum    = 0;
	ent->s.renderfx   = RF_FULLBRIGHT;
        ent->s.sound      = WAV_FIRE;
        ent->think        = small_bowltorch_animate;
	ent->nextthink    = level.time + FRAMETIME;
	gi.linkentity (ent);
}


/*=============================/  Flames  /=============================*/

/*QUAKED light_flame_large_yellow (0 1 0) (-8 -8 0) (8 8 64)
This is for large Quake1 style flames.
*/

void large_flame_animate (edict_t *self)
{
        if (++self->s.frame > FRAME_FIRE_fireb12)
                self->s.frame = FRAME_FIRE_fireb1;

	self->nextthink = level.time + FRAMETIME;
}

void SP_light_flame_large_yellow (edict_t *ent)
{
	ent->movetype     = MOVETYPE_NONE;
	ent->solid        = SOLID_NOT;
	VectorSet (ent->mins, -8, -8, 0);
	VectorSet (ent->maxs, 8, 8, 64);

// Carnage2 map hack...
        if (Q_stricmp(level.mapname, "c2dm02") == 0)
                ent->s.origin[2] -= 12;

        ent->s.modelindex = MD2_FIRE;
        ent->s.frame      = FRAME_FIRE_fireb1 + (rand() % (FRAME_FIRE_fireb12 - FRAME_FIRE_fireb1 + 1));
        ent->s.skinnum    = SKIN_FIRE_skin;
	ent->s.renderfx   = RF_FULLBRIGHT;
        ent->s.sound      = WAV_FIRE;
	ent->think        = large_flame_animate;
	ent->nextthink    = level.time + FRAMETIME;
	gi.linkentity (ent);
}

/*QUAKED light_flame_small_yellow (0 1 0) (-4 -4 0) (4 4 32)
This is for small Quake1 style flames.
*/

void small_flame_animate (edict_t *self)
{
        if (++self->s.frame > FRAME_FIRE_fire12)
                self->s.frame = FRAME_FIRE_fire1;

	self->nextthink = level.time + FRAMETIME;
}

void SP_light_flame_small_yellow (edict_t *ent)
{
	ent->movetype     = MOVETYPE_NONE;
	ent->solid        = SOLID_NOT;
	VectorSet (ent->mins, -4, -4, 0);
	VectorSet (ent->maxs, 4, 4, 32);
        ent->s.modelindex = MD2_FIRE;
        ent->s.frame      = FRAME_FIRE_fire1 + (rand() % (FRAME_FIRE_fire12 - FRAME_FIRE_fire1 + 1));
        ent->s.skinnum    = SKIN_FIRE_skin;
	ent->s.renderfx   = RF_FULLBRIGHT;
        ent->s.sound      = WAV_FIRE;
	ent->think        = small_flame_animate;
	ent->nextthink    = level.time + FRAMETIME;
	gi.linkentity (ent);
}

/*QUAKED light_flame_small_white (0 1 0) (-4 -4 0) (4 4 32)
This is for small Quake1 style flames.  I could not tell the
difference between it and its yellow brother in Quake1.
*/

void SP_light_flame_small_white (edict_t *ent)
{
	SP_light_flame_small_yellow (ent);
}


/*============================/  Lavaballs  /============================*/

/*QUAKED misc_fireball (0 .5 .8) (-8 -8 -8) (8 8 8)
Lava Balls
*/

void lavaball_touch
(edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
        T_Damage (other, self, self, self->velocity, self->s.origin, self->velocity, self->dmg, self->dmg, 0, MOD_LAVABALL);
	G_FreeEdict (self);
}

void lavaball_toss (edict_t *self)
{
	edict_t   *lavaball;

	lavaball = G_Spawn();
	VectorCopy (self->s.origin, lavaball->s.origin);
	VectorSet (lavaball->velocity, 0, 0, 1000);
	lavaball->velocity[0]  = random() * 100 - 50;
	lavaball->velocity[1]  = random() * 100 - 50;
	lavaball->velocity[2]  = random() * 200 + self->speed;
	lavaball->movetype     = MOVETYPE_TOSS;
	lavaball->clipmask     = MASK_SHOT;
	lavaball->solid        = SOLID_BBOX;   /* Was SOLID_TRIGGER in Q1. */
	lavaball->s.effects    = EF_ROCKET;
	lavaball->classname    = "fireball";
	VectorClear (lavaball->mins);
	VectorClear (lavaball->maxs);
        lavaball->s.modelindex = MD2_LAVABALL;
	lavaball->touch        = lavaball_touch;
	lavaball->nextthink    = level.time + 5;
	lavaball->think        = G_FreeEdict;
	lavaball->dmg          = self->dmg;

	gi.linkentity (lavaball);

/* Throw another lava ball soon. */
	self->nextthink = level.time + (random() * 5) + 3;
}

void SP_misc_fireball (edict_t *ent)
{
	ent->movetype     = MOVETYPE_NONE;
	ent->solid        = SOLID_NOT;
	VectorSet (ent->mins, -8, -8, -8);
	VectorSet (ent->maxs, 8, 8, 8);
	if (!ent->dmg)
		ent->dmg = 20;
	if (!ent->speed)
		ent->speed = 1000;
	ent->think        = lavaball_toss;
	ent->nextthink    = level.time + (random() * 5);
	gi.linkentity (ent);
}


/*=========================/  Teleport Brushes /=========================*/

/*-----/ Prototypes for code in 'g_trigger.' /-----*/
extern void multi_trigger (edict_t *ent);
extern void Use_Multi (edict_t *ent, edict_t *other, edict_t *activator);
extern void trigger_enable (edict_t *self, edict_t *other, edict_t *activator);
/*-------------------------------------------------*/


qboolean Coven_TeleKillBox (edict_t *ent)
{
	trace_t		tr;

	while (1)
	{
		tr = gi.trace (ent->s.origin, ent->mins, ent->maxs, ent->s.origin, NULL, MASK_PLAYERSOLID);
		if (!tr.ent)
			break;

        // If player is in killbox, and teleporting entity is a monster,
        // the killbox is broken, and the monster is telefragged.
        // Otherwise, anything solid in the killbox is destroyed.
                if ((tr.ent->client) && (!ent->client))
                {       gi.linkentity (ent);
                        T_Damage (ent, ent, ent, vec3_origin, ent->s.origin, vec3_origin, 100000, 0, DAMAGE_NO_PROTECTION, MOD_TELEFRAG);
                        return false;
                }
                else
                {       T_Damage (tr.ent, ent, ent, vec3_origin, ent->s.origin, vec3_origin, 100000, 0, DAMAGE_NO_PROTECTION, MOD_TELEFRAG);
                        if (tr.ent->solid)
                        {       gi.linkentity (ent);
                                return false;
                        }
                }
	}

// All clear.
        gi.linkentity (ent);
        return true;
}


/*
----------------------------------------------------------------------
     All the following code was written by Warren Marshall.
     (Though I did modify parts of it.)
----------------------------------------------------------------------
*/


/*QUAKED coven_trigger_teleport (.5 .5 .5) ? MONSTER NOT_PLAYER TRIGGERED
Variable sized repeatable trigger.  Must be targeted at an 
"info_teleporter_dest".  If "delay" is set, the trigger waits some 
time after activating before firing.
"wait" : Seconds between triggerings. (.2 default)

Spawnflags
==========
MONSTER    - Allow monsters to use teleporter.
NOT_PLAYER - Player can't use it?
TRIGGERED  - Not active until something else triggers it.
*/

enum eCTTTOUCH {
	eCTTTOUCH_MONSTER		= 1,
	eCTTTOUCH_NOT_PLAYER	= 2
};

// Modified by PM to work with Q2 PR (Point Release).
void Coven_CTT_Touch (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf)
{
	edict_t *dest;
	int i;

// Make sure that the entity touching it is allowed to.
        if (!strcmp(other->classname, "player"))
        {       if (self->spawnflags & eCTTTOUCH_NOT_PLAYER)
			return;
	}
        else
        {       if (!(other->svflags & SVF_MONSTER))
                        return;

                if(!(self->spawnflags & eCTTTOUCH_MONSTER))
                        return;
	}

// Locate the teleporter destination.
	dest = G_Find(NULL, FOFS(targetname), self->target);

        if (!dest)
        {       gi.dprintf ("Couldn't find destination\n");
		return;
	}

// Unlink to make sure it can't possibly interfere with Coven_TeleKillBox.
        gi.unlinkentity (other);

// Change the players position to the destination point and lift them
// up a little.
	VectorCopy (dest->s.origin, other->s.origin);
        VectorCopy (dest->s.origin, other->s.old_origin);
        other->s.origin[2] += 10;

// Clear velocity
        VectorClear (other->velocity);

// If entity is a player, hold him or her in place briefly.
        if (other->client)
        {       other->client->ps.pmove.pm_time = 160>>3;       // hold time
                other->client->ps.pmove.pm_flags |= PMF_TIME_TELEPORT;
        }

// Draw the teleport splash at the destination
	other->s.event = EV_PLAYER_TELEPORT;

// Set angles
        if (other->client)
        {
                for (i=0 ;i<3 ;i++)
                        other->client->ps.pmove.delta_angles[i] = ANGLE2SHORT(dest->s.angles[i] - other->client->resp.cmd_angles[i]);

                VectorClear (other->s.angles);
                VectorClear (other->client->ps.viewangles);
                VectorClear (other->client->v_angle);
        }
        else
                VectorClear (other->s.angles);


// Kill anything at the destination.  Entity is automatically
// relinked in 'Coven_TeleKillBox'
        Coven_TeleKillBox (other);

// Warren, what does this do?
	self->activator = other;
	multi_trigger (self);
}

/*QUAKED coven_trigger_teleport (.5 .3 0) ?
Serves as the destination of a "coven_trigger_teleport".
*/
void SP_coven_trigger_teleport(edict_t *ent)
{
	// Make sure we have a good target.
	//
	if (!ent->target)
	{
		gi.dprintf ("coven_trigger_teleport without a target.\n");
		G_FreeEdict (ent);
		return;
	}

	// If no wait value was specified, use the default.
	//
	if(!ent->wait) {
		ent->wait = 0.2;
	}

	ent->touch = Coven_CTT_Touch;
	ent->movetype = MOVETYPE_NONE;
	ent->svflags |= SVF_NOCLIENT;

	// If this is a "triggered" entity then wait until we're triggered before
	// becoming active.
	//
	if(ent->spawnflags & 4) {

		ent->solid = SOLID_NOT;
		ent->use = trigger_enable;
	}
	else {

		ent->solid = SOLID_TRIGGER;
		ent->use = Use_Multi;
	}

	// ???
	//
	if(!VectorCompare(ent->s.angles, vec3_origin)) {

		G_SetMovedir(ent->s.angles, ent->movedir);
	}

	gi.setmodel(ent, ent->model);
	gi.linkentity(ent);
}


/*QUAKED coven_teleport_dest (.5 .3 0) (-16 -16 -24) (16 16 32)
Serves as the destination of a "coven_trigger_teleport".
*/

void SP_coven_teleport_dest (edict_t *self)
{
	// If we're not being targetted, tell the player...
	//
	if(!self->targetname) {

		gi.dprintf ("coven_teleport_dest with no targetname at %s\n", vtos(self->s.origin));
		G_FreeEdict (self);
		return;
	}

	self->solid = SOLID_NOT;
	//VectorSet(self->mins, -16, -16, -24);
	//VectorSet(self->maxs, 16, 16, 32);
	self->svflags |= SVF_NOCLIENT;
	gi.linkentity (self);
}


/*===========================/  END OF FILE  /===========================*/
