/*==========================================================================
//  x_hud.h -- by various                       Last updated:  4-15-1999
//--------------------------------------------------------------------------
//  This is the header for x_hud.c.
//========================================================================*/

/***************/
/*  CONSTANTS  */
/***************/

#define STAT_CROSSHAIRS         18
#define STAT_ID_NAME            19
#define STAT_ID_MUG             20
#define STAT_ID_METER           21
#define STAT_CTF_TECH           22
#define STAT_TIMETOSTART_SEC    23

// Arena/Capture only stats.
#define STAT_CA_ARUNE           24
#define STAT_CA_DRUNE           25
#define STAT_CA_HRUNE           26

// CTF only stats.
#define STAT_CTF_TEAM1_PIC      24
#define STAT_CTF_TEAM1_CAPS     25
#define STAT_CTF_TEAM2_PIC      26
#define STAT_CTF_TEAM2_CAPS     27
#define STAT_CTF_JOINED_TEAM1_PIC       28
#define STAT_CTF_JOINED_TEAM2_PIC       29
#define STAT_CTF_TEAM1_HEADER   30
#define STAT_CTF_TEAM2_HEADER   31


/****************/
/*  PROTOTYPES  */
/****************/

/*
// x_hud.c
*/
void Coven_MugName (char *mugname, edict_t *ent, qboolean scoreboard);
int Coven_MugIndex (edict_t *ent, qboolean rip);

void Coven_ClearID (edict_t *ent);
void Coven_ShowID (edict_t *targ, edict_t *ent, int metres);
void Coven_TargetID (edict_t *ent);
void Coven_ToggleID (edict_t *ent);
qboolean Coven_NoID (edict_t *ent);

static void Coven_ACStats (edict_t *ent);
static void Coven_CTFHUD (edict_t *ent);
void Coven_ArmourBackHUD (edict_t *ent);


/*
// x_team.c
*/
extern qboolean Coven_OnSameSide (edict_t *targ, edict_t *attacker);


/*===========================/  END OF FILE  /===========================*/
