/*==========================================================================
//  x_guns.h -- by Patrick Martin               Last updated:  3-6-1999
//--------------------------------------------------------------------------
//  This file contains code that dictates the properties of the
//  various guns in the Armorback patch.
//========================================================================*/

/****************/
/*  PROTOTYPES  */
/****************/

/*
// x_guns.c
*/
void Coven_ProjectGunSource
 (gclient_t *client, vec3_t point, vec3_t distance, vec3_t forward,
  vec3_t right, vec3_t result);
void Coven_CheckDodge (edict_t *self, vec3_t start, vec3_t dir, int speed);
void Coven_ThrowThing (edict_t *ent, vec3_t dir, int knockback);

void Coven_PushIt
 (edict_t *self, vec3_t start, vec3_t aimdir, int range);
void Coven_PlayerPush (edict_t *self, int range);

void Coven_AntiExplodeThink (edict_t *self);
void Coven_AntiRadius
 (edict_t *inflictor, edict_t *attacker, int die, int base, edict_t *ignore,
  float radius);
void Coven_SpawnAntimatter
 (edict_t *attacker, edict_t *ignore, vec3_t spot, int die, int base,
  float radius);
void Coven_FireBeam
 (edict_t *self, vec3_t start, vec3_t aimdir, vec3_t spread, vec3_t damage,
  int range);

void Coven_ProdBoltTouch
 (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
void Coven_FirePoker
 (edict_t *self, vec3_t start, vec3_t aimdir, int range, int damage,
  int blast_damage);

void Coven_PhotonStorm
 (edict_t *targ, edict_t *attacker, vec3_t start, vec3_t storm, int limit);
void Coven_SpawnZapper (edict_t *attacker, vec3_t origin, vec3_t storm);
void Coven_PX_Think (edict_t *self);
void Coven_PhotonExplosion (vec3_t origin);
void Coven_FirePhoton
 (edict_t *self, vec3_t start, vec3_t center, vec3_t aimdir, vec3_t storm,
  int damage, int limit);

void Coven_FireSaw
(edict_t *self, vec3_t start, vec3_t aimdir, int damage, int range,
 qboolean kill);


/*===========================/  END OF FILE  /===========================*/
