/*==========================================================================
//  x_fire.h -- by Patrick Martin               Last updated:  2-28-1998
//--------------------------------------------------------------------------
//  This is the header file for the x_fire*.c files.
//
//  The Napalm2 code uses my custom flame model.  It is similar to
//  (but NOT the same as) the flame2.mdl in Quake 1.
//========================================================================*/

#include "x_firemd.h"


/***************/
/*  CONSTANTS  */
/***************/

/* Time in seconds the entity on fire will burn. */
#define BURN_TIME              30
#define BURN_DM_TIME    100000000

/* Default radius for fire splash damage. */
#define RADIUS_FIRE_SPLASH     80

/* Default dropped flame duration. */
#define FLAME_TIME              2
#define FLAME_EXTRA_TIME        3

/* Default firestorm attributes. */
#define FIRESTORM_DELAY         0.7
#define FIRESTORM_DURATION      4
#define FIRESTORM_RADIUS       64

/* Maximum number of firestorms a player can have at a time. */
#define MAX_FIRESTORMS          2

/* Fireflags.
        SHIFT_Z      =  Vertical flame shift.
        DOWN         =  Shift flame down, not up.
        DELTA_ALIVE  =  Adjust only if target is alive.
        DELTA_BASE   =  Base adjustments (+4 if alive, -18 if dead).
        DELTA_VIEW   =  Adjust w/ viewheight (clients only).
        IGNITE       =  Target can ignite.
*/
#define FIREFLAG_SHIFT_Z        0x000000ff
#define FIREFLAG_DOWN           0x00000100
#define FIREFLAG_DELTA_ALIVE    0x00000200
#define FIREFLAG_DELTA_BASE     0x00000400
#define FIREFLAG_DELTA_VIEW     0x00000800
#define FIREFLAG_IGNITE         0x00001000

/* Important frames in my flame model. */
#define FRAME_FIRST_SMALLIGNITE   0
#define FRAME_LAST_SMALLIGNITE    2
#define FRAME_FIRST_SMALLFIRE     3
#define FRAME_LAST_SMALLFIRE     14
#define FRAME_FIRST_LARGEIGNITE  15
#define FRAME_LAST_LARGEIGNITE   20
#define FRAME_FIRST_LARGEFIRE    21
#define FRAME_LAST_LARGEFIRE     32
#define FRAME_FIRST_FLARE        33
#define FRAME_LAST_FLARE         38
#define FRAME_FLAMEOUT           39


/****************/
/*  PROTOTYPES  */
/****************/

/*
// g_combat.c
*/
qboolean CheckTeamDamage (edict_t *targ, edict_t *attacker);


/*
// x_fire1.c
// Core burn code
*/
void     Coven_CacheFire (void);
void     Coven_KillAllFires (void);
qboolean Coven_NeedSpeed (void);

void     Coven_MakeSmoke (vec3_t spot);
void     Coven_BecomeSmoke (edict_t *self);
void     Coven_BecomeSteam (edict_t *self);
void     Coven_FastSmallExplodeThink (edict_t *self);
void     Coven_SmallExplodeThink (edict_t *self);
void     Coven_StartSmallExplosion (edict_t *self);
void     Coven_BecomeSmallExplosion (edict_t *self);

qboolean Coven_InWater (edict_t *ent);
qboolean Coven_Inflammable (edict_t *ent);
qboolean Coven_ActivePowerArmor (edict_t *ent, vec3_t point);
qboolean Coven_FireResistant (edict_t *ent, vec3_t point);
qboolean Coven_NoFriendlyFire (edict_t *victim, edict_t *attacker);

void     Coven_BurnDamage
 (edict_t *victim, edict_t *fire, vec3_t point, vec3_t normal,
  vec3_t damage, int dflags, int mod);
void     Coven_BurnRadius
 (edict_t *fire, float radius, vec3_t damage, edict_t *ignore, int mod);

void     Coven_CheckMaster (edict_t *fire);
void     Coven_FireSpot (vec3_t spot, edict_t *ent);
qboolean Coven_FlameOut (edict_t *self);
void     Coven_Burn (edict_t *self);
void     Coven_Ignite (edict_t *victim, edict_t *attacker, vec3_t point);


/*
// x_fire2.c
// Pyrotechnics
*/
void     Coven_CheckFire (edict_t *self);
void     Coven_FireDropTouch
 (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
void     Coven_FireDrop
 (edict_t *attacker, vec3_t spot, vec3_t damage, vec3_t radius_damage,
  float duration_base, int blast_chance, int mod_strike, int mod_splash);
void     Coven_EasyFireDrop (edict_t *self);

void     Coven_CloudBurst (edict_t *self);
void     Coven_CloudBurstDamage (edict_t *self);
void     Coven_FlameCloud
 (edict_t *attacker, vec3_t start, vec3_t cloud, vec3_t timer,
  vec3_t damage, vec3_t radius_damage, int rain_chance, int blast_chance);

void     Coven_RemoveFireStorm (edict_t *self);
void     Coven_FireStormThink (edict_t *self);
void     Coven_LinkFireStorm (edict_t *self);
void     Coven_CreateFireStorm
 (edict_t *attacker, vec3_t start, vec3_t damage, vec3_t radius_damage,
  vec3_t dim);

qboolean Coven_CanDamageFromPoint (edict_t *targ, vec3_t point);
void     Coven_FlashRadius
 (edict_t *attacker, vec3_t origin, float damage, vec3_t radii,
  edict_t *ignore, int mod);
void     Coven_FlashEffects (vec3_t p1, vec3_t p2);
void     Coven_FlashExplosion
 (edict_t *attacker, vec3_t p1, vec3_t p2, float damage, vec3_t radii,
  edict_t *ignore, int mod);


/*
// x_fire3.c
// Generic fire-based attacks.
*/
void     Coven_CheckFireDodge
 (edict_t *self, vec3_t start, vec3_t dir, int speed);

void     Coven_FireAngleSpread (vec3_t spread, vec3_t dir);
void     Coven_SpreadConverter (vec3_t spread, float hspread, float vspread);

void     Coven_FireballTouch
 (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
void     Coven_FireFlamer
 (edict_t *self, vec3_t start, vec3_t spread, vec3_t dir, int speed,
  vec3_t damage, vec3_t radius_damage, int rain_chance, int blast_chance,
  int mod_strike, int mod_splash);
void     Coven_FireInstantFlamer
 (edict_t *attacker, vec3_t start, vec3_t spread, vec3_t aimdir,
  vec3_t damage, vec3_t radius_damage, int rain_chance, int blast_chance,
  int mod_strike, int mod_splash);
void     Coven_FireExplosiveBurst
 (edict_t *self, vec3_t start, vec3_t spread, vec3_t aimdir, vec3_t damage,
  vec3_t radius_damage, int rain_chance, int blast_chance, int count,
  int mod_strike, int mod_splash);

void     Coven_FlameThrowerTouch
 (edict_t *self, edict_t *other, cplane_t *plane, csurface_t *surf);
void     Coven_FlameThrowerThink (edict_t *self);
void     Coven_FireFlameThrower
 (edict_t *self, vec3_t start, vec3_t spread, vec3_t dir, int speed,
  vec3_t damage, vec3_t radius_damage, int rain_chance, int blast_chance,
  int mod_strike, int mod_splash);

static void Coven_FireIncendiaryRound
 (edict_t *self, vec3_t start, vec3_t aimdir, int damage, int kick,
  int burn_chance, int te_impact, int hspread, int vspread, int mod);
void Coven_FireFlameBullet (edict_t *self, vec3_t start, vec3_t aimdir,
 int damage, int kick, int burn_chance, int hspread, int vspread, int mod);
void Coven_FireFlameShotgun (edict_t *self, vec3_t start, vec3_t aimdir,
 int damage, int kick, int burn_chance, int hspread, int vspread,
 int count, int mod);


/*===========================/  END OF FILE  /===========================*/
