// (PM):  Last updated on 2-1-1999.
// This file is based on "g_ctf.h" of Q2 3.14 source.
// The source has been heavily modified so that it
// can work with ArmourBack for Q2 3.20.

/***************/
/*  CONSTANTS  */
/***************/

// ArmourBack team colors
#define CTF_NOTEAM      0
#define CTF_TEAM1       1
#define CTF_TEAM2       2

typedef enum {
	CTF_STATE_START,
	CTF_STATE_PLAYING
} ctfstate_t;

#define CTF_CAPTURE_BONUS		15	// what you get for capture
#define CTF_TEAM_BONUS			10	// what your team gets for capture
#define CTF_RECOVERY_BONUS		1	// what you get for recovery
#define CTF_FLAG_BONUS			0	// what you get for picking up enemy flag
#define CTF_FRAG_CARRIER_BONUS	2	// what you get for fragging enemy flag carrier
#define CTF_FLAG_RETURN_TIME	40	// seconds until auto return

#define CTF_CARRIER_DANGER_PROTECT_BONUS	2	// bonus for fraggin someone who has recently hurt your flag carrier
#define CTF_CARRIER_PROTECT_BONUS			1	// bonus for fraggin someone while either you or your target are near your flag carrier
#define CTF_FLAG_DEFENSE_BONUS				1	// bonus for fraggin someone while either you or your target are near your flag
#define CTF_RETURN_FLAG_ASSIST_BONUS		1	// awarded for returning a flag that causes a capture to happen almost immediately
#define CTF_FRAG_CARRIER_ASSIST_BONUS		2	// award for fragging a flag carrier if a capture happens almost immediately

#define CTF_TARGET_PROTECT_RADIUS			400	// the radius around an object being defended where a target will be worth extra frags
#define CTF_ATTACKER_PROTECT_RADIUS			400	// the radius around an object being defended where an attacker will get extra frags when making kills

#define CTF_CARRIER_DANGER_PROTECT_TIMEOUT	8
#define CTF_FRAG_CARRIER_ASSIST_TIMEOUT		10
#define CTF_RETURN_FLAG_ASSIST_TIMEOUT		10

#define CTF_AUTO_FLAG_RETURN_TIMEOUT		30	// number of seconds before dropped flag auto-returns

#define CTF_TECH_TIMEOUT					60  // seconds before techs spawn again


/****************/
/*  PROTOTYPES  */
/****************/

void CTFInit(void);

char *CTFTeamName(int team);
char *CTFOtherTeamName(int team);
int CTFOtherTeam(int team);

edict_t *SelectCTFSpawnPoint (edict_t *ent);
void CTFFragBonuses(edict_t *targ, edict_t *inflictor, edict_t *attacker);
void CTFCheckHurtCarrier(edict_t *targ, edict_t *attacker);
void CTFResetFlag(int ctf_team);
void CTFResetFlags(void);
qboolean CTFPickup_Flag(edict_t *ent, edict_t *other);
void CTFDeadDropFlag(edict_t *self);
qboolean CTFDrop_Flag(edict_t *ent, gitem_t *item);
void CTFFlagSetup (edict_t *ent);
void CTFEffects(edict_t *player);
void CTFCalcScores(void);
void SetCTFStats(edict_t *ent);
void Coven_ShowTech (edict_t *ent);

void SP_info_player_team1(edict_t *self);
void SP_info_player_team2(edict_t *self);

void CTFScoreboardMessage (edict_t *ent, edict_t *killer);
void Coven_CTFScoreboardMessage (edict_t *ent, edict_t *killer);

//TECH
void CTFHasTech(edict_t *who);
gitem_t *CTFWhat_Tech(edict_t *ent);
qboolean CTFPickup_Tech (edict_t *ent, edict_t *other);
void CTFDrop_Tech(edict_t *ent, gitem_t *item);
void CTFDeadDropTech(edict_t *ent);
void CTFRespawnTech(edict_t *ent);
void CTFSetupTechSpawn(void);
int CTFApplyResistance(edict_t *ent, int dmg);
int CTFApplyStrength(edict_t *ent, int dmg);
qboolean CTFApplyStrengthSound(edict_t *ent);
qboolean CTFApplyHaste(edict_t *ent);
void CTFApplyHasteSound(edict_t *ent);
void CTFApplyRegeneration(edict_t *ent);
qboolean CTFHasRegeneration(edict_t *ent);

void CTFSay_Team(edict_t *who, char *msg);

void SP_misc_ctf_banner (edict_t *ent);
void SP_misc_ctf_small_banner (edict_t *ent);

qboolean CTFCheckRules(void);

void SP_trigger_teleport (edict_t *ent);
void SP_info_teleport_destination (edict_t *ent);


//===========================/  END OF FILE  /===========================//
