/*==========================================================================
//  x_cache.c -- by Patrick Martin              Last updated:  4-19-1999
//--------------------------------------------------------------------------
//  This file contains code that loads AB data before the client
//  enters play.
//========================================================================*/

#include "g_local.h"
#include "x_cache.h"


/*========================/  Support Functions  /========================*/

/*----------------------------------------------------/ New Code /--------//
//  Support function:  Precaches necessary suit and CTF pics.
//  Used only in CTF.
//------------------------------------------------------------------------*/
static void Coven_CTFPics (void)
{
// Question marks (no suit)
        gi.imageindex ("ab_no0");
        gi.imageindex ("ab_no1");
        gi.imageindex ("ab_no2");

// Mugs:  Mercury
        gi.imageindex ("ab_m0");
        gi.imageindex ("ab_m1");
        gi.imageindex ("ab_m2");

// Mugs:  Zeppelin
        gi.imageindex ("ab_z0");
        gi.imageindex ("ab_z1");
        gi.imageindex ("ab_z2");

// Mugs:  GravyBurner
        gi.imageindex ("ab_gb0");
        gi.imageindex ("ab_gb1");
        gi.imageindex ("ab_gb2");

// Mugs:  WireCutter
        gi.imageindex ("ab_wc0");
        gi.imageindex ("ab_wc1");
        gi.imageindex ("ab_wc2");

// Mugs:  BulkHead/Rhino
        if (secret_on)
        {
                gi.imageindex ("ab_bh0");
                gi.imageindex ("ab_bh1");
                gi.imageindex ("ab_bh2");
        }
        else
        {
                gi.imageindex ("ab_r0");
                gi.imageindex ("ab_r1");
                gi.imageindex ("ab_r2");
        }

// Mugs:  SugarConny
        gi.imageindex ("ab_sc0");
        gi.imageindex ("ab_sc1");
        gi.imageindex ("ab_sc2");

// Tombstones (dead players)
        gi.imageindex ("ab_rip0");
        gi.imageindex ("ab_rip1");
        gi.imageindex ("ab_rip2");

// CTF icons
        gi.imageindex("ctfsb1");
        gi.imageindex("ctfsb2");
        gi.imageindex("i_ctf1");
        gi.imageindex("i_ctf1d");
        gi.imageindex("i_ctf1t");
        gi.imageindex("i_ctf2");
        gi.imageindex("i_ctf2d");
        gi.imageindex("i_ctf2t");
        gi.imageindex("i_ctfj");
        gi.imageindex("sbfctf1");
        gi.imageindex("sbfctf2");
}

/*----------------------------------------------------/ New Code /--------//
//  Support function:  Precaches all suit pics.  Not used in CTF.
//------------------------------------------------------------------------*/
static void Coven_SuitPics (void)
{
// Question marks (no suit)
        gi.imageindex ("ab_no0");
        gi.imageindex ("ab_no1");
        gi.imageindex ("ab_no2");
        gi.imageindex ("ab_no3");
        gi.imageindex ("ab_no4");
        gi.imageindex ("ab_no5");

// Mugs:  Mercury
        gi.imageindex ("ab_m0");
        gi.imageindex ("ab_m1");
        gi.imageindex ("ab_m2");
        gi.imageindex ("ab_m3");
        gi.imageindex ("ab_m4");
        gi.imageindex ("ab_m5");

// Mugs:  Zeppelin
        gi.imageindex ("ab_z0");
        gi.imageindex ("ab_z1");
        gi.imageindex ("ab_z2");
        gi.imageindex ("ab_z3");
        gi.imageindex ("ab_z4");
        gi.imageindex ("ab_z5");

// Mugs:  GravyBurner
        gi.imageindex ("ab_gb0");
        gi.imageindex ("ab_gb1");
        gi.imageindex ("ab_gb2");
        gi.imageindex ("ab_gb3");
        gi.imageindex ("ab_gb4");
        gi.imageindex ("ab_gb5");

// Mugs:  WireCutter
        gi.imageindex ("ab_wc0");
        gi.imageindex ("ab_wc1");
        gi.imageindex ("ab_wc2");
        gi.imageindex ("ab_wc3");
        gi.imageindex ("ab_wc4");
        gi.imageindex ("ab_wc5");

// Mugs:  BulkHead/Rhino
        if (secret_on)
        {
                gi.imageindex ("ab_bh0");
                gi.imageindex ("ab_bh1");
                gi.imageindex ("ab_bh2");
                gi.imageindex ("ab_bh3");
                gi.imageindex ("ab_bh4");
                gi.imageindex ("ab_bh5");
        }
        else
        {
                gi.imageindex ("ab_r0");
                gi.imageindex ("ab_r1");
                gi.imageindex ("ab_r2");
                gi.imageindex ("ab_r3");
                gi.imageindex ("ab_r4");
                gi.imageindex ("ab_r5");
        }

// Mugs:  SugarConny
        gi.imageindex ("ab_sc0");
        gi.imageindex ("ab_sc1");
        gi.imageindex ("ab_sc2");
        gi.imageindex ("ab_sc3");
        gi.imageindex ("ab_sc4");
        gi.imageindex ("ab_sc5");

// Tombstones (dead players)
        gi.imageindex ("ab_rip0");
        gi.imageindex ("ab_rip1");
        gi.imageindex ("ab_rip2");
        gi.imageindex ("ab_rip3");
        gi.imageindex ("ab_rip4");
        gi.imageindex ("ab_rip5");
}


/*===========================/  File Caching  /===========================*/

/*----------------------------------------------------/ New Code /--------//
//  This precaches all the new AB pics.
//------------------------------------------------------------------------*/
void Coven_CachePics (void)
{
// Bulkhead armour
        gi.imageindex ("armoured");

// Bubbles
        gi.imageindex ("bubble1");
        gi.imageindex ("bubble2");
        gi.imageindex ("bubble3");
        gi.imageindex ("bubble4");
        gi.imageindex ("bubble5");
        gi.imageindex ("bubble6");
        gi.imageindex ("bubble7");
        gi.imageindex ("bubble8");

// Jetpack
        if (jetpack_on)
        {
                gi.imageindex ("jet_off");
                gi.imageindex ("jet_on1");
                gi.imageindex ("jet_on2");
                gi.imageindex ("jet_on3");
                gi.imageindex ("jet_on4");
        }

// Weapons:  Light
        gi.imageindex ("w_hook");
        gi.imageindex ("w_sg");
        gi.imageindex ("w_beam");
        gi.imageindex ("w_pine");

// Weapons:  Medium
        gi.imageindex ("w_poker");
        gi.imageindex ("w_photon");
        gi.imageindex ("w_mini");
        gi.imageindex ("w_bazoo");

// Weapons:  Heavy
        gi.imageindex ("w_carver");
        gi.imageindex ("w_flamer");
        gi.imageindex ("w_sgauto");
        gi.imageindex ("w_mirv");

// Crosshairs
        gi.imageindex ("x_no");
        gi.imageindex ("x_ok");

// Rest are for deathmatch.
        if (!deathmatch->value)
                return;

// Spectator/Menu
        gi.imageindex ("i_airstrike");
        gi.imageindex ("k_comhead");

        if (ab_rules == RULES_CTF)
        {
                Coven_CTFPics ();
                return;
        }

        Coven_SuitPics ();

        if (Coven_ArenaOn ())
        {
                // Eyes (players waiting in line)
                gi.imageindex ("ab_wil0");
                gi.imageindex ("ab_wil1");
                gi.imageindex ("ab_wil2");
                gi.imageindex ("ab_wil3");
                gi.imageindex ("ab_wil4");
                gi.imageindex ("ab_wil5");

                // Arena observer (eye icon)
                gi.imageindex ("in_line");
        }

        if (ab_rules == RULES_CAPTURE)
        {
                // Capture rune icons
                gi.imageindex ("r_armour");
                gi.imageindex ("r_damage");
                gi.imageindex ("r_health");
        }

// Stopwatch timer
        gi.imageindex ("s_watch");

// Teaminfo bar
        if (ab_teams >= 2)
                gi.imageindex ("teaminfo");

}

/*----------------------------------------------------/ New Code /--------//
//  This precaches all the new AB items (mostly weapons).
//  Invulnerability is precached because it is used for the
//  three second respawn shield.
//------------------------------------------------------------------------*/
void Coven_CacheItems (void)
{
// Jetpack
        if (jetpack_on)
                PrecacheItem (FindItem ("Jetpack"));

// Weapons:  Light
        PrecacheItem (FindItem ("Grapple"));
        PrecacheItem (FindItem ("Assault Shotgun"));
        PrecacheItem (FindItem ("Particle Beam"));
        PrecacheItem (FindItem ("Grenade Launcher"));

// Weapons:  Medium
        PrecacheItem (FindItem ("Prod Rod"));
        PrecacheItem (FindItem ("Photon Cannon"));
        PrecacheItem (FindItem ("Minigun"));
        PrecacheItem (FindItem ("Bazooka"));

// Weapons:  Heavy
        PrecacheItem (FindItem ("Carver"));
        PrecacheItem (FindItem ("Flamethrower"));
        PrecacheItem (FindItem ("Auto Shotgun"));
        PrecacheItem (FindItem ("MIRV Launcher"));

        if (!deathmatch->value)
                return;

// Respawn protection
        PrecacheItem (FindItem ("Invulnerability"));

// Capture Runes
        if (ab_rules == RULES_CAPTURE)
        {
                PrecacheItem (FindItem ("Armour Rune"));
                PrecacheItem (FindItem ("Damage Rune"));
                PrecacheItem (FindItem ("Health Rune"));
        }

// Techs
        if ((int)dmflags->value & DF_CTF_TECH)
        {       // NOTE:  This is here hopefully to fix 'can't find pic'.
                PrecacheItem (FindItem ("Disruptor Shield"));
                PrecacheItem (FindItem ("Power Amplifier"));
                PrecacheItem (FindItem ("Time Accel"));
                PrecacheItem (FindItem ("AutoDoc"));
        }
}

/*----------------------------------------------------/ New Code /--------//
//  This precaches all the new AB sounds (mostly battlesuits).
//------------------------------------------------------------------------*/
void Coven_CacheSounds (void)
{
// Screams
        gi.soundindex ("player/burn1.wav");
        gi.soundindex ("player/burn2.wav");
// NOTE:  'lava*.wav' are precached in 'g_spawn.c'.

        if (!deathmatch->value)
                return;

// Suit:  Mercury
        gi.soundindex ("armour/mercury/bump1.wav");
        gi.soundindex ("armour/mercury/death1.wav");
        gi.soundindex ("armour/mercury/death2.wav");
        gi.soundindex ("armour/mercury/death3.wav");
        gi.soundindex ("armour/mercury/death4.wav");
        gi.soundindex ("armour/mercury/drown1.wav");
        gi.soundindex ("armour/mercury/fall1.wav");
        gi.soundindex ("armour/mercury/fall2.wav"); 
        gi.soundindex ("armour/mercury/gurp1.wav");
        gi.soundindex ("armour/mercury/gurp2.wav"); 
        gi.soundindex ("armour/mercury/jump1.wav");
        gi.soundindex ("armour/mercury/pain25_1.wav");
        gi.soundindex ("armour/mercury/pain25_2.wav");
        gi.soundindex ("armour/mercury/pain50_1.wav");
        gi.soundindex ("armour/mercury/pain50_2.wav");
        gi.soundindex ("armour/mercury/pain75_1.wav");
        gi.soundindex ("armour/mercury/pain75_2.wav");
        gi.soundindex ("armour/mercury/pain100_1.wav");
        gi.soundindex ("armour/mercury/pain100_2.wav");
        gi.soundindex ("armour/mercury/more/gasp1.wav");
        gi.soundindex ("armour/mercury/more/gasp2.wav");

// Suit:  Zeppelin
        gi.soundindex ("armour/zeppelin/bump1.wav");
        gi.soundindex ("armour/zeppelin/death1.wav");
        gi.soundindex ("armour/zeppelin/death2.wav");
        gi.soundindex ("armour/zeppelin/death3.wav");
        gi.soundindex ("armour/zeppelin/death4.wav");
        gi.soundindex ("armour/zeppelin/drown1.wav");
        gi.soundindex ("armour/zeppelin/fall1.wav");
        gi.soundindex ("armour/zeppelin/fall2.wav"); 
        gi.soundindex ("armour/zeppelin/gurp1.wav");
        gi.soundindex ("armour/zeppelin/gurp2.wav"); 
        gi.soundindex ("armour/zeppelin/jump1.wav");
        gi.soundindex ("armour/zeppelin/pain25_1.wav");
        gi.soundindex ("armour/zeppelin/pain25_2.wav");
        gi.soundindex ("armour/zeppelin/pain50_1.wav");
        gi.soundindex ("armour/zeppelin/pain50_2.wav");
        gi.soundindex ("armour/zeppelin/pain75_1.wav");
        gi.soundindex ("armour/zeppelin/pain75_2.wav");
        gi.soundindex ("armour/zeppelin/pain100_1.wav");
        gi.soundindex ("armour/zeppelin/pain100_2.wav");
        gi.soundindex ("armour/zeppelin/more/gasp1.wav");
        gi.soundindex ("armour/zeppelin/more/gasp2.wav");

// Suit:  GravyBurner
        gi.soundindex ("armour/gravyburner/bump1.wav");
        gi.soundindex ("armour/gravyburner/death1.wav");
        gi.soundindex ("armour/gravyburner/death2.wav");
        gi.soundindex ("armour/gravyburner/death3.wav");
        gi.soundindex ("armour/gravyburner/death4.wav");
        gi.soundindex ("armour/gravyburner/drown1.wav");
        gi.soundindex ("armour/gravyburner/fall1.wav");
        gi.soundindex ("armour/gravyburner/fall2.wav"); 
        gi.soundindex ("armour/gravyburner/gurp1.wav");
        gi.soundindex ("armour/gravyburner/gurp2.wav"); 
        gi.soundindex ("armour/gravyburner/jump1.wav");
        gi.soundindex ("armour/gravyburner/pain25_1.wav");
        gi.soundindex ("armour/gravyburner/pain25_2.wav");
        gi.soundindex ("armour/gravyburner/pain50_1.wav");
        gi.soundindex ("armour/gravyburner/pain50_2.wav");
        gi.soundindex ("armour/gravyburner/pain75_1.wav");
        gi.soundindex ("armour/gravyburner/pain75_2.wav");
        gi.soundindex ("armour/gravyburner/pain100_1.wav");
        gi.soundindex ("armour/gravyburner/pain100_2.wav");
        gi.soundindex ("armour/gravyburner/more/gasp1.wav");
        gi.soundindex ("armour/gravyburner/more/gasp2.wav");

// Suit:  WireCutter
        gi.soundindex ("armour/wirecutter/bump1.wav");
        gi.soundindex ("armour/wirecutter/death1.wav");
        gi.soundindex ("armour/wirecutter/death2.wav");
        gi.soundindex ("armour/wirecutter/death3.wav");
        gi.soundindex ("armour/wirecutter/death4.wav");
        gi.soundindex ("armour/wirecutter/drown1.wav");
        gi.soundindex ("armour/wirecutter/fall1.wav");
        gi.soundindex ("armour/wirecutter/fall2.wav"); 
        gi.soundindex ("armour/wirecutter/gurp1.wav");
        gi.soundindex ("armour/wirecutter/gurp2.wav"); 
        gi.soundindex ("armour/wirecutter/jump1.wav");
        gi.soundindex ("armour/wirecutter/pain25_1.wav");
        gi.soundindex ("armour/wirecutter/pain25_2.wav");
        gi.soundindex ("armour/wirecutter/pain50_1.wav");
        gi.soundindex ("armour/wirecutter/pain50_2.wav");
        gi.soundindex ("armour/wirecutter/pain75_1.wav");
        gi.soundindex ("armour/wirecutter/pain75_2.wav");
        gi.soundindex ("armour/wirecutter/pain100_1.wav");
        gi.soundindex ("armour/wirecutter/pain100_2.wav");
        gi.soundindex ("armour/wirecutter/more/gasp1.wav");
        gi.soundindex ("armour/wirecutter/more/gasp2.wav");

// Suit:  BulkHead/Rhino
        if (secret_on)
        {
                gi.soundindex ("armour/bulkhead/bump1.wav");
                gi.soundindex ("armour/bulkhead/death1.wav");
                gi.soundindex ("armour/bulkhead/death2.wav");
                gi.soundindex ("armour/bulkhead/death3.wav");
                gi.soundindex ("armour/bulkhead/death4.wav");
                gi.soundindex ("armour/bulkhead/drown1.wav");
                gi.soundindex ("armour/bulkhead/fall1.wav");
                gi.soundindex ("armour/bulkhead/fall2.wav"); 
                gi.soundindex ("armour/bulkhead/gurp1.wav");
                gi.soundindex ("armour/bulkhead/gurp2.wav"); 
                gi.soundindex ("armour/bulkhead/jump1.wav");
                gi.soundindex ("armour/bulkhead/pain25_1.wav");
                gi.soundindex ("armour/bulkhead/pain25_2.wav");
                gi.soundindex ("armour/bulkhead/pain50_1.wav");
                gi.soundindex ("armour/bulkhead/pain50_2.wav");
                gi.soundindex ("armour/bulkhead/pain75_1.wav");
                gi.soundindex ("armour/bulkhead/pain75_2.wav");
                gi.soundindex ("armour/bulkhead/pain100_1.wav");
                gi.soundindex ("armour/bulkhead/pain100_2.wav");
                gi.soundindex ("armour/bulkhead/more/gasp1.wav");
                gi.soundindex ("armour/bulkhead/more/gasp2.wav");
                gi.soundindex ("armour/bulkhead/more/roll1.wav");
                gi.soundindex ("armour/bulkhead/more/roll2.wav");
                gi.soundindex ("armour/bulkhead/more/roll3.wav");
                gi.soundindex ("armour/bulkhead/more/roll4.wav");
        }
        else
        {
                gi.soundindex ("armour/rhino/bump1.wav");
                gi.soundindex ("armour/rhino/death1.wav");
                gi.soundindex ("armour/rhino/death2.wav");
                gi.soundindex ("armour/rhino/death3.wav");
                gi.soundindex ("armour/rhino/death4.wav");
                gi.soundindex ("armour/rhino/drown1.wav");
                gi.soundindex ("armour/rhino/fall1.wav");
                gi.soundindex ("armour/rhino/fall2.wav"); 
                gi.soundindex ("armour/rhino/gurp1.wav");
                gi.soundindex ("armour/rhino/gurp2.wav"); 
                gi.soundindex ("armour/rhino/jump1.wav");
                gi.soundindex ("armour/rhino/pain25_1.wav");
                gi.soundindex ("armour/rhino/pain25_2.wav");
                gi.soundindex ("armour/rhino/pain50_1.wav");
                gi.soundindex ("armour/rhino/pain50_2.wav");
                gi.soundindex ("armour/rhino/pain75_1.wav");
                gi.soundindex ("armour/rhino/pain75_2.wav");
                gi.soundindex ("armour/rhino/pain100_1.wav");
                gi.soundindex ("armour/rhino/pain100_2.wav");
                gi.soundindex ("armour/rhino/more/gasp1.wav");
                gi.soundindex ("armour/rhino/more/gasp2.wav");
                gi.soundindex ("armour/rhino/more/stomp.wav");
                gi.soundindex ("armour/rhino/more/stompwat.wav");
        }

// Suit:  SugarConny
        gi.soundindex ("armour/sugarconny/bump1.wav");
        gi.soundindex ("armour/sugarconny/death1.wav");
        gi.soundindex ("armour/sugarconny/death2.wav");
        gi.soundindex ("armour/sugarconny/death3.wav");
        gi.soundindex ("armour/sugarconny/death4.wav");
        gi.soundindex ("armour/sugarconny/drown1.wav");
        gi.soundindex ("armour/sugarconny/fall1.wav");
        gi.soundindex ("armour/sugarconny/fall2.wav"); 
        gi.soundindex ("armour/sugarconny/gurp1.wav");
        gi.soundindex ("armour/sugarconny/gurp2.wav"); 
        gi.soundindex ("armour/sugarconny/jump1.wav");
        gi.soundindex ("armour/sugarconny/pain25_1.wav");
        gi.soundindex ("armour/sugarconny/pain25_2.wav");
        gi.soundindex ("armour/sugarconny/pain50_1.wav");
        gi.soundindex ("armour/sugarconny/pain50_2.wav");
        gi.soundindex ("armour/sugarconny/pain75_1.wav");
        gi.soundindex ("armour/sugarconny/pain75_2.wav");
        gi.soundindex ("armour/sugarconny/pain100_1.wav");
        gi.soundindex ("armour/sugarconny/pain100_2.wav");
        gi.soundindex ("armour/sugarconny/more/gasp1.wav");
        gi.soundindex ("armour/sugarconny/more/gasp2.wav");
        gi.soundindex ("armour/sugarconny/more/stomp.wav");
        gi.soundindex ("armour/sugarconny/more/stompwat.wav");
}

/*----------------------------------------------------/ New Code /--------//
//  This precaches all the new AB models (mostly battlesuits).
//------------------------------------------------------------------------*/
void Coven_CacheModels (void)
{
        if (!deathmatch->value)
                return;

// Metal gibs
        gi.modelindex ("models/objects/gibs/sm_metal/tris.md2");

// Battlesuits:  Light
        gi.modelindex ("models/armour/mercury/tris.md2");
        gi.modelindex ("models/armour/zeppelin/tris.md2");

// Battlesuits:  Medium
        gi.modelindex ("models/armour/gravyburner/tris.md2");
        gi.modelindex ("models/armour/wirecutter/tris.md2");

// Battlesuits:  Heavy
        if (secret_on)
                gi.modelindex ("models/armour/bulkhead/tris.md2");
        else
                gi.modelindex ("models/armour/rhino/tris.md2");
        gi.modelindex ("models/armour/sugarconny/tris.md2");
}


/*===========================/  END OF FILE  /===========================*/
