// !! CmdHUD 0.98g -> Commander/Inventory/Inv. Station LOOK-AROUND <- 4/21/99 !
// 
// Original CmdHUD code, and -idea- by:
//    Zear
//    zear@planetstarsiege.com
// 
// InvHUD, CmdHUD rework, additional code by:
//    Cowboy
//    rustyjones@mediaone.net
//    ICQ# 31184463
// 
// ********************> NOW SUPPORTS RESIZE-ON-THE-FLY! <*********************
//
// Well, I saw what Zear did with his CmdHUD, so I figured I'd do up an InvHUD
// so people can have a much larger view around them at an inventory station!
// Then, I looked at the CmdHUD and cleaned it up a little, and also made some
// of the windows the same size/location between the 2 GUIs.
//
// Next was trying to get it to resize! I got everything to resize, but much to
// my dismay, every time you resized the window, all the playGui objects (clock
// display, sensor ping, compass, etc) would do a 'snap to edge' and get fully
// messed up. Presto had an idea: to place all of these 'wandering Huds' in a
// separate frame, that wouldn't resize like the playGui. I had already tried
// this but I didn't succeed.. but after a few days, I tried it again, because
// I knew if I didn't do it, someone else might have and _they_ would get all
// the credit... and lo! It worked! Wooooo baby! :)
//
// Then.. people wanted to be able to use both the new small map AND the large
// one from the original command.gui, I tried many different things.. i had it
// so that it actually GuiPushDialog()'ed the old Command Gui screen onto the
// MainWindow, but this was unreliable, not to mention _every_ time you wanted
// to go back to that it had to be reloaded and rebuilt (even if it was the
// last map displayed). So then I had the script create 2 FearGui::TSCommander
// objects, one for each map size, in Simgui::Control objects, but the large
// map couldn't resize, and if you made the window too small it would crash
// Tribes (and although this worked fine for me and other people, i wanted it
// to be able to FULLY resize on-the-fly).. So what I finally did is code into
// the Gui 2 different Simgui::Control objects (one for each map, both opaque,
// and the large one resizes) then I add the appropriate FearGui::TSCommander
// maps into each window and rebuild.
//
// The real trouble with that is that Tribes wouldn't give me the Object IDs
// of the Simgui::Control objects (even though I named them, and knew where
// they were) This was very frustrating.. I was ready to call it quits when
// Presto suggested that since Simgui::Control objects are also sets (where
// the objects it owns are the members), maybe I could get individual IDs of
// members of a set whose ID I _could+ get (CommandGui). This worked! so, here
// ya go!
//
// NOTE: The Zoom/Center buttons and Zoom key do not work on the Commander Map!
//       I don't know why, but they crash Tribes. if you know how to fix this,
//       let me know ASAP! - but for now I disabled both the bottons and the
//       'z' key in the Commander screen. Sorry!
// 
// Requires PrestoHUD, tested with 0.93! Also, this replaces Zear's CmdHUD.
// Please do not run _both_ this CmdHUD and his old version concurrently!
// 
// (ok?)
// 
// This is fully a beta, so let me know if it works or not! thank you!
// 
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// 
// Installation notes:
// 
// Unzip *.gui into the tribes\gui directory. If you don't have this directory,
// create it! Unzip all other files into \config\cowboy directory and add line:
// Include("cowboy\\CmdHUD.cs"); to your autoexec.cs file somewhere AFTER the
// exec("presto\\install.cs"); line.
// 
// also, set $PrestoPref::InvCamera = false in presto\PrestoPrefs.cs so it
// doesn't try to ALSO display the CamHUD while in inventory mode!
// 
// And I suggest setting $PrestoPref::CamHudTurnAround = true so that you get
// yourself turned around ...
// 
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// 
// This was originally done by Zear, as was the idea. I want to take no credit
// for the originality of it! I _did_ however do the Inventory screen... but 
// only by first using his as a template...
// 
// (c) 1999 Zear/Cowboy, whatever... I hope you enjoy this, and all that i ask
// is that you give Zear props for it.. He's the man... enjoy!
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// User settings - please read this section carefully!
//
// There are so many settings! Well - I got so many suggestions, I wanted to 
// implement as many as I could... I'll explain the best I can...
//
// Note: Clicking on the Commander Gui's Commander buton (top left button on
//       the CmdHUD screen) will toggle map sizes now!
//
//       For both Commander and Inventory screens, pressing <ENTER> while
//       displayed toggles between mouse cursor/movement modes. you can change
//       this and other key bindings below.
//
// These first 3 setting are straight-forward, I don't think I need to explain
// them. The next 6 are for all of you who want to be able to hit a key and
// pull up a particular map with a particular mouse state. 
//
// The first, $CmdHUD::CommanderKey, pulls up whatever Commander map you used
// last, and it uses whatever mouse state setting is in $CmdHUD::Mouse.
//
// The second, $CmdHUD::CmdKeyLarge, pulls up the Large Commander map in the
// mouse state defined in $CmdHUD::LargeMouse.
//
// The third, $CmdHUD::CmdKeySmall, pulls up the Small Commander map in the
// mouse state defined in $CmdHUD::SmallMouse.
//
// * I personally like $CmdHUD::CmdKeySmall bound to "c" so it calls up the
//   Small Commander map in Free Look mouse mode ($CmdHUD::SmallMouse = 2)
//   so I can see the map while i'm running around. When I want to click on
//   the Command Panel, I press <Enter> or I just press "]" and it loads the
//   Large map with Mouse Cursor mode ($CmdHUD::LargeMouse = 1) so I can
//   get a large view of the map.
//
// * Tribe commanders might want to swap the keys for $CmdHUD::CmdKeyLarge
//   and $CmdHUD::CommanderKey, so it's really easy for you to bring up the
//   full size map..
//
// You can now set $CmdHUD::CmdStaLarge below if you want it to default to
// the Large map when you enter a Command Station.
//
// Finally, you can set whether or not you want to be turned around when you
// enter either type of station.

$CmdHUD::CursorKey = "enter";	// Key to toggle mouse cursor/movement modes

$CmdHUD::InventoryKey = "i";	// Key used to view Inventory Screen, "i" is
				// the Tribes default
$CmdHUD::ObjectiveKey = "o";	// I don't have an Objectives GUI, but this
				// is important to define

$CmdHUD::CommanderKey = "c";	// View Commander screen, with last used map
$CmdHUD::CmdKeyLarge = "]";	// View Commander screen with Large Map
$CmdHUD::CmdKeySmall = "[";	// View Commander screen with Small Map

$CmdHUD::Mouse = 0;		// Default mouse mode for the Commander screen
				// when you press $CmdHUD::CommanderKey
$CmdHUD::LargeMouse = 1;	// Default mouse mode for when you press 
				// $CmdHUD::CmdKeyLarge
$CmdHUD::SmallMouse = 2;	// Default mouse mode for when you press 
				// $CmdHUD::CmdKeySmall
$CmdHUD::InvMouse = 1;		// Default mouse mode for the Inventory screen
				// when you press $CmdHUD::InventoryKey
				//
				// Available options:
				// 0 = remember last mode used
				// 1 = open CmdHUDs in Mouse Cursor mode
				// 2 = open CmdHUDs in Mouse Free Look mode

$CmdHUD::CmdStaLarge = true;	// Do you want it to open a full-size map when
				// you enter a Command Station? true _forces_
				// the Large map, false uses the Last Used map

$CmdHUD::InvTurnAround = true;	// Wanna be turned around when entering these
$CmdHUD::CmdTurnAround = true;	// stations? (if true, you are required to set
				// $PrestoPref::CamHudTurnAround = true in
				// presto\\prestoprefs.cs)

$CmdHUD::MouseOffTime = 0.3;	// (time in seconds) Try making this larger if
				// The mouse is not shutting off when you
				// select Free Look mode or it's not accurately
				// changing the map sizes and updating them
				// (this shouldn't need to be changed)

Include("presto\\Event.cs");
Include("presto\\Camhud.cs");
Include("presto\\Inventory.cs");

//
// For Presto Pack 0.93+, this displays script info in a box on the main
// menu screen, kind of an 'Advertisement/Info Box' for installed scripts.
//

if ($Presto::version >= 0.93) {
	Presto::AddScriptBanner(CmdHUD,	"<jc><f2>CmdHUD 0.98g <f1>Commander &\n" @
		"<f1>Inventory Sceen <f2>Resizing<f1> GUI\n" @
		"<f0>Cursor/Movement: <f1>" @ $CmdHUD::CursorKey @ "\n" @
		"<f0>Commander Screen: <f1>" @ $CmdHUD::CommanderKey @ "\n" @
		"<f0>Small Map Toggle: <f1>" @ $CmdHUD::CmdKeySmall @ "\n" @
		"<f0>Large Map Toggle: <f1>" @ $CmdHUD::CmdKeyLarge @ "\n" @
		"<f0>Inventory Screen: <f1>" @ $CmdHUD::InventoryKey @ "\n" @
		"<f1>Created by <f2>Zear<f1>, modified and\n" @
		"totally reworked by <f2>Cowboy<f1>...");
	}


function LobbyGui::onOpen()
{
	Control::setValue(LobbyServerName, $ServerName);
	Control::setValue(LobbyServerType, $ServerMod);
	Control::setValue(LobbyMissionName, $ServerMission);
	Control::setValue(LobbyMissionType, $ServerMissionType);
	Control::setValue(LobbyVersion, $ServerVersion);
	Control::setValue(LobbyAddress, $Server::Address);

	Control::setValue(LobbyServerText, $ServerInfo);
	Control::setValue(LobbyMissionDesc, $ServerText);

	Event::Trigger(eventGuiOpen, LobbyGui);
}

function CmdHUD::GuiOpen(%gui) {
	$CmdHUD::lastGuiOpen = $CmdHUD::guiOpen;
	if (%gui == playGui && $CmdHUD::lastGuiOpen != 6)
		$CmdHUD::guiOpen = 1;
	else if (%gui == CommandGui)
		$CmdHUD::guiOpen = 2;
	else if (%gui == CmdInventoryGui)
		$CmdHUD::guiOpen = 4;
	else if (%gui == LobbyGui)
		$CmdHUD::guiOpen = 6;

	if($CmdHUD::Station) {
		if ($CmdHUD::lastGuiOpen == 6) {
			if ($CmdHUD::guiOpen == 2)
				CmdHUD::Cursor($CmdHUD::TempState);
			else if ($CmdHUD::guiOpen == 4)
				CmdHUD::Cursor($CmdHUD::TempState);
			}
		}
	else {
		if ($CmdHUD::lastGuiOpen == 6) {
			if ($CmdHUD::guiOpen == 2)
				CmdHUD::Cursor($CmdHUD::State);
			else if ($CmdHUD::guiOpen == 4)
				CmdHUD::Cursor($CmdHUD::State);
			}
		}
	}

Event::Attach(eventGuiOpen, CmdHUD::GuiOpen);

function CmdHUD::onClientMessage(%client, %message) {
	if (%client != 0)
		return;

	if (%message == "Command Access On") {
		Event::Trigger(eventEnterCommand);
		return;
		}
	if (%message == "Command Access Off") {
		Event::Trigger(eventExitCommand);
		return;
		}
	if (%message == "--ACCESS DENIED-- Wrong Team ") {
		Event::Trigger(eventAccessEnemyStation);
		return;
		}
	}

Event::Attach(eventClientMessage, CmdHUD::onClientMessage);

function CmdHUD::InitalizeGuiObjects() {
	$CmdHUD::SmallMapFrame = Group::GetObject(NameToId(CommandGui), 4);
	$CmdHUD::BigMapFrame = Group::GetObject(NameToId(CommandGui), 5);
	$CmdHUD::CommandMap = Group::GetObject($CmdHUD::SmallMapFrame, 0);
	$CmdHUD::BigMapChat = Group::GetObject($CmdHUD::BigMapFrame, 0);
	}

function CmdHUD::SmallMap() {
	Control::SetVisible("BigMapFrame", false);
	RemoveFromSet($CmdHUD::BigMapFrame, $CmdHUD::CommandMap);

	$CmdHUD::CommandMap = newObject(SmallMap, FearGui::TSCommander, 0, 0, 204, 204);
	addToSet($CmdHUD::SmallMapFrame, $CmdHUD::CommandMap);

	Control::SetVisible("SmallMapFrame", true);
	RebuildCommandMap();

	}

function CmdHUD::BigMap() {
	Control::SetVisible("SmallMapFrame", false);
	RemoveFromSet($CmdHUD::SmallMapFrame, $CmdHUD::CommandMap);

	$CmdHUD::CommandMap = newObject(BigMap, FearGui::TSCommander, 0, 0, 420, 420);
	addToSet($CmdHUD::BigMapFrame, $CmdHUD::CommandMap);

	removeFromSet($CmdHUD::BigMapFrame, $CmdHUD::BigMapChat);
	addToSet($CmdHUD::BigMapFrame, $CmdHUD::BigMapChat);

	Control::SetVisible("BigMapFrame", true);
	RebuildCommandMap();
	}

function CmdHUD::MapToggle(%state) {
	client::centerprint("<jc>CmdHUD Resizing Map...", 0);
	schedule("client::centerprint(\"\", 0);", 2);

	if (%state)
		schedule("CmdHUD::SmallMap();", 0.1);
	else
		schedule("CmdHUD::BigMap();", 0.1);

	return %state;
	}

//
// This is what happens when you press the Commander button at the top left of
// the screen while in Commander mode or press the SizeToggle key in PDA mode.
// (Toggles the map size small/big)
//
function CmdHUD::CmdButtonPress() {
	if ($CmdHUD::guiOpen == 2)
		$CmdHUD::MapState = CmdHUD::MapToggle(!$CmdHUD::MapState);
	}
//
// Turn the cursor on/off & set CommandPanel state accordingly
// returns the cursor state
//
function CmdHUD::Cursor(%state) {
	Control::SetVisible("CommandPanel", %state);

	if (%state)
		cursorOn(MainWindow);
	else
		schedule("cursorOff(MainWindow);", $CmdHUD::MouseOffTime);

	return %state;
	}

function CmdHUD::ObjectiveOn() {
	remoteEval(2048, ObjectivesMode);
	$CmdHUD::guiMode = 5;
	}

function CmdHUD::ObjectiveOff() {
	if ($CmdHUD::guiMode == 5) {
		remoteEval(2048, PlayMode);
		$CmdHUD::guiMode = 1;
		}
	else
		CmdHUD::ObjectiveOn();
	}

//
// Turn on the Commander Screen
//
function CmdHUD::turnOn(%size) {
	remoteEval(2048, CommandMode);
	$CmdHUD::guiMode = 2;
	
	if (%size == Small) {
		if (!$CmdHUD::MapState)
			schedule("CmdHUD::CmdButtonPress();", $CmdHUD::MouseOffTime);

		if ($CmdHUD::Station)
			CmdHUD::Cursor($CmdHUD::State);
		else if ($CmdHUD::SmallMouse == 0)
			CmdHUD::Cursor($CmdHUD::State);
		else if ($CmdHUD::SmallMouse == 1)
			$CmdHUD::State = CmdHUD::Cursor(true);
		else if ($CmdHUD::SmallMouse == 2)
			$CmdHUD::State = CmdHUD::Cursor(false);
		return;
		}

	else if (%size == Large) {
		if ($CmdHUD::MapState)
			schedule("CmdHUD::CmdButtonPress();", $CmdHUD::MouseOffTime);

		if ($CmdHUD::Station)
			CmdHUD::Cursor($CmdHUD::State);
		else if ($CmdHUD::LargeMouse == 0)
			CmdHUD::Cursor($CmdHUD::State);
		else if ($CmdHUD::LargeMouse == 1)
			$CmdHUD::State = CmdHUD::Cursor(true);
		else if ($CmdHUD::LargeMouse == 2)
			$CmdHUD::State = CmdHUD::Cursor(false);
		return;
		}
	else {
		if ($CmdHUD::Station)
			CmdHUD::Cursor($CmdHUD::State);
		else if ($CmdHUD::Mouse == 0)
			CmdHUD::Cursor($CmdHUD::State);
		else if ($CmdHUD::Mouse == 1)
			$CmdHUD::State = CmdHUD::Cursor(true);
		else if ($CmdHUD::Mouse == 2)
			$CmdHUD::State = CmdHUD::Cursor(false);
		}
	}

//
// This is a Commander Screen toggle if invoked from either
// of the Cmd/Inv screens
//
function CmdHUD::turnOff(%size) {
	if (%size == "Small") {
		if (!$CmdHUD::MapState || $CmdHUD::guiMode != 2)
			CmdHUD::turnOn(%size);
		else {
			remoteEval(2048, PlayMode);
			$CmdHUD::guiMode = 1;
			}
		}
	else if (%size == "Large") {
		if ($CmdHUD::MapState || $CmdHUD::guiMode != 2)
			CmdHUD::turnOn(%size);
		else {
			remoteEval(2048, PlayMode);
			$CmdHUD::guiMode = 1;
			}
		}
	else if ($CmdHUD::guiMode == 2) {
		remoteEval(2048, PlayMode);
		$CmdHUD::guiMode = 1;
		}
	else
		CmdHUD::turnOn();
	}	

//
// Turn on the Inventory Screen
//
function InvHUD::turnOn() {
	remoteEval(2048, InventoryMode);

	$CmdHUD::guiMode = 4;

	if ($CmdHUD::Station)
		CmdHUD::Cursor($CmdHUD::State);
	else if ($CmdHUD::InvMouse == 0)
		CmdHUD::Cursor($CmdHUD::State);
	else if ($CmdHUD::InvMouse == 1)
		$CmdHUD::State = CmdHUD::Cursor(true);
	else if ($CmdHUD::InvMouse == 2)
		$CmdHUD::State = CmdHUD::Cursor(false);
	}

//
// This is an Inventory Screen toggle if invoked from either
// of the Cmd/Inv screens
//
function InvHUD::turnOff() {
	if ($CmdHUD::guiMode == 4) {
		remoteEval(2048, PlayMode);
		$CmdHUD::guiMode = 1;
		}
	else
		InvHUD::turnOn();
	}	

//
//  What the code below does:
//
// 	- Now uses Presto's Camhud.cs script to turn you around in
//	  an inventory station (why rewrite what's already written?)
// 	- Doesn't turn you around if you are repairing the station
// 	- Restores your previous Gui mode upon exiting either inventory or
// 	  command stations
//	- Detects if you get close enough to an enemy station to 'activate'
//	  it and keeps you in the correct Gui mode!
//

//
// What to do when you enter a Command Station
//
function CmdHUD::EnterStation() {
	$CmdHUD::Station = true;
	$CmdHUD::StationResizeMap = false;

	if ($CmdHUD::CmdStaLarge == true && $CmdHUD::MapState) {
		$CmdHUD::StationResizeMap = true;
		schedule("CmdHUD::CmdButtonPress();", $CmdHUD::MouseOffTime);
		}

	$CmdHUD::TempState = CmdHUD::Cursor(true);
	
	EditActionMap("pdaMap.sae");
	bindCommand(keyboard0, make, $CmdHUD::CursorKey, TO, "$CmdHUD::TempState = CmdHUD::Cursor(!$CmdHUD::TempState);");

	if ($CmdHUD::CmdTurnAround)
		CamHud::EnterStation();
	}

//
// What to do when you exit a Command Station
//
function CmdHUD::ExitStation() {
	if ($CmdHUD::CmdTurnAround)
		CamHud::ExitStation();

	remoteEval(2048, PlayMode);

	if ($CmdHUD::guiMode == 2) {
		if ($CmdHUD::StationResizeMap)
			CmdHUD::turnOn(Small);
		else
			CmdHUD::turnOn();
		}
	else if ($CmdHUD::guiMode == 4)
		InvHUD::turnOn();

	EditActionMap("pdaMap.sae");
	bindCommand(keyboard0, make, $CmdHUD::CursorKey, TO, "$CmdHUD::State = CmdHUD::Cursor(!$CmdHUD::State);");

	$CmdHUD::Station = false;
	}

//
// What to do when you enter an Inventory Station
//
function InvHUD::EnterStation() {
	$CmdHUD::Station = true;
	$CmdHUD::TempState = CmdHUD::Cursor(true);

	EditActionMap("pdaMap.sae");
	bindCommand(keyboard0, make, $CmdHUD::CursorKey, TO, "$CmdHUD::TempState = CmdHUD::Cursor(!$CmdHUD::TempState);");

	// It seems that cmdinventory.gui gets loaded a little bit later
	// the very first time you step into the inventory station, but
	// 0.1 seconds is apperently long enough to make it work!

	schedule("Control::SetVisible(\"StationInvPanel\", true);",0.1);

	if ($CmdHUD::InvTurnAround)
		CamHud::EnterStation();
	}

//
// What to do when you exit an Inventory Station
//
function InvHUD::ExitStation() {
	Control::SetVisible("StationInvPanel", false);

	if ($CmdHUD::InvTurnAround)
		CamHud::ExitStation();

	remoteEval(2048, PlayMode);

	if ($CmdHUD::guiMode == 2)
		CmdHUD::turnOn();
	else if ($CmdHUD::guiMode == 4)
		InvHUD::turnOn();

	EditActionMap("pdaMap.sae");
	bindCommand(keyboard0, make, $CmdHUD::CursorKey, TO, "$CmdHUD::State = CmdHUD::Cursor(!$CmdHUD::State);");

	$CmdHUD::Station = false;
	}

//
// Restore settings to defaults
//
function CmdHUD::Reset() {
	$CmdHUD::guiMode = 1;
	$CmdHUD::State = true;

	Control::SetVisible("StationInvPanel", false);

	schedule("CmdHUD::InitalizeGuiObjects();", 1);

	EditActionMap("pdaMap.sae");
	bindCommand(keyboard0, make, $CmdHUD::CursorKey, TO, "$CmdHUD::State = CmdHUD::Cursor(!$CmdHUD::State);");
	}

$CmdHUD::MapState = true;

EditActionMap("ActionMap.sae");
bindCommand(keyboard0, make, $CmdHUD::CommanderKey, TO, "CmdHud::turnOn();");
bindCommand(keyboard0, make, $CmdHUD::CmdKeyLarge, TO, "CmdHud::turnOn(Large);");
bindCommand(keyboard0, make, $CmdHUD::CmdKeySmall, TO, "CmdHud::turnOn(Small);");
bindCommand(keyboard0, make, $CmdHUD::InventoryKey, TO, "InvHud::turnOn();");
bindCommand(keyboard0, make, $CmdHUD::ObjectiveKey, TO, "CmdHud::ObjectiveOn();");

EditActionMap("PlayMap.sae");
bindCommand(keyboard0, make, $CmdHUD::CommanderKey, TO, "CmdHud::turnOn();");
bindCommand(keyboard0, make, $CmdHUD::CmdKeyLarge, TO, "CmdHud::turnOn(Large);");
bindCommand(keyboard0, make, $CmdHUD::CmdKeySmall, TO, "CmdHud::turnOn(Small);");
bindCommand(keyboard0, make, $CmdHUD::InventoryKey, TO, "InvHud::turnOn();");
bindCommand(keyboard0, make, $CmdHUD::ObjectiveKey, TO, "CmdHud::ObjectiveOn();");

NewActionMap("pdaMap.sae");
bindCommand(keyboard0, make, $CmdHUD::CommanderKey, TO, "CmdHUD::turnOff();");
bindCommand(keyboard0, make, $CmdHUD::CmdKeyLarge, TO, "CmdHud::turnOff(Large);");
bindCommand(keyboard0, make, $CmdHUD::CmdKeySmall, TO, "CmdHud::turnOff(Small);");
bindCommand(keyboard0, make, $CmdHUD::InventoryKey, TO, "InvHUD::turnOff();");
bindCommand(keyboard0, make, $CmdHUD::ObjectiveKey, TO, "CmdHud::ObjectiveOff();");
bindCommand(keyboard0, make, $CmdHUD::CursorKey, TO, "$CmdHUD::State = CmdHUD::Cursor(!$CmdHUD::State);");

Event::Attach(eventEnterCommand, CmdHUD::EnterStation);
Event::Attach(eventExitCommand, CmdHUD::ExitStation);
Event::Attach(eventEnterStation, InvHUD::EnterStation);
Event::Attach(eventExitStation, InvHUD::ExitStation);

Event::Attach(eventConnected, CmdHUD::Reset);
Event::Attach(eventChangeMission, CmdHUD::Reset);

Event::Attach(eventClientMessage, CamHud::onClientMessage);
