Attribute VB_Name = "mDirToMenu"
'---------------------------------------------------------------------------
'Copyright 1997-1998 by Brian Kelly
'
'This program is free software; you can redistribute it and/or
'modify it under the terms of the GNU General Public License
'as published by the Free Software Foundation; either version 2
'of the License, or (at your option) any later version.
'
'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'See the GNU General Public License for more details.
'
'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'---------------------------------------------------------------------------
Option Explicit

Public Type shellMenuItem
    Caption As String
    FileName As String
End Type

Public Type shellMenu
    Menu() As shellMenuItem
    NumItems As Integer
End Type

'---------
'DirToMenu
'---------
Public Function DirToMenu(DirPath As String) As shellMenu

    Dim tempSM As shellMenu
    Dim currentPath As String
    Dim realPath As String
    Dim temp As String
    
    On Error GoTo DirToMenu_Err
    
    realPath = DirPath
    If Right(realPath, 1) <> "\" Then realPath = realPath & "\"
    currentPath = Dir(realPath & "*.*")
    
    With tempSM
        .NumItems = 0
        Do Until currentPath = ""
            .NumItems = .NumItems + 1
            ReDim Preserve .Menu(.NumItems - 1) As shellMenuItem
            .Menu(.NumItems - 1).FileName = realPath & currentPath
            .Menu(.NumItems - 1).Caption = TokStrip(TokStrip(currentPath, ".", tsLastTok, tsBeforeTok), "\", tsLastTok, tsAfterTok)
            currentPath = Dir
        Loop
    End With
    
    DirToMenu = tempSM
    
    Exit Function

DirToMenu_Err:
    Select Case Err.Number
        Case Else:
            ReportError Err.Number, Err.Description, "<Making Shortcut Menu>"
    End Select

End Function
