VERSION 5.00
Begin VB.Form fPatchInfo 
   Caption         =   "Patch Information"
   ClientHeight    =   5820
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6930
   LinkTopic       =   "Form1"
   ScaleHeight     =   5820
   ScaleWidth      =   6930
   StartUpPosition =   3  'Windows Default
   Begin VB.ComboBox cboFile 
      Height          =   315
      Left            =   120
      Style           =   2  'Dropdown List
      TabIndex        =   0
      ToolTipText     =   "Available Files for This Patch"
      Top             =   120
      Width           =   2055
   End
   Begin VB.ListBox lstPak 
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2085
      Left            =   120
      TabIndex        =   13
      Top             =   3360
      Width           =   3615
   End
   Begin VB.TextBox txtInfo 
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1575
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   11
      Text            =   "fPatchInfo.frx":0000
      Top             =   600
      Width           =   2535
   End
   Begin VB.FileListBox File1 
      Height          =   1650
      Left            =   2760
      TabIndex        =   12
      Top             =   840
      Visible         =   0   'False
      Width           =   2055
   End
   Begin VB.CommandButton btnClose 
      Cancel          =   -1  'True
      Caption         =   "Close"
      Height          =   315
      Left            =   5520
      TabIndex        =   10
      ToolTipText     =   "Close This Window"
      Top             =   120
      Width           =   735
   End
   Begin VB.CommandButton btnExplore 
      Height          =   315
      Left            =   5160
      Picture         =   "fPatchInfo.frx":0006
      Style           =   1  'Graphical
      TabIndex        =   9
      Top             =   120
      Width           =   375
   End
   Begin VB.CommandButton btnDelete 
      Height          =   315
      Left            =   4800
      Picture         =   "fPatchInfo.frx":00C2
      Style           =   1  'Graphical
      TabIndex        =   8
      ToolTipText     =   "Delete This File"
      Top             =   120
      Width           =   375
   End
   Begin VB.CommandButton btnUse 
      Height          =   315
      Left            =   4440
      Picture         =   "fPatchInfo.frx":011C
      Style           =   1  'Graphical
      TabIndex        =   7
      ToolTipText     =   "Use This File"
      Top             =   120
      Width           =   375
   End
   Begin VB.CommandButton btnPlaySound 
      Height          =   315
      Left            =   4080
      Picture         =   "fPatchInfo.frx":01A5
      Style           =   1  'Graphical
      TabIndex        =   6
      ToolTipText     =   "Play Sound"
      Top             =   120
      Width           =   375
   End
   Begin VB.CommandButton btnExtractFile 
      Height          =   315
      Left            =   3720
      Picture         =   "fPatchInfo.frx":03CF
      Style           =   1  'Graphical
      TabIndex        =   5
      ToolTipText     =   "Extract File from PAK"
      Top             =   120
      Width           =   375
   End
   Begin VB.CommandButton btnSaveAs 
      Height          =   315
      Left            =   3360
      Picture         =   "fPatchInfo.frx":044A
      Style           =   1  'Graphical
      TabIndex        =   4
      ToolTipText     =   "Save As..."
      Top             =   120
      Width           =   375
   End
   Begin VB.CommandButton btnSave 
      Height          =   315
      Left            =   3000
      Picture         =   "fPatchInfo.frx":04D9
      Style           =   1  'Graphical
      TabIndex        =   3
      ToolTipText     =   "Save"
      Top             =   120
      Width           =   375
   End
   Begin VB.CommandButton btnEditCFG 
      Height          =   315
      Left            =   2640
      Picture         =   "fPatchInfo.frx":054B
      Style           =   1  'Graphical
      TabIndex        =   2
      ToolTipText     =   "Edit File with CFG File Editor Specified in the Settings Window"
      Top             =   120
      Width           =   375
   End
   Begin VB.CommandButton btnNew 
      Height          =   315
      Left            =   2280
      Picture         =   "fPatchInfo.frx":05FB
      Style           =   1  'Graphical
      TabIndex        =   1
      ToolTipText     =   "New Text File"
      Top             =   120
      Width           =   375
   End
   Begin VB.Label lblFileInfo 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "File Information"
      Height          =   255
      Left            =   120
      TabIndex        =   14
      Top             =   5520
      Width           =   4695
   End
   Begin VB.Label lblNoLuck 
      Alignment       =   2  'Center
      Caption         =   "Sorry, I only work with text files and PAK files.  Thank you.  Drive Thru..."
      Height          =   5055
      Left            =   120
      TabIndex        =   15
      Top             =   600
      Width           =   5175
   End
End
Attribute VB_Name = "fPatchInfo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'---------------------------------------------------------------------------
'Copyright 1997-1998 by Brian Kelly
'
'This program is free software; you can redistribute it and/or
'modify it under the terms of the GNU General Public License
'as published by the Free Software Foundation; either version 2
'of the License, or (at your option) any later version.
'
'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'See the GNU General Public License for more details.
'
'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'---------------------------------------------------------------------------
Option Explicit

Const PAK_MODE = 0
Const TXT_MODE = 1
Const BIN_MODE = 2
Const SAV_MODE = 3
Const DEM_MODE = 4
Const WAV_MODE = 5

Dim changed As Boolean

Dim skipFlag As Boolean

Dim newFile As Boolean

Dim shutDown As Boolean

Dim fileInfo As String

Dim currentMode As Integer
Dim currentFile As String
Dim currentPath As String
Dim fileType As String

Dim p As pakDir

Private Sub btnClose_Click()

    Unload Me

End Sub

Private Sub btnDelete_Click()

    Dim i As Integer
    Dim j As Integer
    Dim temp As String
    Dim MSG As String
    
    If newFile Then
        MSG = "Why in the name of Carmack would "
        MSG = MSG & "you try to delete a file that doesn't "
        MSG = MSG & "even exist yet?"
        MsgBox MSG, vbExclamation, AppName
        txtInfo.SetFocus
        Exit Sub
    End If
    
    temp = LCase(patchName & "\" & currentFile)
    If (temp = "id1\pak0.pak") Or (temp = "id1\pak1.pak") Then
        MSG = "I'm sorry, but the theory of self-preservation "
        MSG = MSG & "will not allow me to remove an original id "
        MSG = MSG & "pak file.  Get some other stooge to do "
        MSG = MSG & "your dirty work!"
        MsgBox MSG, vbInformation, AppName
        cboFile.SetFocus
        Exit Sub
    End If
    
    MSG = "Are you absolutely sure you want to delete the following file:"
    MSG = MSG & Chr(13) & currentPath & "\" & currentFile & "?"
    MSG = MSG & Chr(13) & "This action is COMPLETELY IRREVERSIBLE."
    
    If MsgBox(MSG, vbYesNo, AppName) = vbYes Then
        Select Case currentMode
            Case SAV_MODE:
                temp = currentFile
                i = InStr(1, currentFile, ".")
                j = InStr(1, fMain.txtSavedGame.Text, ".")
                If j = 0 Then
                    If i <> 0 Then temp = Left(currentFile, i - 1)
                End If
                If LCase(fMain.txtSavedGame.Text) = LCase(temp) Then
                    fMain.txtSavedGame.Text = ""
                    'fMain.UpdateFileOptions 0
                End If
            Case DEM_MODE:
                temp = currentFile
                i = InStr(1, currentFile, ".")
                j = InStr(1, fMain.txtPlayDemo.Text, ".")
                If j = 0 Then
                    If i <> 0 Then temp = Left(currentFile, i - 1)
                End If
                If LCase(fMain.txtPlayDemo.Text) = LCase(temp) Then
                    fMain.txtPlayDemo.Text = ""
                    'fMain.UpdateFileOptions 0
                End If
            Case TXT_MODE:
                j = -1
                For i = 0 To fMain.lstCfgFiles.ListCount - 1
                    If LCase(fMain.lstCfgFiles.List(i)) = LCase(currentFile) Then j = i
                Next i
                If j > -1 Then
                    fMain.RemoveCfg j
                    fMain.BuildCommandLine
                End If
        End Select
        Kill currentPath & "\" & currentFile
        UpdateFileList
        cboFile.ListIndex = 0
    End If
    
    cboFile.SetFocus

End Sub

Private Sub btnEditCfg_Click()

    Dim result As Long
    
    result = Shell(diffEditPath & " " & currentPath & "\" & currentFile, vbNormalFocus)
    
End Sub

Private Sub btnExplore_Click()

    Dim result As Long
    
    result = Shell("explorer " & currentPath, vbNormalFocus)

    cboFile.SetFocus

End Sub

Private Sub btnExtractFile_Click()

    Dim pIndex As Integer
    Dim MSG As String
    Dim newFilePath As String
    Dim inFile As Integer
    Dim outFile As Integer
    
    On Error GoTo Hell
    
    pIndex = lstPak.ListIndex
    
    With fMain.cd
        'We gotta find the damn file location where they want it
        .CancelError = True
        .InitDir = File1.path
        .DefaultExt = Right(p.directory(pIndex).Name, 3)
        .DialogTitle = "Save File As..."
        .filter = "All Files (*.*)|*.*"
        .FileName = TokStrip(p.directory(pIndex).Name, "/", tsLastTok, tsAfterTok)
        .FilterIndex = 1
        .MaxFileSize = 30000
        .ShowSave
    
        'we have to specially trap this section
        On Error GoTo SpecialCase
    
        If FileLen(.FileName) <> 0 Then
            MSG = .FileTitle & " already exists in this location."
            MSG = MSG & Chr(13) & "Do you want to overwrite it?"
            If MsgBox(MSG, vbQuestion + vbYesNo, AppName) = vbNo Then Exit Sub
        End If

Continue:

        newFilePath = .FileName
        
    End With
    
    ' LET'S DO IT!!!
    ' open the pak file
    inFile = FreeFile
    Open currentPath & "\" & currentFile For Binary As inFile
    outFile = FreeFile
    Open newFilePath For Binary As outFile
    MSG = String(p.directory(pIndex).size, " ")
    Get #inFile, p.directory(pIndex).pos, MSG
    Put #outFile, 1, MSG
    Close outFile
    Close inFile
    

    On Error GoTo Hell
    
    targetFile = currentFile
    UpdatePatchExplorer
    
    Exit Sub
    
SpecialCase:
    Select Case Err.Number
        Case 32755:  'cancel was selected
            ' don't do a damn thing
        Case 53:  'the file doesn't exist, continue normally
            GoTo Continue
        Case Else:
            ReportError Err.Number, Err.Description, "<Extracting File from PAK - SPECIAL CASE>"
    End Select
    Exit Sub
    
Hell:
    Select Case Err.Number
        Case 32755:  'cancel was selected
            '  don't do a damn thing
        Case Else:
            ReportError Err.Number, Err.Description, "<Trying to Extract a File from a PAK File>"
    End Select

End Sub

Private Sub btnNew_Click()

    If changed Then
        Select Case MsgBox("Save changes to " & currentFile & "?", vbQuestion + vbYesNoCancel, AppName)
            Case vbYes:
                btnSave_Click
            Case vbCancel:
                Exit Sub
        End Select
    End If
    
    changed = False
    newFile = True
    cboFile.ListIndex = -1
    ChangeMode TXT_MODE
    txtInfo.Text = ""
    If targetFile <> CREATE_NEW_FILE Then txtInfo.SetFocus
    currentFile = "untitled"
    fileInfo = currentFile & " (New Text File)"
    lblFileInfo.Caption = fileInfo
    changed = True

End Sub

Private Sub btnPlaySound_Click()

    Dim inFile As Integer
    Dim pIndex As Integer
    Dim crap As Integer
    Dim MSG As String
    
    pIndex = lstPak.ListIndex
    
    If currentMode = PAK_MODE Then
        inFile = FreeFile
        Open currentPath & "\" & currentFile For Binary As inFile
        MSG = String(p.directory(pIndex).size, " ")
        Get #inFile, p.directory(pIndex).pos, MSG
        crap = PlaySound(MSG, 0, SND_ASYNC + SND_MEMORY)
        Close inFile
        lstPak.SetFocus
    Else
        crap = PlaySound(currentPath & "\" & currentFile, 0, SND_ASYNC)
        cboFile.SetFocus
    End If

End Sub

Private Sub btnSave_Click()

    Dim fn As Integer

    If newFile Then
        btnSaveAs_Click
        Exit Sub
    End If

    If changed Then
        fn = FreeFile
        Open currentPath & "\" & currentFile For Output As fn
        Print #fn, txtInfo.Text
        Close fn
        lblFileInfo.Caption = fileInfo
        changed = False
    End If
    
    txtInfo.SetFocus
    
End Sub

Private Sub btnSaveAs_Click()

    Dim MSG As String
    Dim newFilePath As String
    Dim fn As Integer
    
    On Error GoTo Hell
    
TryAgain:
    
    With fMain.cd
        'We gotta find the damn file location where they want it
        .CancelError = True
        .InitDir = File1.path
        .DefaultExt = ""
        .DialogTitle = "Save File As..."
        .filter = "All Files (*.*)|*.*"
        .FileName = currentFile
        .FilterIndex = 1
        .MaxFileSize = 30000
        .ShowSave
    
        'we have to specially trap this section
        On Error GoTo SpecialCase
    
        If FileLen(.FileName) <> 0 Then
            MSG = .FileTitle & " already exists in this location."
            MSG = MSG & Chr(13) & "Do you want to overwrite it?"
            If MsgBox(MSG, vbQuestion + vbYesNo, AppName) = vbNo Then GoTo TryAgain
        End If

        On Error GoTo Hell

Continue:

        newFilePath = .FileName
        
    End With

    'We've gotten through the rigamaroll... let's write the damn file.
    fn = FreeFile
    Open newFilePath For Output As fn
    Print #fn, txtInfo.Text
    Close fn
    
    'A little cleanup for the nice lady...
    changed = False
    newFile = False
    txtInfo.SetFocus
    UpdateFileList
    currentFile = TokStrip(newFilePath, "\", tsLastTok, tsAfterTok)
    cboFile.ListIndex = FindInList(cboFile, currentFile)
    UpdateFileInfo
    Exit Sub
    
SpecialCase:
    Select Case Err.Number
        Case 32755:  'cancel was selected
            ' don't do a damn thing
        Case 53:  'the file doesn't exist, continue normally
            GoTo Continue
        Case Else:
            ReportError Err.Number, Err.Description, "<Saving As... - SPECIAL CASE>"
    End Select
    txtInfo.SetFocus
    Exit Sub
    
Hell:
    Select Case Err.Number
        Case 32755:  'cancel was selected
            '  don't do a damn thing
        Case Else:
            ReportError Err.Number, Err.Description, "<Saving As...>"
    End Select

    txtInfo.SetFocus

End Sub

Private Sub btnUse_Click()

    Dim i As Integer
    Dim okay As Boolean
    
    Select Case currentMode
        Case SAV_MODE:
            fMain.UpdateFileOptions 1, currentFile
        Case DEM_MODE:
            fMain.UpdateFileOptions 2, currentFile
        Case TXT_MODE:
            okay = True
            For i = 0 To fMain.lstCfgFiles.ListCount - 1
                If LCase(fMain.lstCfgFiles.List(i)) = LCase(currentFile) Then okay = False
            Next i
            If okay Then
                fMain.lstCfgFiles.AddItem currentFile
                fMain.BuildCommandLine
            End If
    End Select

    cboFile.SetFocus

End Sub

Private Sub cboFile_Click()
    
    Dim lenFile As Long
    Dim s As String
    Dim i As Integer
    Dim fn As Integer
    Dim temp As String
    Dim ext As String
    Dim rememberWhen As String
    
    On Error GoTo Hell
    
    If skipFlag Then Exit Sub
    
    rememberWhen = currentFile
    
    If changed Then
        Select Case MsgBox("Save changes to " & currentFile & "?", vbQuestion + vbYesNoCancel, AppName)
            Case vbYes:
                btnSave_Click
            Case vbCancel:
                skipFlag = True
                If newFile Then
                    cboFile.ListIndex = -1
                Else
                    cboFile.ListIndex = FindInList(cboFile, currentFile)
                End If
                skipFlag = False
                txtInfo.SetFocus
                Exit Sub
        End Select
    End If
        
    If cboFile.ListIndex = -1 Then Exit Sub
    
    fn = FreeFile
    
    currentPath = File1.path
    currentFile = cboFile.List(cboFile.ListIndex)
    
    temp = currentFile
    i = InStr(1, temp, ".")
    ext = Right(temp, Len(temp) - i)
    fileType = QFileType(ext)
    
    'I embedded the close commands in the if-then below.
    'it sucks, but it's for the best right now.
    'sorry, Dr. Albright...
    Open currentPath & "\" & currentFile For Binary As fn
        
        If VerifyPak(fn) Then
            lstPak.Clear
            p = ListPak(fn)
            For i = 0 To p.numFiles - 1
                lstPak.AddItem p.directory(i).Name
            Next i
            lstPak.ListIndex = 0
            ChangeMode PAK_MODE
            Close fn
        Else
            lenFile = LOF(fn)
            If lenFile > 32768 Then
                lenFile = 32768
            End If
            s = String(lenFile, " ")
            Get #fn, 1, s
            Close fn
            If InStr(1, s, Chr(0)) <> 0 Then
                Select Case LCase(ext)
                    Case "dem":
                        ChangeMode DEM_MODE
                    Case "wav":
                        ChangeMode WAV_MODE
                    Case Else:
                        ChangeMode BIN_MODE
                End Select
            Else
                If LCase(ext) = "sav" Then
                    ChangeMode SAV_MODE
                Else
                    txtInfo = s
                    ChangeMode TXT_MODE
                End If
            End If
        End If
        
    btnDelete.ToolTipText = "Delete " & currentFile
    
    changed = False
    
    UpdateFileInfo
    
    Exit Sub
    
Hell:
    Select Case Err.Number
        Case 70:
            MsgBox "File currently in use by another program.", vbInformation, AppName
            cboFile.ListIndex = FindInList(cboFile, rememberWhen)
        Case Else:
            ReportError Err.Number, Err.Description, "<Reading a patch-related file>"
    End Select
    
End Sub

Private Sub Form_Load()

    shutDown = False
    Me.Icon = fMain.Icon
    Me.Top = infoTop
    Me.Left = infoLeft
    Me.Height = infoHeight
    Me.Width = infoWidth

    UpdatePatchExplorer
    btnExplore.ToolTipText = "Browse " & patchName & " directory with Win 95 Explorer"
    If shutDown Then Unload Me
    
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)

    infoTop = Me.Top
    infoLeft = Me.Left
    infoWidth = Me.Width
    infoHeight = Me.Height
    
    If changed Then
        Select Case MsgBox("Save changes to " & currentFile & "?", vbQuestion + vbYesNoCancel, AppName)
            Case vbYes:
                btnSave_Click
            Case vbCancel:
                Cancel = 1
        End Select
    End If

End Sub

Private Sub Form_Resize()

    If Me.Height < 1700 Then GoTo Check_Width

    lstPak.Top = 600
    lstPak.Height = Me.Height - 1400
    txtInfo.Top = 600
    txtInfo.Height = Me.Height - 1400
    lblNoLuck.Top = 840
    lblFileInfo.Top = Me.Height - 675
    
Check_Width:
    
    If Me.Width < 400 Then Exit Sub
    
    lblNoLuck.Width = Me.Width - 360
    lblFileInfo.Width = Me.Width - 360
    lstPak.Width = Me.Width - 360
    txtInfo.Width = Me.Width - 360
    
End Sub

Private Sub Form_Unload(Cancel As Integer)

    changed = False
    newFile = False

End Sub

Private Sub lstPak_Click()

    Dim temp As String
    Dim ext As String
    Dim i As Integer
    
    temp = p.directory(lstPak.ListIndex).Name
    temp = TokStrip(temp, "/", tsLastTok, tsAfterTok)
    i = InStr(1, temp, ".")
    btnExtractFile.ToolTipText = "Extract " & temp & " from " & currentFile
    ext = Right(temp, Len(temp) - i)
    temp = " " & currentFile & ": " & temp 'Left(temp, Len(temp) - Len(ext) - 1)
    temp = " " & temp & " (" & QFileType(ext)
    temp = temp & ", " & NeatFileSize(p.directory(lstPak.ListIndex).size) & ")"
    
    lblFileInfo.Caption = temp

End Sub

Private Sub ChangeMode(modeType As Integer)

    Dim a As Boolean
    Dim b As Boolean
    Dim c As Boolean
    Dim d As Boolean
    
    Select Case modeType
        Case PAK_MODE:
            a = True
            b = False
            c = False
            d = False
        Case TXT_MODE:
            a = False
            b = True
            c = False
            d = False
            btnUse.ToolTipText = "Add " & currentFile & " to Execute List"
        Case SAV_MODE:
            a = False
            b = False
            c = True
            d = False
            btnUse.ToolTipText = "Load " & currentFile & " with current QuakeSet"
            lblNoLuck.Alignment = vbLeftJustify
            lblNoLuck.Caption = SavedGameInfo(currentPath & "\" & currentFile)
        Case DEM_MODE:
            a = False
            b = False
            c = True
            d = False
            btnUse.ToolTipText = "Play " & currentFile & " with current QuakeSet"
            lblNoLuck.Alignment = vbCenter
            lblNoLuck.Caption = "You have selected a Demo.  Click the Use button to play this demo with the current QuakeSet."
        Case WAV_MODE:
            a = False
            b = False
            c = True
            d = True
            lblNoLuck.Alignment = vbCenter
            lblNoLuck.Caption = "Click the Play Sound button to hear this sound."
        Case BIN_MODE:
            a = False
            b = False
            c = True
            d = False
            lblNoLuck.Alignment = vbCenter
            lblNoLuck.Caption = "You have selected a file that I cannot help you with.  Sorry."
    End Select
    
    lstPak.Visible = a
    btnExtractFile.Enabled = a
    btnEditCfg.Enabled = b And diffEdit
    txtInfo.Visible = b
    btnSave.Enabled = b
    btnSaveAs.Enabled = b
    lblNoLuck.Visible = c
    btnUse.Enabled = (c Or b) And (Not d)
    btnPlaySound.Enabled = a Or d
    
    currentMode = modeType

    Form_Resize

End Sub

Private Function QFileType(extension As String) As String

    Select Case LCase(extension)
        Case "txt"
            QFileType = "Text File"
        Case "bsp"
            QFileType = "Level"
        Case "qc", "src", "h"
            QFileType = "Quake C"
        Case "wad"
            QFileType = "Texture File"
        Case "dat"
            QFileType = "Compiled Quake C"
        Case "mdl"
            QFileType = "Model"
        Case "wav"
            QFileType = "Sound File"
        Case "cfg"
            QFileType = "Config File"
        Case "gif", "pcx", "bmp", "jpg"
            QFileType = "Image File"
        Case "tmp"
            QFileType = "Temporary File"
        Case "dem"
            QFileType = "Demo File"
        Case "sav"
            QFileType = "Saved Game"
        Case Else
            QFileType = extension & " file"
    End Select

End Function

Private Sub lstPak_DblClick()
'Gregorious G
    If InStr(1, p.directory(lstPak.ListIndex).Name, ".wav") Then
        btnPlaySound_Click
    Else
        btnExtractFile_Click
    End If

End Sub

Private Sub txtInfo_Change()

    changed = True
    UpdateFileInfo

End Sub

Private Sub UpdateFileInfo()

    Dim fileSize As Long
    
    On Error GoTo Special
    
    fileSize = FileLen(currentPath & "\" & currentFile)
    
    On Error GoTo Hell
    
BackToLife:
    
    fileInfo = currentFile & " (" & fileType & ", "
    fileInfo = fileInfo & NeatFileSize(fileSize) & ")"
    
    If changed Then
        lblFileInfo.Caption = " " & fileInfo & " - File Modified"
    Else
        lblFileInfo.Caption = " " & fileInfo
    End If
    
    Exit Sub

Special:
    Select Case Err.Number
        Case 53: 'couldn't find the file
            fileSize = 0
            GoTo BackToLife
        Case Else:
            ReportError Err.Number, Err.Description, "<Updating File Information - Special Case>"
    End Select

    Exit Sub
    
Hell:
    Select Case Err.Number
        Case Else:
            ReportError Err.Number, Err.Description, "<Updating Status Bar>"
    End Select

End Sub

Private Sub UpdateFileList()

    Dim i As Integer
    
    File1.path = currentPath
    File1.Refresh
    cboFile.Clear
    
    For i = 0 To (File1.ListCount - 1)
        cboFile.AddItem File1.List(i)
    Next i
    
End Sub

Public Sub UpdatePatchExplorer()
    
    Dim quakeDir As String
    Dim i As Integer
    
    quakeDir = qSets(fMain.lstQuakeSets.ListIndex).quakeDir
    
    Me.Caption = "Patch Explorer [" & patchName & "]"
    
    currentPath = quakeDir & "\" & patchName
    
    UpdateFileList
    
    i = FindInList(cboFile, targetFile)
    If i >= 0 Then
        cboFile.ListIndex = i
    Else
        cboFile.ListIndex = 0
    End If
    
    If targetFile = CREATE_NEW_FILE Then btnNew_Click
        
End Sub

Public Function SavedGameInfo(savPath As String) As String

    Dim fn As Integer
    Dim ent1 As String
    Dim ent2 As String
    Dim ent3 As String
    Dim result As String
    
    'from first entity
    Dim mapName As String
    Dim time As String
    Dim totalSecrets As String
    Dim foundSecrets As String
    Dim totalMonsters As String
    Dim killedMonsters As String
    
    'from second entity
    Dim message As String
    
    'from third entity
    Dim ammoShells As String
    Dim ammoNails As String
    Dim ammoRockets As String
    Dim ammoCells As String
    Dim netName As String
    Dim health As String
    Dim armor As String
    Dim armorType As String
    
    Dim tempMsg As String

    On Error GoTo Hell

    'the first thing to do is to open the file and read the entities
    fn = FreeFile
    Open savPath For Input As fn
        ent1 = ReadEnt(fn)
        ent2 = ReadEnt(fn)
        ent3 = ReadEnt(fn)
    Close fn
    
    'lock and load the values
    mapName = GetEntValue(ent1, "mapname")
    time = Format(GetEntValue(ent1, "time"), "0")
    totalSecrets = Format(GetEntValue(ent1, "total_secrets"), "0")
    foundSecrets = Format(GetEntValue(ent1, "found_secrets"), "0")
    totalMonsters = Format(GetEntValue(ent1, "total_monsters"), "0")
    killedMonsters = Format(GetEntValue(ent1, "killed_monsters"), "0")
    message = GetEntValue(ent2, "message")
    ammoShells = Format(GetEntValue(ent3, "ammo_shells"), "0")
    ammoNails = Format(GetEntValue(ent3, "ammo_nails"), "0")
    ammoRockets = Format(GetEntValue(ent3, "ammo_rockets"), "0")
    ammoCells = Format(GetEntValue(ent3, "ammo_cells"), "0")
    netName = GetEntValue(ent3, "netname")
    health = Format(GetEntValue(ent3, "health"), "0")
    armor = Format(GetEntValue(ent3, "armorvalue"), "0")
    armorType = Format(GetEntValue(ent3, "armortype"), "0.0")
    
    result = "Level:  " & mapName & " - " & message
    result = result & Chr(13) & "Time:  "
    'If Val(time) < 60 Then
    '     result = result & time & " seconds"
    'Else
        result = result & Format(Val(time) / 60, "0") & ":" & Format(Val(time) Mod 60, "00")
    'End If
    result = result & Chr(13) & "Found Secrets:  " & foundSecrets & "/" & totalSecrets
    If Val(totalSecrets) > 0 Then
        result = result & " (" & Format((Val(foundSecrets) / Val(totalSecrets)) * 100, "0") & "%)"
    End If
    result = result & Chr(13) & "Killed Monsters:  " & killedMonsters & "/" & totalMonsters
    If Val(totalMonsters) > 0 Then
        result = result & " (" & Format((Val(killedMonsters) / Val(totalMonsters)) * 100, "0") & "%)"
    End If
    result = result & Chr(13)
    result = result & Chr(13) & "Name:  " & netName
    result = result & Chr(13) & "Health:  " & health
    Select Case Val(armorType)
        Case 0.3:
            result = result & Chr(13) & "Armor: " & armor & " (Green)"
        Case 0.6:
            result = result & Chr(13) & "Armor: " & armor & " (Yellow)"
        Case 0.8:
            result = result & Chr(13) & "Armor: " & armor & " (Red)"
        Case Else:
            result = result & Chr(13) & "Armor:  None"
    End Select
    
    If ammoShells = "" Then
        result = result & Chr(13) & "Shells:  None"
    Else
        result = result & Chr(13) & "Shells:  " & ammoShells
    End If
    
    If ammoNails = "" Then
        result = result & Chr(13) & "Nails:  None"
    Else
        result = result & Chr(13) & "Nails:  " & ammoNails
    End If
    
    If ammoRockets = "" Then
        result = result & Chr(13) & "Rockets:  None"
    Else
        result = result & Chr(13) & "Rockets:  " & ammoRockets
    End If
    
    If ammoCells = "" Then
        result = result & Chr(13) & "Cells:  None"
    Else
        result = result & Chr(13) & "Cells:  " & ammoCells
    End If
    
    SavedGameInfo = result
    
    Exit Function
    
Hell:
    Select Case Err.Number
        Case 13:
            tempMsg = "I'm sorry, but I've encountered an error that"
            tempMsg = tempMsg & Chr(13) & "I believe only affects non-U.S. users of QuakeOn."
            tempMsg = tempMsg & Chr(13) & "If you get this error, feel free to let me know,"
            tempMsg = tempMsg & Chr(13) & "and if there's another release of QuakeOn, I'll look"
            tempMsg = tempMsg & Chr(13) & "into fixing it..."
            MsgBox tempMsg, vbInformation, AppName
        Case Else:
            ReportError Err.Number, Err.Description, "<Reading Saved Game Info>"
    End Select

End Function

Public Function ReadEnt(fn As Integer) As String

    Dim temp As String
    Dim result As String
    Dim done As Boolean
    
    'first, we have to find the start of the entity
    done = False
    Do
        Line Input #fn, temp
        If temp = "{" Then done = True
        If EOF(fn) Then
            ReadEnt = ""
            Exit Function
        End If
    Loop Until done
    
    'then, we just read in the entity
    done = False
    result = ""
    Do
        Line Input #fn, temp
        If temp = "}" Then
            done = True
        Else
            result = result & temp
            If EOF(fn) Then
                ReadEnt = ""
                Exit Function
            End If
        End If
    Loop Until done
    
    ReadEnt = result

End Function

Public Function GetEntValue(entity As String, key As String) As String

    Dim i As Integer
    Dim temp As String
    
    i = InStr(1, entity, key)
    
    If i = 0 Then
        GetEntValue = ""
        Exit Function
    End If
    
    temp = Right(entity, Len(entity) - (i + Len(key) + 2))

    i = InStr(1, temp, Chr(34))
    
    If i = 0 Then
        GetEntValue = ""
        Exit Function
    End If

    GetEntValue = Left(temp, i - 1)

End Function
