VERSION 5.00
Begin VB.Form fConsole 
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "Console Help"
   ClientHeight    =   3870
   ClientLeft      =   45
   ClientTop       =   285
   ClientWidth     =   7830
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3870
   ScaleWidth      =   7830
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.PictureBox picFilter 
      Height          =   3675
      Left            =   1920
      ScaleHeight     =   3615
      ScaleWidth      =   5715
      TabIndex        =   16
      Top             =   120
      Width           =   5775
      Begin VB.CommandButton btnCancelFilter 
         Caption         =   "Cancel"
         Height          =   375
         Left            =   4080
         TabIndex        =   14
         Top             =   2880
         Width           =   1455
      End
      Begin VB.CommandButton btnFilter 
         Caption         =   "Filter Now!"
         Height          =   375
         Left            =   4080
         TabIndex        =   13
         Top             =   2400
         Width           =   1455
      End
      Begin VB.TextBox txtFilterText 
         Height          =   285
         Left            =   2160
         TabIndex        =   10
         Top             =   840
         Width           =   3375
      End
      Begin VB.ListBox lstFilterType 
         Height          =   1815
         Left            =   480
         MultiSelect     =   1  'Simple
         TabIndex        =   12
         Top             =   1560
         Width           =   3375
      End
      Begin VB.CheckBox chkFilterType 
         Caption         =   "Of type:"
         Height          =   255
         Left            =   120
         TabIndex        =   11
         Top             =   1200
         Width           =   1215
      End
      Begin VB.CheckBox chkFilterText 
         Caption         =   "Whose text contains:"
         Height          =   255
         Left            =   120
         TabIndex        =   9
         Top             =   840
         Width           =   1935
      End
      Begin VB.TextBox txtFilterName 
         Height          =   285
         Left            =   2160
         TabIndex        =   8
         Top             =   480
         Width           =   3375
      End
      Begin VB.CheckBox chkFilterName 
         Caption         =   "Whose name contains:"
         Height          =   255
         Left            =   120
         TabIndex        =   7
         Top             =   480
         Width           =   2055
      End
      Begin VB.Label Label1 
         BackStyle       =   0  'Transparent
         Caption         =   "Show me only those items:"
         Height          =   255
         Left            =   120
         TabIndex        =   17
         Top             =   120
         Width           =   4695
      End
   End
   Begin VB.CommandButton btnSeeAlso 
      Caption         =   "See Also..."
      Height          =   315
      Left            =   6480
      TabIndex        =   3
      Top             =   420
      Width           =   1215
   End
   Begin VB.CommandButton btnShowAll 
      Caption         =   "Show All"
      Default         =   -1  'True
      Height          =   375
      Left            =   2760
      TabIndex        =   4
      Top             =   3360
      Width           =   1575
   End
   Begin VB.CommandButton btnShowFilter 
      Caption         =   "Filter..."
      Height          =   375
      Left            =   4440
      TabIndex        =   5
      Top             =   3360
      Width           =   1575
   End
   Begin VB.CommandButton btnClose 
      Cancel          =   -1  'True
      Caption         =   "Close"
      Height          =   375
      Left            =   6120
      TabIndex        =   6
      Top             =   3360
      Width           =   1575
   End
   Begin VB.TextBox txtDetails 
      Height          =   2415
      Left            =   1920
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   2
      Top             =   840
      Width           =   5775
   End
   Begin VB.ListBox lstCommands 
      Height          =   2985
      Left            =   120
      Sorted          =   -1  'True
      TabIndex        =   0
      Top             =   120
      Width           =   1695
   End
   Begin VB.TextBox txtQuickFind 
      Height          =   285
      Left            =   120
      TabIndex        =   1
      Top             =   3480
      Width           =   1695
   End
   Begin VB.Label lblQuickFind 
      Caption         =   "QuickFind:"
      Height          =   255
      Left            =   120
      TabIndex        =   23
      Top             =   3240
      Width           =   1455
   End
   Begin VB.Label lblSyntax 
      Caption         =   "lblSyntax"
      Height          =   195
      Left            =   2640
      TabIndex        =   22
      Top             =   480
      Width           =   3735
   End
   Begin VB.Label lblType 
      Caption         =   "lblType"
      Height          =   195
      Left            =   6120
      TabIndex        =   21
      Top             =   120
      Width           =   1455
   End
   Begin VB.Label lblCommand 
      Caption         =   "lblCommand"
      Height          =   195
      Left            =   2880
      TabIndex        =   20
      Top             =   120
      Width           =   2535
   End
   Begin VB.Label lblInfo 
      AutoSize        =   -1  'True
      Caption         =   "Syntax:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Index           =   2
      Left            =   1920
      TabIndex        =   19
      Top             =   480
      Width           =   645
   End
   Begin VB.Label lblInfo 
      AutoSize        =   -1  'True
      Caption         =   "Type:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Index           =   1
      Left            =   5520
      TabIndex        =   18
      Top             =   120
      Width           =   495
   End
   Begin VB.Label lblInfo 
      AutoSize        =   -1  'True
      Caption         =   "Command:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Index           =   0
      Left            =   1920
      TabIndex        =   15
      Top             =   120
      Width           =   885
   End
End
Attribute VB_Name = "fConsole"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'---------------------------------------------------------------------------
'Copyright 1997-1998 by Brian Kelly
'
'This program is free software; you can redistribute it and/or
'modify it under the terms of the GNU General Public License
'as published by the Free Software Foundation; either version 2
'of the License, or (at your option) any later version.
'
'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
'
'See the GNU General Public License for more details.
'
'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'---------------------------------------------------------------------------
Option Explicit

Const CONSOLE_FILENAME = "console.dat"

Dim seeAlsoHolder As String

Private Type ConsoleEntry
    Name As String
    Text As String
    Type As String
End Type

Dim console() As ConsoleEntry
Dim console_UB As Integer

Dim conPath As String
Dim FilterOn As Boolean

Private Sub btnCancelFilter_Click()

    FilterShowing False

End Sub

Private Sub btnCancelFilter_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay FLT_CANCEL

End Sub

Private Sub btnClose_Click()

    Unload Me

End Sub

Private Sub btnClose_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay FLT_CLOSE

End Sub

Private Sub btnFilter_Click()

    Dim i As Integer
    Dim done As Boolean
    Dim cmd As ConsoleEntry
    Dim iniSection As String

    'Change the cursor
    Screen.MousePointer = vbHourglass
    
    'Check to see if they have anything checked, if not just exit filter
    If (chkFilterName.Value + chkFilterText.Value + chkFilterType.Value) = 0 Then
        FilterShowing False
        Screen.MousePointer = vbDefault
        Exit Sub
    End If
    
    'Ok, let's go
    'Start by reloading all commands if necessary
    If FilterOn Then
        lstCommands.Clear
        ParseVals GetIniHeaders(conPath, ",", "Cmd"), ",", lstCommands
        lstCommands.ListIndex = 0
    End If
    
    'Reset console array
    console_UB = -1
    
    'Now let's go through the whole list adding only the ones that pass the filters
    For i = 0 To lstCommands.ListCount - 1
        'Get the command
        cmd.Name = lstCommands.List(i)
        iniSection = GetSection(conPath, "Cmd " & cmd.Name)
        cmd.Text = GetKey(iniSection, "Text", "No Data Found")
        cmd.Type = GetKey(iniSection, "Type", "Unknown Type")
        
        'add command to console array if it passes the filter
        If FilterOk(cmd) Then
            console_UB = console_UB + 1
            ReDim Preserve console(console_UB) As ConsoleEntry
            'Add command to last element in array
            console(console_UB) = cmd
        End If
    Next i
    
    Screen.MousePointer = vbDefault
    
    If console_UB > -1 Then
        'Now let's recreate the listbox
        lstCommands.Clear
        For i = 0 To console_UB
            lstCommands.AddItem console(i).Name
        Next i
    
        'That's it...filter is on
        FilterOn = True
    
        'Hide the filter frame
        FilterShowing False
    
        lstCommands.ListIndex = 0
    Else
        MsgBox "Sorry... Your search yielded no results.", vbInformation, "Console Search"
    End If
            
End Sub

Private Sub btnFilter_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay FLT_FILT_NOW

End Sub

Private Sub btnSeeAlso_Click()

    Dim temp As String
    Dim tempPop As PopupList
    Dim loc As Integer
    
    modalFormShowing = True
    temp = ShowPopupWindow(tempPop, "See Also...", seeAlsoHolder, ",")
    modalFormShowing = False
    loc = FindInList(lstCommands, temp)
    If loc > -1 Then lstCommands.ListIndex = loc

End Sub

Private Sub btnSeeAlso_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay FLT_SEE_ALSO

End Sub

Private Sub btnShowAll_Click()

    'Reset the list only if something was filtered
    If FilterOn Then
        lstCommands.Clear
        ParseVals GetIniHeaders(conPath, ",", "Cmd"), ",", lstCommands
        lstCommands.ListIndex = 0
    End If
    FilterOn = False
    
End Sub

Private Sub btnShowAll_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay FLT_SHOW_ALL

End Sub

Private Sub btnShowFilter_Click()

    FilterShowing True

End Sub

Private Sub btnShowFilter_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay FLT_FILTER

End Sub

Private Sub chkFilterName_Click()

    If chkFilterName Then
        txtFilterName.SetFocus
        txtFilterName.SelStart = 0
        txtFilterName.SelLength = Len(txtFilterName.Text)
    End If
    
End Sub

Private Sub chkFilterName_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay FLT_NAME

End Sub

Private Sub chkFilterText_Click()

    If chkFilterText Then
        txtFilterText.SetFocus
        txtFilterText.SelStart = 0
        txtFilterText.SelLength = Len(txtFilterText.Text)
    End If

End Sub

Private Sub chkFilterText_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay FLT_TEXT

End Sub

Private Sub Form_Load()

    On Error GoTo Hell
    
    Select Case qSets(cqs).ddd
        Case "baseq2":
            conPath = App.path & "\q2con.dat"
        Case "data1":
            conPath = App.path & "\h2con.dat"
        Case Else:
            conPath = App.path & "\" & CONSOLE_FILENAME
    End Select
    
    If Dir(conPath) = "" Then
        conPath = App.path & "\" & CONSOLE_FILENAME
    End If
    
    ParseVals GetIniHeaders(conPath, ",", "Cmd"), ",", lstCommands
    'Read in types for type filtering
    ParseVals GetKey(GetSection(conPath, "Types"), "Typelist", "Server,Physics,Misc"), ",", lstFilterType
    
    lstCommands.ListIndex = 0
    FilterOn = False
    picFilter.Visible = False
    CenterForm Me
    
    Exit Sub
    
Hell:
    Select Case Err.Number
        Case Else:
            ReportError Err.Number, Err.Description, "<Loading Console Help>"
    End Select

End Sub

Private Sub lstCommands_Click()

    Dim iniSection As String
    Dim commandName As String
    Dim commandType As String
    
    commandName = lstCommands.List(lstCommands.ListIndex)
    lblCommand.Caption = commandName
    
    'Read the ini section from the file
    iniSection = GetSection(conPath, "Cmd " & commandName)
    txtDetails.Text = ReplaceInstr(GetKey(iniSection, "Text", "No Data Found"), "&&", CRLF)
    lblType.Caption = GetKey(iniSection, "Type", "Unknown Type")
    lblSyntax.Caption = GetKey(iniSection, "Syntax", "Unspecified Syntax")
    seeAlsoHolder = GetKey(iniSection, "SeeAlso", "")
    If seeAlsoHolder = "" Then
        btnSeeAlso.Enabled = False
    Else
        btnSeeAlso.Enabled = True
    End If

End Sub

Private Sub FilterShowing(b As Boolean)

    Dim c As Boolean
    
    c = Not (b)
    
    picFilter.Visible = b
    txtDetails.Enabled = c
    lstCommands.Enabled = c
    lblCommand.Enabled = c
    btnClose.Enabled = c
    btnShowAll.Enabled = c
    btnShowFilter.Enabled = c
    txtQuickFind.Enabled = c

End Sub

Private Sub lstCommands_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay FLT_PICK_CMD
    
End Sub

Private Sub lstFilterType_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay FLT_TYPE

End Sub

Private Sub picFilter_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay FLT_FILT_FRAME

End Sub

Private Sub txtFilterName_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay FLT_NAME

End Sub

Private Sub txtFilterText_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay FLT_TEXT

End Sub

Private Sub txtQuickFind_Change()

    lstCommands.ListIndex = QuickFind(txtQuickFind.Text, lstCommands)
    
End Sub

'This is a pretty kick-ass function that needs to be put
'in the utilities file at some point
Public Function SelectWord(txtBox As TextBox, Delimeter As String) As String

    Dim startLoc As Integer
    Dim endLoc As Integer
    Dim i As Integer
    Dim temp As String
    Dim currentLoc As Integer
    
    temp = txtBox.Text
    currentLoc = txtBox.SelStart
    startLoc = 0
    endLoc = Len(temp)
    
    For i = 1 To Len(txtBox.Text)
        If Mid(temp, i, 1) = Delimeter Then
            If i < currentLoc Then
                startLoc = i
            Else
                endLoc = i
                Exit For
            End If
        End If
    Next i
    
    txtBox.SelStart = startLoc
    If endLoc < Len(temp) Then endLoc = endLoc - 1
    txtBox.SelLength = endLoc - startLoc
    SelectWord = Trim(txtBox.SelText)

End Function

Public Function QuickFind(s As String, listbox As Object) As Integer

Dim i As Integer
Dim done As Boolean

    i = 0
    done = False
    Do Until done Or i = listbox.ListCount - 1
        If LCase(s) < LCase(listbox.List(i)) Then
            done = True
        Else
            i = i + 1
        End If
    Loop
    QuickFind = i
        
End Function

Private Function FilterOk(cmd As ConsoleEntry) As Boolean

    Dim ok As Boolean
    Dim orOk As Boolean
    Dim i As Integer

    orOk = False
    ok = True
    
    'Check name
    If chkFilterName.Value And InStr(1, LCase(cmd.Name), LCase(txtFilterName)) < 1 Then ok = False
    
    'Check text
    If chkFilterText.Value And InStr(1, LCase(cmd.Text), LCase(txtFilterText)) < 1 Then ok = False
    
    'Check type
    If chkFilterType.Value Then
        With lstFilterType
            For i = 0 To .ListCount - 1
                If .Selected(i) Then
                    If InStr(1, LCase(cmd.Type), LCase(.List(i))) > 0 Then orOk = True
                End If
            Next i
        End With
        ok = orOk
    End If

    'Return the result
    FilterOk = ok
    
End Function

Private Sub txtQuickFind_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay FLT_QUICKFIND

End Sub
