Attribute VB_Name = "mQuakeUtil"
'---------------------------------------------------------------------------
'Copyright 1997-1998 by Brian Kelly
'
'This program is free software; you can redistribute it and/or
'modify it under the terms of the GNU General Public License
'as published by the Free Software Foundation; either version 2
'of the License, or (at your option) any later version.
'
'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'See the GNU General Public License for more details.
'
'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'---------------------------------------------------------------------------
Option Explicit

Global Const PAK_HEADER = "PACK"
Global Const PAK_ERROR = "@@PAK_ERROR@@"
Global Const BSP_ERROR = "@@BSP_ERROR@@"

Const BSP_CHUNK_SIZE = 256

Public Enum BSPVersion
    bspInvalid = 0
    bspQuake = 1
    bspQuake2 = 2
End Enum

'This is the type for a directory entry in
'either a BSP file or a PAK file.  It's just
'the name of the file (for a PAK), plus a
'position and size discussions
Public Type dirEntry
    Name As String
    pos As Long
    size As Long
End Type

Public Type pakDir
    numFiles As Long
    dirStart As Long
    dirLength As Long
    directory() As dirEntry
End Type

'This function returns a pakFile (type declared in this module)
'You pass an open file stream (fPak).  You may also pass a filter
'This filter will be checked from the RIGHT side of the filename.
'For instance, to get all the BSPs from the PAK, just use ".bsp"
'as your filter
Public Function ListPak(fPak As Integer, Optional filter As String) As pakDir

    Dim p As pakDir
    Dim i As Long
    Dim calc As Long
    Dim s As String * 56
    Dim n As Long
    Dim numFiles As Long
    
    If Not (VerifyPak(fPak)) Then 'this is not a valid PAK file
        p.numFiles = 0
        ListPak = p
        Exit Function
    End If
    
    'get the location and size of the directory
    Get #fPak, 5, p.dirStart
    Get #fPak, 9, p.dirLength
    
    'how many files are there?
    n = Int(p.dirLength / 64)
    numFiles = 0
    
    'our pak directory must indicate the valid number of files
    ReDim p.directory(n) As dirEntry
    For i = 0 To (n - 1)
        calc = (i * 64) + 1
        Get #fPak, p.dirStart + calc, s
        p.directory(numFiles).Name = Left(s, InStr(1, s, Chr(0)) - 1)
        If ((filter <> "") And (Right(p.directory(numFiles).Name, Len(filter)) <> filter)) Then 'we have a filter to check
            'Do nothing... just move on...
        Else
            With p.directory(numFiles)
                Get #fPak, p.dirStart + calc + 56, .pos
                .pos = .pos + 1 'not sure why... but it works
                Get #fPak, p.dirStart + calc + 60, .size
            End With
            numFiles = numFiles + 1
        End If
    Next i
    
    ReDim Preserve p.directory(numFiles) As dirEntry
    p.numFiles = numFiles
       
    ListPak = p
    
End Function

'This function just checks to see if this is really a
'"PAK" file.  All it does is read the first four bytes
'and see if they spell the word "PACK"
Public Function VerifyPak(fPak As Integer) As Boolean

    Dim pakHeader As String * 4
    
    Get #fPak, 1, pakHeader
    
    If pakHeader = PAK_HEADER Then
        VerifyPak = True
    Else
        VerifyPak = False
    End If

End Function

Public Function BSPInfo(f As Integer, fName As String, Optional offSet As Long) As String

    Dim varString As String
    Dim j As Long
    Dim pos As Long
    Dim X As Long
    Dim Y As Long
    Dim bspName As String
    Dim prettyName As String
    Dim bspType As BSPVersion
    Dim entityOffset As Integer
    
    On Error GoTo Hell
    
    If offSet > 0 Then
        pos = offSet
    Else
        pos = 1
    End If
    
    'Make sure it's a valid BSP file
    bspType = VerifyBSP(f, pos)
    Select Case bspType
        Case bspInvalid:
            BSPInfo = BSP_ERROR
            Exit Function
        Case bspQuake:
            entityOffset = 4
        Case bspQuake2:
            entityOffset = 8
    End Select
    
    Get #f, pos + entityOffset, X
    Get #f, pos + entityOffset + 4, Y
    
    'Make sure this is a playable map
    varString = String(Y, " ")
    Get #f, pos + X, varString
    If InStr(1, varString, "info_player_start") = 0 Then
        BSPInfo = BSP_ERROR
        Exit Function
    End If
    
    'let's make the file name pretty
    bspName = TokStrip(fName, "/", tsLastTok, tsAfterTok)  'Get rid of any path
    bspName = TokStrip(bspName, ".", tsLastTok, tsBeforeTok)
    
    'If there's a name on this map, we'll find it!
    prettyName = ""
    j = InStr(1, varString, "message")
    If j <> 0 Then
        prettyName = Mid(varString, j + 10, Len(varString) - j)
        If InStr(1, prettyName, Chr(34)) = 0 Then
            prettyName = ""
        Else
            prettyName = Left(prettyName, InStr(1, prettyName, Chr(34)) - 1)
        End If
        If Len(prettyName) > 30 Then
            prettyName = Left(prettyName, 30) & "..."
        End If
    End If
    
    If prettyName = "" Then
        BSPInfo = bspName
    Else
        BSPInfo = LCase(bspName) & ": " & prettyName
    End If
    
    Exit Function
    
Hell:
    Select Case Err.Number
        Case Else:
            ReportError "crap", Err.Number, Err.Description, "<Trying to Read Map " & fName & ">"
    End Select
    
End Function

Public Function VerifyBSP(f As Integer, Optional offSet As Long) As BSPVersion

    Dim qVersion As String
    Dim q2Version As String
    Dim temp As String
    
    qVersion = Chr(29) & Chr(0) & Chr(0) & Chr(0)
    q2Version = "IBSP"
    temp = String(4, " ")
    
    If offSet > 0 Then
        Get #f, offSet, temp
    Else
        Get #f, 1, temp
    End If
    
    Select Case temp
        Case qVersion:
            VerifyBSP = bspQuake
        Case q2Version:
            VerifyBSP = bspQuake2
        Case Else:
            VerifyBSP = bspInvalid
    End Select

End Function

