Attribute VB_Name = "mPatchExplorer"
'---------------------------------------------------------------------------
'Copyright 1997-1998 by Brian Kelly
'
'This program is free software; you can redistribute it and/or
'modify it under the terms of the GNU General Public License
'as published by the Free Software Foundation; either version 2
'of the License, or (at your option) any later version.
'
'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'See the GNU General Public License for more details.
'
'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'---------------------------------------------------------------------------
Option Explicit

Public Const CREATE_NEW_FILE = "zippyfloo"

Public targetFile As String
Public patchName As String

Public Sub LaunchPatchExplorer(explorePatchName As String, Optional exploreFileName As String, Optional ErrorOnNotFound As Boolean = False)

    Dim tempPath As String
    
    On Error GoTo Hell
    
    tempPath = qSets(cqs).quakeDir
    tempPath = tempPath & "\" & explorePatchName
    
    If ErrorOnNotFound Then
        If Dir(tempPath & "\" & exploreFileName) = "" Then
            MsgBox "I'm sorry, I can't find that file.", vbInformation, AppName
            Exit Sub
        End If
    Else
        If Dir(tempPath & "\*.*") = "" Then
            MsgBox "Sorry... this directoy has nothing for me to explore.", vbInformation, AppName
            Exit Sub
        End If
    End If
    
    patchName = explorePatchName
    targetFile = exploreFileName
    fPatchInfo.Show 1
    
    Exit Sub

Hell:
    Select Case Err.Number
        Case Else:
            ReportError Err.Number, Err.Description, "<Launching Patch Explorer>"
    End Select

End Sub

