Attribute VB_Name = "mApplicationLayer"
'---------------------------------------------------------------------------
'Copyright 1997-1998 by Brian Kelly
'
'This program is free software; you can redistribute it and/or
'modify it under the terms of the GNU General Public License
'as published by the Free Software Foundation; either version 2
'of the License, or (at your option) any later version.
'
'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
'
'See the GNU General Public License for more details.
'
'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'---------------------------------------------------------------------------
'Here's the QuakeOn application layer
'This is where all the information that needs to be globally
'accessed by everyone resides.
Option Explicit

'**********************************
'** GLOBAL APPLICATION CONSTANTS **
'**********************************

Public Const AppName = "QuakeOn"         'NAME OF THE APPLICATION (MAKES GLOBAL CHANGES)
Public Const VERSION_TYPE = ""           'TYPE OF RELEASE
Public VERSION_INFO As String            'VERSION INFORMATION
Public CRLF As String                    'CARRIAGE-RETURN/LINE FEED

Public Const MAX_CBO_ITEMS = 10          'MAX NUMBER OF ITEMS IN QUAKE LOCATION COMBO BOX
Public Const SAVE_CURRENT = -1           'SAVE MAPS ON A MENU WHEN ADDING NEW MAPS TO MENU

'RUN ACTION CONSTANTS
Public Const RUN_NOTHING = 0
Public Const RUN_MINIMIZE = 1
Public Const RUN_EXIT = 2

'GOTTA KEEP TRACK OF THOSE DAMN FRAMES
Public Const FRAME_UB = 10  'upper bound of frames
Public frameMap(FRAME_UB) As Integer  'mapping
Public opFramesNames(FRAME_UB) As String

'PopupList Return Error Strings
Public Const MAP_NOT_FOUND = "~~MAP~NOT~FOUND~~"
Public Const DEMOS_NOT_FOUND = "~~DEMOS~NOT~FOUND~~"

'NAME OF TEMPORARY CFG FILES
Public Const TEMP_CFG_NAME = "~quakeon.tmp"
Public Const TEMP_MAP_NAME = "~qo_maps.tmp"
Public Const TEMP_DEM_NAME = "~qo_demo.tmp"
Public Const TEMP_BAT_NAME = "~quakeon.bat"

'Custom Option Types
Public Const OP_CFGFILE = 0
Public Const OP_CMDLINE = 1
Public Const OP_BATCHFILE = 2

'TRAY ICON DEFAULT
Public Const TRAY_ICON_DEFAULT = "**DEFAULT**"

Public Declare Function SetForegroundWindow Lib "user32" (ByVal hwnd As Long) As Long

'****************
'** DATA TYPES **
'****************

Public Type StringList
    topRec As Integer
    l() As String
End Type

'**********************
'** GLOBAL VARIABLES **
'**********************

'Now, let's have a funky-ass array of these QuakeSets
Public qSets() As QuakeSet

'Keep track of the current QuakeSet
Public cqs As Integer

'The map structure
Public qMaps() As PopupList

'The system tray
Public sysTray As Object

'Structure for keeping track of temporary files
Public junkList As StringList

'Useful paths
Public appPath As String
Public iniPath As String

'User Options
Public setsArrayCount As Integer    'Counter we need for the Popup Menu
Public trayIconPath As String       'Filename where the custom icon is
Public toolTipMessage As String     'The text that appears when you move over the tray icon
Public defaultQuakeSet As String    'QuakeSet last used
Public minimizeOnStartup As Boolean 'Do we minimize on startup
Public showCLPreview As Boolean     'Show command line preview
Public confirmDelete As Boolean     'confirm before deleting a quakeset
Public helpOn As Boolean
Public runAction As Integer
Public nukeStyle As Integer
Public diffEdit As Boolean          'use a different editor?
Public diffEditPath As String       'which editor?
Public commandLineCheck As Boolean  'Command Line Length Check?
Public baseQuakeSet As String       'what do we base new QuakeSets on?
Public validateMaps As Boolean      'Do we validate maps?
Public listMapsOn As Boolean        'Use "listmaps" feature?
Public listDemosOn As Boolean       'Use "listdemos" feature?
Public numServers As Integer        'Number of servers to track
Public trayDoubleClick As Integer   'what happens in double-click stylie
Public frameOrder As String         'Order of the frames...
Public lastFrame As Integer
Public userOps() As customOption    'Users custom option array
Public userOps_UB As Integer        '# items is custom ops array
Public benchFLAG As Boolean         'Are we benchmarking?

'Main Window Location
Public mainLeft As Long
Public mainTop As Long

'Helping Head Window Location
Public hhLeft As Long
Public hhTop As Long

'Command Line Preview Window Location
Public CLPTop As Long
Public CLPLeft As Long
Public CLPWidth As Long
Public CLPHeight As Long

'Patch Explorer Window Location
Public infoTop As Long
Public infoLeft As Long
Public infoWidth As Long
Public infoHeight As Long

'Some internal program variables
Public trayIconPresent As Boolean   'Is the tray icon loaded?
Public modalFormShowing As Boolean  'Are we showing a modal form right now?

'The command line that finally gets run when the
'"RUN QUAKE!" Button is pressed!
Public CommandLine As String
Public cfgFile As String
Public batFile As String

Public Sub Main()

    'CAN'T RUN IT TWICE!
'    If App.PrevInstance Then
'        MsgBox "I know you love " & AppName & ", but you may only run one copy at a time.", vbInformation, AppName
'        Exit Sub
'    End If
    
    'MsgBox "Font height = " & SystemFontHeight
    
    'INITIALIZE STUFF
    VERSION_INFO = "Version " & App.Major & "." & Format(App.Minor, "00") & " " & VERSION_TYPE
    CRLF = Chr(13) & Chr(10)
    
    'Bogus error for ReportError testing
    'ReportError 3421, "Bogus Error", "<Starting QuakeOn>"
    'End
    
    'Give them a decoy screen to occupy their time - Gregorious3
    fSplash.Show
    DoEvents    'Gives it time to display the window
    
    setsArrayCount = 1             'This is a counter for the PopupMenu
    modalFormShowing = False
    junkList.topRec = -1
    InitializeOpDefs
    appPath = App.path
    SetIniPath
    Set sysTray = New clsSysTray
    sysTray.OwnerControl = fMain.trayIcon
    
    'LET THE GAMES BEGIN!
    fMain.Show

End Sub

Public Sub CLPChange(CLPVisible As Boolean)

    fMain.muCLPShow.Checked = CLPVisible
    If CLPVisible Then
        fCLP.Show
        fMain.BuildCommandLine
    Else
        Unload fCLP
    End If

End Sub

'-----------
'ReportError
'-----------
'A more detailed error message box!
Public Sub ReportError(errorNumber As Long, errorDescription As String, Optional additionalText As String)

    Dim s As String
    Dim extra As String
    
    s = AppName & " Error:"
    s = s & Chr(13) & VERSION_INFO
    s = s & Chr(13) & "Number " & errorNumber
    s = s & Chr(13) & errorDescription
    If additionalText <> "" Then
        s = s & Chr(13) & additionalText
    End If
    
    LPrint App.path & "\error.log", "--------------------------------"
    LPrint App.path & "\error.log", Now
    LPrint App.path & "\error.log", ReplaceInstr(s, Chr(13), CRLF)
    LPrint App.path & "\error.log", "--------------------------------"
    
    extra = Chr(13) & Chr(13) & "For your bug reporting convenience, this"
    extra = extra & Chr(13) & "error message has been recorded in the ERROR.LOG"
    extra = extra & Chr(13) & "file which is located in your QuakeOn directory."
    
    MsgBox s & extra, vbExclamation, AppName
    
End Sub

Public Sub SetTrayIcon()

    On Error GoTo Hell

Try_This_Again:
    If trayIconPath = TRAY_ICON_DEFAULT Then
        Set fMain.trayIcon.Picture = fMain.defaultTrayIcon.Picture
    Else
        fMain.trayIcon.Picture = LoadPicture(trayIconPath)
    End If
    
    Exit Sub
    
Hell:
    Select Case Err.Number
        Case 53:  'File not found
            trayIconPath = TRAY_ICON_DEFAULT
            GoTo Try_This_Again
        Case 481:  'Invalid picture file
            trayIconPath = TRAY_ICON_DEFAULT
            GoTo Try_This_Again
        Case Else:
            ReportError Err.Number, Err.Description, "<Setting the Tray Icon>"
    End Select
    
End Sub

Public Function StripBSPName(mapName As String) As String

    Dim i As Integer
    
    i = InStr(1, mapName, ":")
    If i = 0 Then
        StripBSPName = mapName
    Else
        StripBSPName = Left(mapName, i - 1)
    End If

End Function

'One of the important higher level map reading functions.
'This function takes the path/filename of a PAK file and
'returns a popup list containing the names of the maps within
'that pakfile.  If there are no maps in that PAK file, this
'function returns an empty popup list with MAPS_NOT_FOUND
'as the name.
Public Function PakBSPsToPopupList(fName As String) As PopupList

    Dim i As Integer
    Dim j As Integer
    Dim fPak As Integer
    Dim temp As String
    Dim p As pakDir
    Dim ml As PopupList
    Dim errmsg As String

    On Error GoTo Trap
    
    'Let's open the PAK file
    fPak = FreeFile
    Open fName For Binary As fPak
    
        p = ListPak(fPak, ".bsp")
        
        j = -1
    
        If p.numFiles = 0 Then 'we have no maps in this pak file
            Close fPak
            ml.pName = MAP_NOT_FOUND
            PakBSPsToPopupList = ml
            Exit Function
        Else
            ReDim ml.pList(p.numFiles - 1) As String
        End If
    
        For i = 0 To (p.numFiles - 1)
            temp = BSPInfo(fPak, p.directory(i).Name, p.directory(i).pos)
            If temp <> BSP_ERROR Then
                j = j + 1
                ml.pList(j) = temp
            End If
        Next i
    
    Close fPak
    
    If j < 0 Then
        ml.pName = MAP_NOT_FOUND
        PakBSPsToPopupList = ml
        Exit Function
    Else
        ReDim Preserve ml.pList(j) As String
    End If
    
    PakBSPsToPopupList = ml
    
    Exit Function

Trap:
    Select Case Err.Number
        Case 70:
            errmsg = "The Pak File " & fName
            errmsg = errmsg & " is in use by another program right now."
            errmsg = errmsg & Chr(13) & "Maps and other info in this file will"
            errmsg = errmsg & " not be available to QuakeOn."
            MsgBox errmsg, vbExclamation, AppName
        Case 71, 76:  'Drive not ready or couldn't find PAK file
            'Do nothing
        Case Else:
            ReportError Err.Number, Err.Description, "<Getting Map Names from a Pak File>"
    End Select

    ml.pName = MAP_NOT_FOUND
    PakBSPsToPopupList = ml

End Function

'Another great higher-level map reading function
'This function returns the names of all playable Quake
'maps in a directory in a popup list
'Returns MAP_NOT_FOUND if no maps are there...
Public Function DirBSPsToPopupList(dirName As String) As PopupList
    
    Dim bspFile As Integer
    Dim j As Integer
    Dim temp As String
    Dim ml As PopupList
    Dim currentFile As String
    
    On Error GoTo Trap
    
    j = -1
    
    currentFile = Dir(dirName & "\*.bsp")
    
    Do Until currentFile = ""
        bspFile = FreeFile
        Open dirName & "\" & currentFile For Binary As bspFile
        temp = BSPInfo(bspFile, currentFile)
        If temp <> BSP_ERROR Then
            j = j + 1
            ReDim Preserve ml.pList(j) As String
            ml.pList(j) = temp
        End If
        Close bspFile
        currentFile = Dir
    Loop
    
    If j < 0 Then
        ml.pName = MAP_NOT_FOUND
        DirBSPsToPopupList = ml
        Exit Function
    End If
    
    DirBSPsToPopupList = ml
    
    Exit Function
    
Trap:
    Select Case Err.Number
        Case 52, 68, 71, 76:  'Invalid Device, Drive not ready, couldn't find directory
            ml.pName = MAP_NOT_FOUND
            DirBSPsToPopupList = ml
            Exit Function
        Case Else:
            ReportError Err.Number, Err.Description, "<Adding Maps to List>"
    End Select
    
End Function

Public Function DirPakBspsToPopupList(dirName As String) As PopupList

    Dim currentFile As String
    Dim returnList As PopupList
    Dim tempList As PopupList
    
    On Error GoTo Hell
    
    returnList.pName = MAP_NOT_FOUND
    currentFile = Dir(dirName & "\*.pak")
    
    Do Until currentFile = ""
        tempList = PakBSPsToPopupList(dirName & "\" & currentFile)
        If tempList.pName <> MAP_NOT_FOUND Then
            If returnList.pName <> MAP_NOT_FOUND Then
                returnList = ConcatPopupList(returnList, tempList)
            Else
                returnList = tempList
            End If
        End If
        currentFile = Dir
    Loop
    
    DirPakBspsToPopupList = returnList
    
    Exit Function
    
Hell:
    Select Case Err.Number
        Case 52, 68, 76:  'Bad file, drive stuff
           'Don't do anything... returning the empty list will
           'make the program flow just fine...
        Case Else:
            ReportError Err.Number, Err.Description, "<Getting Map Names from PAK Files>"
    End Select

    DirPakBspsToPopupList = returnList

End Function

'-----------------
'DefaultFrameOrder
'-----------------
'Returns a special string that defines the default frame order
Public Function DefaultFrameOrder() As String

    Dim temp As String
    
    temp = "100"
    temp = temp & "101"
    temp = temp & "106"
    temp = temp & "102"
    temp = temp & "103"
    temp = temp & "105"
    temp = temp & "107"
    temp = temp & "108"
    temp = temp & "104"
    temp = temp & "109"
    temp = temp & "110"
    
    DefaultFrameOrder = temp
    
End Function

Public Sub InitializeMissionPacks(cbo As ComboBox)
    
    cbo.AddItem "Normal Quake"
    cbo.AddItem "Scourge of Armagon"
    cbo.AddItem "Dissolution of Eternity"
    
End Sub

Public Sub InitializeMemoryTypes(cbo As ComboBox)

    cbo.AddItem "Normal"
    cbo.AddItem "Locked"
    cbo.AddItem "Lock/Unlock"

End Sub

Public Sub InitializeServerTypes(cbo As ComboBox)

    cbo.AddItem "No Server"
    cbo.AddItem "Listen"
    cbo.AddItem "Dedicated"

End Sub

Public Sub InitializeVidModes(cbo As ComboBox)

    cbo.AddItem "0: 320x200"
    cbo.AddItem "1: 320x200"
    cbo.AddItem "2: 360x200"
    cbo.AddItem "3: 320x240"
    cbo.AddItem "4: 360x240"
    cbo.AddItem "5: 320x350"
    cbo.AddItem "6: 360x350"
    cbo.AddItem "7: 320x400"
    cbo.AddItem "8: 360x400"
    cbo.AddItem "9: 320x480"
    cbo.AddItem "10: 360x480"
    
End Sub

Public Sub InitializeCustOpTypes(cbo As ComboBox)

    cbo.AddItem "Command Line"
    cbo.AddItem "Config File (Before Map)"
    cbo.AddItem "Config File (After Map)"
    cbo.AddItem "Batch File (Before Quake)"
    cbo.AddItem "Batch File (After Quake)"
    cbo.ListIndex = 0

End Sub

'We're now going to write an entire ini file.  Enjoy!
Public Sub SaveSettings()

    Dim fn As Integer
    Dim i As Integer
    Dim j As Integer
    Dim temp As String
    
    On Error GoTo Hell
    
    If fMain.WindowState <> 1 Then
        mainTop = fMain.Top
        mainLeft = fMain.Left
    End If
    
    fn = FreeFile
    Open iniPath For Output As fn
    
    '***********************************************
    'MAIN SECTION
    '***********************************************
    Print #fn, "[Main]"
    
    Print #fn, "QuakeSets=" & ListToDelString(fMain.lstQuakeSets, ",")
    Print #fn, "DefaultQuakeSet=" & defaultQuakeSet
    
    temp = ""
    For i = 0 To (fMain.cboQuakeLoc.ListCount - 1)
        temp = temp & fMain.cboQuakeLoc.List(i) & "*"
    Next i
    If temp <> "" Then Print #fn, "QuakeLocations=" & Left(temp, Len(temp) - 1)
    
    temp = ""
    For i = 0 To (fMain.cboServer.ListCount - 1)
        temp = temp & fMain.cboServer.List(i) & ","
    Next i
    If temp <> "" Then Print #fn, "RecentServers=" & Left(temp, Len(temp) - 1)
    
    Print #fn, "SysTray=" & BoolToString(trayIconPresent)
    Print #fn, "TrayIconPath=" & trayIconPath
    Print #fn, "TrayIconMouseOverText=" & toolTipMessage
    Print #fn, "MinimizeOnStartup=" & BoolToString(minimizeOnStartup)
    Print #fn, "HelpingHead=" & BoolToString(helpOn)
    Print #fn, "ShowCommandLinePreview=" & BoolToString(showCLPreview)
    Print #fn, "ConfirmQuakeSetDelete=" & BoolToString(confirmDelete)
    Print #fn, "DiffEditor=" & BoolToString(diffEdit)
    Print #fn, "DiffEditorPath=" & diffEditPath
    Print #fn, "CommandLineLengthCheck=" & BoolToString(commandLineCheck)
    Print #fn, "ValidateMaps=" & BoolToString(validateMaps)
    Print #fn, "ListMapsOn=" & BoolToString(listMapsOn)
    Print #fn, "ListDemosOn=" & BoolToString(listDemosOn)
    Print #fn, "MaxServers=" & numServers
    Print #fn, "TrayDoubleClick=" & trayDoubleClick
    Print #fn, "FrameOrder=" & frameOrder
    Print #fn, "NukeStyle=" & nukeStyle
    Print #fn, "RunAction=" & runAction
    Print #fn, "BaseQuakeSet=" & baseQuakeSet
    Print #fn, "LastFrame=" & lastFrame
    
    'Saved window positions
    Print #fn, "MainTop=" & mainTop
    Print #fn, "MainLeft=" & mainLeft
    Print #fn, "HeadTop=" & hhTop
    Print #fn, "HeadLeft=" & hhLeft
    Print #fn, "CLPTop=" & CLPTop
    Print #fn, "CLPLeft=" & CLPLeft
    Print #fn, "CLPHeight=" & CLPHeight
    Print #fn, "CLPWidth=" & CLPWidth
    Print #fn, "ExplorerTop=" & infoTop
    Print #fn, "ExplorerLeft=" & infoLeft
    Print #fn, "ExplorerHeight=" & infoHeight
    Print #fn, "ExplorerWidth=" & infoWidth
    
    'Save Custom Options - Gregorious2
    For i = 0 To userOps_UB
        Print #fn, ""
        With userOps(i)
            temp = .Name
            'Brackets in a name mess up ini file reads
            If InStr(temp, "[") Then temp = ReplaceInstr(temp, "[", "~(")
            If InStr(temp, "]") Then temp = ReplaceInstr(temp, "]", "~)")
        
            Print #fn, "[CustomOp " & temp & "]"
            Print #fn, "cmd=" & ReplaceInstr(.cmd, CRLF, "&&")
            Print #fn, "type=" & .Type
        End With
    Next i
    
    '***********************************************
    'QUAKE SETS
    '***********************************************
    For i = 0 To (fMain.lstQuakeSets.ListCount - 1)
        
        Print #fn, ""
        
        With qSets(i)
            'Prep Ini header - Gregorious3
            temp = .setName
            If InStr(temp, "[") Then temp = ReplaceInstr(temp, "[", "~(")
            If InStr(temp, "]") Then temp = ReplaceInstr(temp, "]", "~)")
        
            Print #fn, "[QuakeSet " & temp & "]"
            Print #fn, "QuakeDir=" & .quakeDir
            Print #fn, "QuakeApp=" & .quakeApp
            For j = 0 To OPS_UB
                Print #fn, opDefs(j) & "=" & .options(j)
            Next j
            For j = 0 To OPSX_UB
                Print #fn, opXDefs(j) & "=" & .optionsX(j)
            Next j
            For j = 0 To PLUS_OPS_UB
                Print #fn, plusOpDefs(j) & "=" & .plusOps(j)
            Next j
            For j = 0 To GL_OPS_UB
                Print #fn, glOpDefs(j) & "=" & .glOps(j)
            Next j
            Print #fn, "MouseLook=" & .mouseLook
            Print #fn, "MemoryType=" & .memOp
            Print #fn, "ServerType=" & .serverOp
            Print #fn, "MaxPlayers=" & .maxPlayers
            Print #fn, "FileOption=" & .fileOption
            Print #fn, "SavedGame=" & .savedGame
            Print #fn, "PlayDemo=" & .playDemo
            Print #fn, "RecordDemo=" & .recordDemo
            Print #fn, "AdditionalArguments=" & .additionalArguments
            Print #fn, "AdditionalCommands=" & ReplaceInstr(.additionalCommands, CRLF, "&&")
            Print #fn, "SelectedMap=" & .selectedMap
            Print #fn, "SelectedPatch=" & .selectedPatch
            Print #fn, "ConfigFiles=" & .cfgFiles
            Print #fn, "VidMode=" & .vidMode
            Print #fn, "MissionPackSupport=" & .hipSupport
            Print #fn, "ServerName=" & .serverName
            Print #fn, "ConnectToServer=" & .connectToServer
            Print #fn, "PlayerName=" & .playerName
            Print #fn, "SpecifyColors=" & BoolToString(.specifyColors)
            Print #fn, "ShirtColor=" & .shirtColor
            Print #fn, "PantsColor=" & .pantsColor
            Print #fn, "GLPlayerMip=" & .glPlayerMip
            Print #fn, "GLWidth=" & .glWidth
            Print #fn, "GLHeight=" & .glHeight
            Print #fn, "GLBPP=" & .glBPP
            Print #fn, "GLShadows=" & .glShadows
            Print #fn, "GLNoVis=" & .glNoVis
            Print #fn, "GLWaterAlpha=" & .glWaterAlpha
            Print #fn, "GLMirrorAlpha=" & .glMirrorAlpha
            Print #fn, "GLWindowed=" & .glWindowed
            Print #fn, "GLPolyblend=" & .glPolyblend
            Print #fn, "GLFlashblend=" & .glFlashblend
            Print #fn, "DefaultDataDirectory=" & .ddd
            Print #fn, "DeathmatchFlags=" & .dmflags
            'custom options - Gregorious2
            For j = 0 To userOps_UB
                If .userOps(j) Then Print #fn, userOps(j).Name & "=True"
            Next j
        End With
        
    Next i

    Close fn
    
    Exit Sub
    
Hell:
    ReportError Err.Number, Err.Description, "<Saving Settings>"

End Sub

Private Sub SetIniPath()

    Dim temp As String
    
    temp = CommandKeyValue("ini")
    
    If temp = "" Then
        iniPath = App.path & "\quakeon.ini"
    Else
        If LCase(Right(temp, 4)) <> ".ini" Then
            temp = temp & ".ini"
        End If
        If LCase(temp) = "qtray.ini" Then
            temp = "I'm sorry, but QTray.ini is reserved for QTray, who is my dear friend."
            temp = temp & Chr(13) & "I wouldn't dare overwrite his settings file."
            MsgBox temp, vbExclamation, AppName
            End
        End If
        iniPath = App.path & "\" & temp
    End If

End Sub

Public Sub InitializeGames(combo As ComboBox)

    combo.AddItem "Quake"
    combo.AddItem "Quake II"
    combo.AddItem "Hexen II"

End Sub

Public Sub InitializeDMFlags(l As listbox)

'#define DF_NO_HEALTH 1
'#define DF_NO_ITEMS 2
'#define DF_WEAPONS_STAY 4
'#define DF_NO_FALLING 8
'#define DF_INSTANT_ITEMS 16
'#define DF_SAME_LEVEL 32
'#define DF_SKINTEAMS 64
'#define DF_MODELTEAMS 128
'#define DF_FRIENDLY_FIRE 256
'#define DF_SPAWN_FARTHEST 512
'#define DF_FORCE_RESPAWN 1024
'#define DF_NO_ARMOR 2048

    With l
        .AddItem "No Health"
        .AddItem "No Items"
        .AddItem "Weapons Stay"
        .AddItem "No Falling"
        .AddItem "Instant Items"
        .AddItem "Same Level"
        .AddItem "Skin Teams"
        .AddItem "Model Teams"
        .AddItem "Friendly Fire"
        .AddItem "Spawn Farthest"
        .AddItem "Force Respawn"
        .AddItem "No Armor"
    End With

End Sub
