Attribute VB_Name = "mQuakeSets"
'---------------------------------------------------------------------------
'Copyright 1997-1998 by Brian Kelly
'
'This program is free software; you can redistribute it and/or
'modify it under the terms of the GNU General Public License
'as published by the Free Software Foundation; either version 2
'of the License, or (at your option) any later version.
'
'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'See the GNU General Public License for more details.
'
'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'---------------------------------------------------------------------------
'--------------
'mQuakeSets.bas
'--------------
'Generalize Code for dealing with QuakeSet specifics
Option Explicit

Public Const OPS_UB = 7         'NUMBER OF HIGHEST QUAKE OPTION CHECK BOX
Public Const OPSX_UB = 3        'NUMBER OF HIGHEST QUAKE OPTION CHECK BOX WITH A VALUE
Public Const PLUS_OPS_UB = 12    'NUMBER OF HIGHEST "+"-BASED OPTION (CONFIG FILE!!!)
Public Const GL_OPS_UB = 8      'NUMBER OF HIGHEST INDEPENDENT GL OPTION

Public Const qsNameEmpty = 0
Public Const qsNameComma = 1
Public Const qsNameDuplicate = 2
Public Const qsNameOkay = 3

'Gregorious2
Public Type customOption
    Name As String  'Alias name used in listbox
    cmd As String   'command text to execute
    Type As Integer 'type: config file, command line, etc...
End Type

'QUAKE OPTION ARRAY DEFINITIONS
Public opDefs(OPS_UB) As String
Public opXDefs(OPSX_UB) As String
Public plusOpDefs(PLUS_OPS_UB) As String
Public glOpDefs(GL_OPS_UB) As String

'QUAKESET DEFINITION
Public Type QuakeSet
    setName As String
    quakeDir As String
    quakeApp As String
    options(OPS_UB) As Integer
    optionsX(OPSX_UB) As Double
    plusOps(PLUS_OPS_UB) As Double
    glOps(GL_OPS_UB) As Double
    vidMode As String
    mouseLook As Integer
    memOp As Integer
    serverOp As Integer
    maxPlayers As Integer
    additionalArguments As String
    additionalCommands As String
    fileOption As Integer
    savedGame As String
    playDemo As String
    recordDemo As String
    selectedMap As String
    selectedPatch As String
    hipSupport As Integer  'mission pack: 0 = normal, 1 = hipnotic, 2 = rogue
    serverName As String
    playerName As String
    connectToServer As String
    specifyColors As Boolean
    shirtColor As String
    pantsColor As String
    cfgFiles As String
    glWidth As Integer
    glHeight As Integer
    glBPP As Integer
    glWaterAlpha As String
    glMirrorAlpha As String
    glNoVis As Integer
    glShadows As Integer
    glPlayerMip As Integer
    glWindowed As Integer
    glPolyblend As Integer
    glFlashblend As Integer
    ddd As String  'ddd = Default Data Directory
    dmflags As String
    userOps() As Boolean   'Gregorious2
End Type

Public Const QS_COPY = 0               'QUAKESET ARRAY COPY
Public Const QS_DELETE = 1             'QUAKESET ARRAY DELETE
Public Const QS_RENAME = 2             'QUAKESET ARRAY RENAME
Public Const QS_NEW = 3                'QUAKESET ARRAY NEW

'------------
'LoadQuakeSet
'------------
Public Function LoadQuakeSet(FilePath As String, quakeSetName As String, Optional ReturnBlank As Boolean) As QuakeSet

    Dim setHeader As String
    Dim i As Integer
    Dim qs As QuakeSet
    Dim iniSection As String
    Dim s As String
    
    On Error GoTo Hell
    
    'We need a Header for the ini file
    setHeader = "QuakeSet " & quakeSetName
    
    If ReturnBlank Then
        iniSection = ""
    Else
        iniSection = GetSection(FilePath, setHeader)
    End If
    
    With qs
        'First, the set name
        .setName = quakeSetName
        
        'Now, let's get the location
        .quakeDir = GetKey(iniSection, "QuakeDir", "c:\quake")
        
        'Now for the name of the app we'll be using
        .quakeApp = GetKey(iniSection, "QuakeApp", "quake")
        
        'Now for basic checked options
        For i = 0 To OPS_UB
            .options(i) = Val(GetKey(iniSection, opDefs(i), "0"))
        Next i
        
        'And yer non-basic checked options ("optionsX")
        For i = 0 To OPSX_UB
            .optionsX(i) = Val(GetKey(iniSection, opXDefs(i), "-1"))
        Next i
        
        'And yer additional commands
        For i = 0 To PLUS_OPS_UB
            .plusOps(i) = Val(GetKey(iniSection, plusOpDefs(i), "-1"))
        Next i
        
        'Additional GL Options
        For i = 0 To GL_OPS_UB
            .glOps(i) = Val(GetKey(iniSection, glOpDefs(i), "-1"))
        Next i
        
        'Do we have MLOOK on?
        .mouseLook = Val(GetKey(iniSection, "MouseLook", "0"))
        
        'MEMORY TYPE - shared, lock, lock/unlock
        .memOp = Val(GetKey(iniSection, "MemoryType", "0"))
        
        'SERVER TYPE - normal, listen, dedicated
        .serverOp = Val(GetKey(iniSection, "ServerType", "0"))
        
        'Max Number of Players
        .maxPlayers = Val(GetKey(iniSection, "MaxPlayers", "-1"))
        
        'The additional arguments...
        .additionalArguments = GetKey(iniSection, "AdditionalArguments", "")
        
        'The additional commands
        .additionalCommands = ReplaceInstr(GetKey(iniSection, "AdditionalCommands", ""), "&&", CRLF)
        
        'The majestic file options in their natural habitat
        .fileOption = Val(GetKey(iniSection, "FileOption", "0"))
        .savedGame = GetKey(iniSection, "SavedGame", "")
        .playDemo = GetKey(iniSection, "PlayDemo", "")
        .recordDemo = GetKey(iniSection, "RecordDemo", "")
        
        'The selected map
        .selectedMap = GetKey(iniSection, "SelectedMap", "")
        
        'The selected patch
        .selectedPatch = GetKey(iniSection, "SelectedPatch", "")
        
        .vidMode = GetKey(iniSection, "VidMode", "000")
        
        .hipSupport = Val(GetKey(iniSection, "MissionPackSupport", "0"))
        
        .serverName = GetKey(iniSection, "ServerName", "0QuakeOnServer")
        .connectToServer = GetKey(iniSection, "ConnectToServer", "0")
        .playerName = GetKey(iniSection, "PlayerName", "0QuakeOnUser")
        .specifyColors = StringToBool(GetKey(iniSection, "SpecifyColors", "false"))
        .shirtColor = GetKey(iniSection, "ShirtColor", "0")
        .pantsColor = GetKey(iniSection, "PantsColor", "0")
        .cfgFiles = GetKey(iniSection, "ConfigFiles", "")

        'GLQuake Options
        .glWidth = Val(GetKey(iniSection, "GLWidth", "640"))
        .glHeight = Val(GetKey(iniSection, "GLHeight", "480"))
        .glBPP = Val(GetKey(iniSection, "GLBPP", "-17"))
        .glMirrorAlpha = GetKey(iniSection, "GLMirrorAlpha", "n0.3")
        If Left(.glMirrorAlpha, 1) = "-" Then .glMirrorAlpha = "n0.3"
        .glWaterAlpha = GetKey(iniSection, "GLWaterAlpha", "n0.4")
        If Left(.glWaterAlpha, 1) = "-" Then .glWaterAlpha = "n0.4"
        .glShadows = Val(GetKey(iniSection, "GLShadows", "0"))
        .glNoVis = Val(GetKey(iniSection, "GLNoVis", "0"))
        .glPlayerMip = Val(GetKey(iniSection, "GLPlayerMip", "-3"))
        .glWindowed = Val(GetKey(iniSection, "GLWindowed", "0"))
        .glPolyblend = Val(GetKey(iniSection, "GLPolyblend", "0"))
        .glFlashblend = Val(GetKey(iniSection, "GLFlashblend", "0"))
        .ddd = GetKey(iniSection, "DefaultDataDirectory", "id1")
        .dmflags = GetKey(iniSection, "DeathmatchFlags", "00")
        
        'Custom options - Gregorious2
        If userOps_UB > -1 Then
            ReDim .userOps(userOps_UB) As Boolean
            For i = 0 To userOps_UB
                If GetKey(iniSection, userOps(i).Name, "False") = "True" Then
                    .userOps(i) = True
                Else
                    .userOps(i) = False
                End If
            Next i
        End If
        
    End With
    
    LoadQuakeSet = qs
    
    Exit Function

Hell:
    Select Case Err.Number
        Case Else:
            ReportError Err.Number, Err.Description, "<Loading " & setHeader & " from INI File>"
    End Select
    
End Function

'----------------
'InitializeOpDefs
'----------------
'Initializing the arrays that define option arrays
Public Sub InitializeOpDefs()

    opDefs(0) = "stdvid"
    opDefs(1) = "nosound"
    opDefs(2) = "nojoy"
    opDefs(3) = "nocdaudio"
    opDefs(4) = "nonet"
    opDefs(5) = "noudp"
    opDefs(6) = "noipx"
    opDefs(7) = "noserial"
    
    '------------------
    
    opXDefs(0) = "winmem"
    opXDefs(1) = "udpport"
    opXDefs(2) = "ipxport"
    opXDefs(3) = "heapsize"
    
    '------------------
    
    plusOpDefs(0) = "skill"
    plusOpDefs(1) = "deathmatch"
    plusOpDefs(2) = "teamplay"
    plusOpDefs(3) = "fraglimit"
    plusOpDefs(4) = "timelimit"
    plusOpDefs(5) = "noexit"
    plusOpDefs(6) = "m_filter"
    plusOpDefs(7) = "crosshair"
    plusOpDefs(8) = "hand"
    plusOpDefs(9) = "gl_mode"
    plusOpDefs(10) = "gun_x"
    plusOpDefs(11) = "gun_y"
    plusOpDefs(12) = "gun_z"
    
    '------------------
    
    glOpDefs(0) = "gl_affinemodels"
    glOpDefs(1) = "gl_cull"
    glOpDefs(2) = "gl_earlyswap"
    glOpDefs(3) = "gl_keepjunctions"
    glOpDefs(4) = "gl_keeptjunctions"
    glOpDefs(5) = "gl_nobind"
    glOpDefs(6) = "gl_reporttjunctions"
    glOpDefs(7) = "gl_smoothmodels"
    glOpDefs(8) = "gl_ztrick"
    
End Sub

'-----------------
'ValidQuakeSetName
'-----------------
'Check to see if we're getting a bogus name.
Public Function ValidQuakeSetName(candidateName As String, CompList As ListBox) As Integer
    
    Dim i As Integer
    
    'First, the empty name check...
    If candidateName = "" Then
        ValidQuakeSetName = qsNameEmpty
        Exit Function
    End If
    
    'Next we have the "is there a comma in the name" check
    If InStr(1, candidateName, ",") <> 0 Then
        ValidQuakeSetName = qsNameComma
        Exit Function
    End If
    
    'And finally, we don't want duplicate names!
    With CompList
        For i = 0 To (.ListCount - 1)
            If LCase(candidateName) = LCase(.List(i)) Then
                ValidQuakeSetName = qsNameDuplicate
                Exit Function
            End If
        Next i
    End With
    
    ValidQuakeSetName = qsNameOkay
    
End Function

'----------------
'LoadCustomOption
'----------------
'Load a custom option from an initialization file
Public Function LoadCustomOption(fileNumber As String, optionName As String) As customOption
    'gregorious2
    Dim iniSection As String
    Dim cop As customOption

    iniSection = GetSection(fileNumber, "CustomOp " & optionName)
    cop.Name = optionName
    cop.cmd = ReplaceInstr(GetKey(iniSection, "cmd"), "&&", CRLF)
    cop.Type = Val(GetKey(iniSection, "type"))
    
    LoadCustomOption = cop 'Return that pig
      
End Function
