VERSION 5.00
Begin VB.Form fMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "QuakeOn"
   ClientHeight    =   3435
   ClientLeft      =   150
   ClientTop       =   435
   ClientWidth     =   6135
   Icon            =   "fMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   3435
   ScaleWidth      =   6135
   StartUpPosition =   3  'Windows Default
   Begin VB.ListBox lstTemp 
      Height          =   840
      Left            =   360
      TabIndex        =   5
      Top             =   2520
      Width           =   1815
   End
   Begin VB.ListBox lstCustom 
      Height          =   840
      Left            =   2280
      TabIndex        =   4
      Top             =   2520
      Width           =   1815
   End
   Begin VB.ListBox lstQuakeSets 
      Height          =   840
      Left            =   4200
      TabIndex        =   3
      Top             =   2520
      Width           =   1815
   End
   Begin VB.PictureBox trayIcon 
      BorderStyle     =   0  'None
      Height          =   495
      Left            =   120
      ScaleHeight     =   495
      ScaleWidth      =   495
      TabIndex        =   2
      Top             =   1200
      Visible         =   0   'False
      Width           =   495
   End
   Begin VB.DirListBox Dir1 
      Height          =   990
      Left            =   120
      TabIndex        =   1
      Top             =   120
      Visible         =   0   'False
      Width           =   1335
   End
   Begin VB.FileListBox File2 
      Height          =   870
      Left            =   1560
      TabIndex        =   0
      Top             =   120
      Visible         =   0   'False
      Width           =   1695
   End
   Begin VB.Image busyIcon 
      Height          =   240
      Left            =   1440
      Picture         =   "fMain.frx":030A
      Top             =   1200
      Width           =   240
   End
   Begin VB.Image defaultTrayIcon 
      Height          =   240
      Left            =   720
      Picture         =   "fMain.frx":0454
      Top             =   1200
      Width           =   240
   End
   Begin VB.Menu muTray 
      Caption         =   "Tray"
      Visible         =   0   'False
      Begin VB.Menu muSetsArray 
         Caption         =   "SetsArray1"
         Index           =   0
      End
      Begin VB.Menu muSep1 
         Caption         =   "-"
      End
      Begin VB.Menu muShortcuts 
         Caption         =   "Shortcuts"
         Begin VB.Menu muShortcutArray 
            Caption         =   "Empty"
            Enabled         =   0   'False
            Index           =   0
         End
         Begin VB.Menu muSepShortcutsMenu 
            Caption         =   "-"
         End
         Begin VB.Menu muExploreShortcutsFolder 
            Caption         =   "Shortcuts Folder..."
         End
      End
      Begin VB.Menu muSepShortcut 
         Caption         =   "-"
      End
      Begin VB.Menu muSettingsFile 
         Caption         =   "Settings File"
         Begin VB.Menu muFileArray 
            Caption         =   "muFileArray"
            Index           =   0
         End
      End
      Begin VB.Menu muOptions 
         Caption         =   "Options"
         Begin VB.Menu muListDemos 
            Caption         =   "Disable ""listdemos"""
            Index           =   0
         End
         Begin VB.Menu muListDemos 
            Caption         =   "Use ""listdemos"""
            Index           =   1
         End
         Begin VB.Menu muListDemos 
            Caption         =   "Thread ""listdemos"""
            Index           =   2
         End
         Begin VB.Menu muSepListDemos 
            Caption         =   "-"
         End
         Begin VB.Menu muListMaps 
            Caption         =   "Disable ""listmaps"""
            Index           =   0
         End
         Begin VB.Menu muListMaps 
            Caption         =   "Use ""listmaps"""
            Index           =   1
         End
         Begin VB.Menu muListMaps 
            Caption         =   "Thread ""listmaps"""
            Index           =   2
         End
         Begin VB.Menu muSepListMaps 
            Caption         =   "-"
         End
         Begin VB.Menu muDoubleClick 
            Caption         =   "Double-Click Launches QuakeOn"
            Index           =   0
         End
         Begin VB.Menu muDoubleClick 
            Caption         =   "Double-Click Runs Quake"
            Index           =   1
         End
         Begin VB.Menu muSepDoubleClick 
            Caption         =   "-"
         End
         Begin VB.Menu muAbout 
            Caption         =   "About QTray"
         End
      End
      Begin VB.Menu muShow 
         Caption         =   "Show QStarter"
      End
      Begin VB.Menu muRefresh 
         Caption         =   "Refresh Menu"
      End
      Begin VB.Menu muExit 
         Caption         =   "Exit QStarter"
      End
   End
End
Attribute VB_Name = "fMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'---------------------------------------------------------------------------
'Copyright 1997-1998 by Brian Kelly
'
'This program is free software; you can redistribute it and/or
'modify it under the terms of the GNU General Public License
'as published by the Free Software Foundation; either version 2
'of the License, or (at your option) any later version.
'
'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'See the GNU General Public License for more details.
'
'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'---------------------------------------------------------------------------
'Here's the main form.  Here's where all the action happens.
'Here's where all tough-ass code is.
'This is where the real men come to play.
Option Explicit

Dim overrideMap As String

Dim commandLining As Boolean

Dim shortcuts As shellMenu

Private Sub Form_Load()

    Dim X As Menu
    
    muShow.Caption = "Launch QuakeOn"
    muExit.Caption = "Exit QTray"
    
    'Load data from the ini file
    LoadMyIniData
    If iniPath = INI_PATH_NOT_SET Then iniPath = App.Path & "\" & lastIniFile
    LoadINIData
    
    UpdatePopupMenu
    InitializeFileMenu
    
    'if this weirdo ran QuakeOn with command line options,
    'we'd better respond properly.
    If Command <> "" Then HandleCommandLineOptions
    
    LoadShortcutMenu
    
    SetTrayIcon
    
    UpdateMenus
    
    AddSystemTrayIcon trayIcon, toolTipMessage
    
    cqs = FindInList(lstQuakeSets, defaultQuakeSet)

    If cqs = -1 Then cqs = 0
    
    Me.Hide
    
End Sub

Public Sub BuildCommandLine()

    Dim i As Integer
    Dim j As Integer
    Dim okay As Boolean
    Dim str1, str2, str3, str4, str5 As String
    Dim patch As String

    '*****************
    '** CONFIG FILE **
    '*****************

    cfgFile = ""
    batFile = ""

    With qs

    patch = .selectedPatch

    'Build custom option strings first, then add to the
    'right place later
    For i = 0 To userOps_UB
        If .userOps(i) Then
            Select Case userOps(i).Type
                Case 0:  'command line
                    str1 = str1 & " " & ReplaceInstr(ReplaceInstr(userOps(i).cmd, CRLF, " "), "%patch%", patch)
                Case 1:  'config file (before map)
                    str2 = str2 & ReplaceInstr(userOps(i).cmd, "%patch%", patch) & CRLF
                Case 2:  'config file (after map)
                    str3 = str3 & ReplaceInstr(userOps(i).cmd, "%patch%", patch) & CRLF
                Case 3:  'batch file (before Quake)
                    str4 = str4 & ReplaceInstr(userOps(i).cmd, "%patch%", patch) & CRLF
                Case 4:
                    str5 = str5 & ReplaceInstr(userOps(i).cmd, "%patch%", patch) & CRLF
            End Select
        End If
    Next i

    lstTemp.Clear
    ParseVals .cfgFiles, "*", lstTemp
    j = lstTemp.ListCount
    If j > 0 Then
        For i = 0 To j - 1
            cfgFile = cfgFile & "exec " & LCase(lstTemp.List(i)) & CRLF
        Next i
    End If

    For i = 0 To PLUS_OPS_UB
        If .plusOps(i) >= 0 Then
            cfgFile = cfgFile & plusOpDefs(i) & " " & .plusOps(i) & CRLF
        End If
    Next i

    If Left(.vidMode, 1) = "1" Then
        cfgFile = cfgFile & "vid_mode " & Format(Val(Right(.vidMode, 2)), "0") & CRLF
    End If
    
    If .mouseLook = 1 Then
        cfgFile = cfgFile & "+mlook" & CRLF
    End If

    If .additionalCommands <> "" Then
        cfgFile = cfgFile & .additionalCommands & CRLF
    End If

    If Left(.serverName, 1) = "1" Then
        cfgFile = cfgFile & "hostname " & Right(.serverName, Len(.serverName) - 1) & CRLF
    End If

    If Left(.playerName, 1) = "1" Then
        cfgFile = cfgFile & "name " & Right(.playerName, Len(.playerName) - 1) & CRLF
    End If

    If .specifyColors Then
        cfgFile = cfgFile & "color " & .shirtColor & " " & .pantsColor & CRLF
    End If

    If .glPlayerMip >= 0 Then
        cfgFile = cfgFile & "gl_playermip " & Chr(34) & .glPlayerMip & Chr(34) & CRLF
    End If

    If .glNoVis = 1 Then
        cfgFile = cfgFile & "r_novis 1" & CRLF
    End If

    If .glShadows = 1 Then
        cfgFile = cfgFile & "r_shadows 1" & CRLF
    End If

    If Left(.glWaterAlpha, 1) <> "n" Then
        cfgFile = cfgFile & "r_wateralpha " & .glWaterAlpha & CRLF
    End If

    If Left(.glMirrorAlpha, 1) <> "n" Then
        cfgFile = cfgFile & "r_mirroralpha " & .glMirrorAlpha & CRLF
    End If

    If .glFlashblend = 1 Then
        cfgFile = cfgFile & "gl_flashblend 0" & CRLF
    End If

    If .glPolyblend = 1 Then
        cfgFile = cfgFile & "gl_polyblend 0" & CRLF
    End If

    If .glWindowed = 1 Then
        If .ddd = "baseq2" Then
            cfgFile = cfgFile & "vid_fullscreen 1" & vbCrLf
        Else
            cfgFile = cfgFile & "_windowed_mouse 1" & CRLF
        End If
    End If

    For i = 0 To GL_OPS_UB
        If .glOps(i) >= 0 Then
            cfgFile = cfgFile & glOpDefs(i) & " " & .glOps(i) & CRLF
        End If
    Next i

    If Left(.dmflags, 1) = "1" Then
        cfgFile = cfgFile & "dmflags " & Right(.dmflags, Len(.dmflags) - 1) & vbCrLf
    End If

    cfgFile = cfgFile & str2

    If Left(.connectToServer, 1) = "1" Then
        cfgFile = cfgFile & "connect " & Right(.connectToServer, Len(.connectToServer) - 1) & CRLF
    Else
        'They're not connecting... what else could they be up to?
        If (.fileOption = 1) And (.savedGame <> "") Then
            cfgFile = cfgFile & "load " & .savedGame & CRLF
        Else
            If (.fileOption = 2) And (.playDemo <> "") Then
                cfgFile = cfgFile & "playdemo " & .playDemo & CRLF
            Else
                If (.fileOption = 3) And (.recordDemo <> "") Then
                    cfgFile = cfgFile & "record " & .recordDemo & " " & .selectedMap & CRLF
                    'SKILL HACK
                    If (.selectedMap <> "") And (.plusOps(0) >= 0) Then
                        cfgFile = cfgFile & "skill " & .plusOps(0) & CRLF
                    End If
                Else
                    If .selectedMap <> "" Then
                        If overrideMap = "" Then
                            cfgFile = cfgFile & "map " & .selectedMap & CRLF
                        Else
                            cfgFile = cfgFile & "map " & overrideMap & CRLF
                        End If
                        'Bri's special SKILL HACK!!!
                        If .plusOps(0) >= 0 Then
                            cfgFile = cfgFile & "skill " & .plusOps(0) & CRLF
                        End If
                    End If
                End If
            End If
        End If

    End If

    'Add custom options for config file - Gregorious2
    cfgFile = cfgFile & str3

    '******************
    '** COMMAND LINE **
    '******************

    okay = False

    commandLine = .quakeApp

    Select Case .hipSupport
        Case 1:
            commandLine = commandLine & " -hipnotic"
        Case 2:
            commandLine = commandLine & " -rogue"
    End Select

    If .selectedPatch <> "" Then
        If .ddd = "baseq2" Then
            commandLine = commandLine & " +set game " & LCase(.selectedPatch)
        Else
            commandLine = commandLine & " -game " & LCase(.selectedPatch)
        End If
    End If

    If .glWindowed = 1 Then
        commandLine = commandLine & " -window"
    End If

    If .glBPP >= 0 Then
        commandLine = commandLine & " -width " & .glWidth
        commandLine = commandLine & " -height " & .glHeight
        commandLine = commandLine & " -bpp " & .glBPP
    End If

    For i = 0 To OPS_UB
        If .options(i) = 1 Then
            Select Case i
                Case 5:
                    If .options(4) = 0 Then okay = True
                Case 6:
                    If .options(4) = 0 Then okay = True
                Case 7:
                    If .options(4) = 0 Then okay = True
                Case Else:
                    okay = True
            End Select
            If okay Then
                commandLine = commandLine & " -" & opDefs(i)
                okay = False
            End If
        End If
    Next i

    For i = 0 To OPSX_UB
        If .optionsX(i) >= 0 Then
            If i = 0 Then
                commandLine = commandLine & " -" & opXDefs(i) & " " & .optionsX(i)
                If .memOp = 1 Then
                    commandLine = commandLine & " -winlock"
                Else
                    If .memOp = 2 Then
                        commandLine = commandLine & " -winlockunlock"
                    End If
                End If
            Else
                Select Case i
                    Case 1:
                        If (.options(4) = 0) And (.options(5) = 0) Then okay = True
                    Case 2:
                        If (.options(4) = 0) And (.options(6) = 0) Then okay = True
                    Case Else:
                        okay = True
                End Select
                If okay Then
                    commandLine = commandLine & " -" & opXDefs(i) & " " & .optionsX(i)
                    okay = False
                End If
            End If
        End If
    Next i

    Select Case .serverOp
        Case 1:
            commandLine = commandLine & " -listen"
        Case 2:
            commandLine = commandLine & " -dedicated"
    End Select

    If .serverOp > 0 Then
        If .maxPlayers >= 0 Then
            commandLine = commandLine & " " & .maxPlayers
        End If
    End If

    'Add custom options command line - Gregorious2
    commandLine = commandLine & " " & str1

    If .additionalArguments <> "" Then
        commandLine = commandLine & " " & .additionalArguments
    End If

    If cfgFile <> "" Then
        commandLine = commandLine & " +exec " & TEMP_CFG_NAME
    End If

    '****************
    '** BATCH FILE **
    '****************

    If (str4 <> "") Or (str5 <> "") Then
        batFile = str4 & commandLine & CRLF & str5
    End If
    
    End With
    
End Sub

Private Sub Form_Unload(Cancel As Integer)

    Dim i As Integer
    
    On Error GoTo Hell
    
    SaveSettings
    
    RemoveSystemTrayIcon
    
    On Error Resume Next
    
    'Let us now destroy any temporary files we created!
    For i = 0 To junkList.topRec
        Kill junkList.l(i)
    Next i
    
    Exit Sub
    
Hell:
    Select Case Err.Number
        Case Else:
            ReportError Err.Number, Err.Description, "<No thanks, I'm trying to quit...>"
    End Select

End Sub

Private Sub muAbout_Click()

    Dim temp As String
    
    temp = "QTray - QuakeOn's Little Friend"
    temp = temp & Chr(13) & VERSION_INFO
    temp = temp & Chr(13) & "by Brian Kelly (fragbert@planetquake.com)"
    temp = temp & Chr(13) & "http://www.planetquake.com/quakeon"
    
    MsgBox temp, vbInformation, "QTray!"

End Sub

Private Sub muDoubleClick_Click(Index As Integer)

    trayDoubleClick = Index
    UpdateMenus

End Sub

Private Sub muExit_Click()

    Unload Me

End Sub

Private Sub muExploreShortcutsFolder_Click()
    
    Dim result As Long
    
    result = Shell("explorer " & appPath & "\Shortcuts", vbNormalFocus)

End Sub

Private Sub muFileArray_Click(Index As Integer)

    lastIniFile = muFileArray(Index).Caption & ".ini"
    iniPath = App.Path & "\" & lastIniFile
    LoadINIData
    muRefresh_Click
    InitializeFileMenu

End Sub

Private Sub muListDemos_Click(Index As Integer)

    listDemosOn = Index
    UpdateMenus

End Sub

Private Sub muListMaps_Click(Index As Integer)

    listMapsOn = Index
    UpdateMenus

End Sub

Private Sub muRefresh_Click()

    sysTray.Icon = busyIcon.Picture

    lstQuakeSets.Clear
    SaveSettings
    lstCustom.Clear
    LoadINIData
    UpdatePopupMenu
    LoadShortcutMenu
    
    cqs = FindInList(lstQuakeSets, defaultQuakeSet)
    If cqs = -1 Then cqs = 0

    sysTray.Icon = trayIcon.Picture

End Sub

Private Sub muSetsArray_Click(Index As Integer)

    cqs = Index
    defaultQuakeSet = muSetsArray(cqs).Caption
    RunQuake
  
End Sub

Private Sub muShortcutArray_Click(Index As Integer)

    Dim temp As String
    
    temp = "start " & Chr(34) & shortcuts.Menu(Index).FileName & Chr(34)
    
    Shell temp, vbHide

End Sub

Private Sub muShow_Click()

    Dim i As Integer
    Dim temp As String
    
    If Dir(App.Path & "\quakeon.exe") = "" Then
        MsgBox "QuakeOn must be in the same directory as QTray.", vbInformation, AppName
    Else
        If muSettingsFile.Visible Then
            For i = 0 To muFileArray.UBound
                If muFileArray(i).Checked Then temp = muFileArray(i).Caption
            Next i
            Shell App.Path & "\QuakeOn.exe -ini " & temp, vbNormalFocus
        Else
            Shell App.Path & "\QuakeOn.exe", vbNormalFocus
        End If
    End If

End Sub

Private Sub trayIcon_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    Select Case Hex(X)
        Case trayLeftButtonDoubleClick, trayLeftButtonDoubleClick_LargeFonts:
            If trayDoubleClick = 0 Then
                muShow_Click
            Else
                RunQuake
            End If
        'commented out by me 'cause it sucks...
'        Case trayRightButtonDoubleClick
'            If trayDoubleClick = 0 Then
'                RunQuake
'            Else
'                muShow_Click
'            End If
        Case trayRightButtonDown, trayRightButtonDown_LargeFonts:
            SetForegroundWindow Me.hwnd
            If trayDoubleClick = 0 Then
                fMain.PopupMenu fMain.muTray, , , , muShow
            Else
                fMain.PopupMenu fMain.muTray, , , , muSetsArray(cqs)
            End If
    End Select

End Sub

Public Sub UpdatePopupMenu()

    Dim i As Integer
    Dim done As Boolean

    'I'd like to remove all the menu items and then
    'start over from scratch
    For i = 1 To (setsArrayCount - 1)
        Unload fMain.muSetsArray(i)
    Next i
    
    i = 0
    done = False
    Do Until done
        muSetsArray(i).Caption = lstQuakeSets.List(i)
        i = i + 1
        If i = lstQuakeSets.ListCount Then
            done = True
        Else
            'Create a new menu item
            Load fMain!muSetsArray(i)
        End If
    Loop
    
    setsArrayCount = i

End Sub

Private Sub MakeNewINIFile()

    Dim fn As Integer
    Dim j As Integer
    
    fn = FreeFile
    
    Open myIniPath For Output As fn
    
    Print #fn, "[Main]"
    Print #fn, "ListDemos=0"
    Print #fn, "ListMaps=0"
    
    Close fn

End Sub

Public Sub HandleCommandLineOptions()
        
    Dim qsName As String  'the quakeset on the command line
    Dim map As String 'the map name on the command line
    Dim i As Integer
    
    overrideMap = ""
    
    commandLining = False
    
    qsName = CommandKeyValue("qs")
    
    map = CommandKeyValue("map")
    
    If qsName <> "" Then
        lstQuakeSets.ListIndex = FindInList(lstQuakeSets, qsName)
        If lstQuakeSets.ListIndex >= 0 Then
            If map <> "" Then overrideMap = map
            defaultQuakeSet = qsName
            commandLining = True
            RunQuake
            End
        Else
            MsgBox "QuakeSet Specified in Command Line Argument could not be found", vbInformation, AppName
        End If
    End If
    
End Sub

Private Sub LoadShortcutMenu()

    Dim i As Integer
    
    If shortcuts.NumItems > 0 Then
        For i = 1 To (shortcuts.NumItems - 1)
            Unload muShortcutArray(i)
        Next i
    End If
    
    shortcuts = DirToMenu(App.Path & "\Shortcuts")

    If shortcuts.NumItems > 0 Then
        muShortcutArray(0).Caption = shortcuts.Menu(0).Caption
        muSepShortcut.Visible = True
        muShortcutArray(0).Enabled = True
        muShortcuts.Visible = True
        For i = 1 To (shortcuts.NumItems - 1)
            Load fMain!muShortcutArray(i)
            muShortcutArray(i).Caption = shortcuts.Menu(i).Caption
        Next i
    Else
        muShortcuts.Visible = False
        muSepShortcut.Visible = False
    End If

End Sub

'-----------
'LoanINIData
'-----------
'Loads all of QuakeOn's initialization data from the QuakeOn.ini file...
Public Sub LoadINIData()

    Dim i As Integer
    Dim iniSection As String
    Dim temp As String
    
    On Error GoTo Hell

    If Dir(iniPath) = "" Then
        temp = "You need to run QuakeOn and set up some"
        temp = temp & Chr(13) & "QuakeSets before you use QTray."
        MsgBox temp, vbInformation, AppName
        End
    End If

    'Read in the entire Main ini section
    iniSection = GetSection(iniPath, "Main")
    
    'LIST OF QUAKESET NAMES
    ParseVals GetKey(iniSection, "QuakeSets", "Default"), ",", lstQuakeSets
    
    'SYSTEM TRAY ICON PATH
    trayIconPath = GetKey(iniSection, "TrayIconPath", TRAY_ICON_DEFAULT)
    
    'SYSTEM TRAY ICON TOOL TIP TEXT
    toolTipMessage = GetKey(iniSection, "TrayIconMouseOverText", "Let's Play Quake!")
    
    'CHECK THE LENGTH OF THE COMMAND LINE
    commandLineCheck = StringToBool(GetKey(iniSection, "CommandLineLengthCheck", "true"))
    
    'LOAD CUSTOM OPTIONS - Gregorious2
    temp = GetIniHeaders(iniPath, ",", "CustomOp")

    If temp <> "" Then
        ParseVals temp, ",", lstCustom
        userOps_UB = lstCustom.ListCount - 1
        ReDim userOps(userOps_UB) As customOption
        For i = 0 To (lstCustom.ListCount - 1)
            userOps(i) = LoadCustomOption(iniPath, lstCustom.List(i))
        Next
        lstCustom.ListIndex = 0
    Else
        userOps_UB = -1
    End If
    
    Exit Sub

Hell:
    Select Case Err.Number
        Case Else:
            ReportError Err.Number, Err.Description, "<<Loading data from QuakeOn.ini file>>"
    End Select

End Sub

Public Sub RunQuake()

    Dim result As Double
    Dim cfgPath As String
    Dim mapPath As String
    Dim demoPath As String
    Dim batPath As String
    Dim temp As String
    Dim fn As Integer
    Dim fn2 As Integer
    Dim i As Integer
    Dim j As Integer
    Dim tempList As PopupList
    Dim demoCount As Integer
    Dim mapCount As Integer
    Dim hack As Boolean
    Dim tempDir As String
    
    On Error GoTo Hell
    
    hack = False
    
    sysTray.Icon = busyIcon.Picture
    
    If Not commandLining Then defaultQuakeSet = muSetsArray(cqs).Caption
    
    SaveSettings
    
    'Load the QuakeSet we care about
    qs = LoadQuakeSet(iniPath, defaultQuakeSet)
    
    If qs.setName <> defaultQuakeSet Then
        tempDir = "I'm sorry, but you must have removed that QuakeSet from QuakeOn."
        tempDir = tempDir & Chr(13) & "I have refreshed the menu to avoid further confusion."
        MsgBox tempDir, vbInformation, "QTray"
        muRefresh_Click
        Exit Sub
    End If
    
    'Make the command line all it should be
    BuildCommandLine
        
    'Change the system path
    With qs
        ChDrive Mid(.quakeDir, 1, 2)
        ChDir .quakeDir
        If .selectedPatch = "" Then
            cfgPath = .quakeDir & "\" & .ddd & "\" & TEMP_CFG_NAME
            mapPath = .quakeDir & "\" & .ddd & "\" & TEMP_MAP_NAME
            demoPath = .quakeDir & "\" & .ddd & "\" & TEMP_DEM_NAME
        Else
            cfgPath = .quakeDir & "\" & .selectedPatch & "\" & TEMP_CFG_NAME
            mapPath = .quakeDir & "\" & .selectedPatch & "\" & TEMP_MAP_NAME
            demoPath = .quakeDir & "\" & .selectedPatch & "\" & TEMP_DEM_NAME
        End If
        If batFile <> "" Then
            batPath = .quakeDir & "\" & TEMP_BAT_NAME
        End If
    End With
    
    tempDir = TokStrip(cfgPath, "\", tsLastTok, tsBeforeTok)
    
    If Dir(tempDir & "\*.*") = "" Then
        hack = True
        GoTo HACK_O_LICIOUS
    End If
    
    'Write the temporary config file
    fn = FreeFile
    Open cfgPath For Output As fn
    
    Print #fn, cfgFile
    
    Print #fn, "echo **"
    Print #fn, "echo ** QuakeSet " & qs.setName
    Print #fn, "echo ** QTray " & VERSION_INFO
    
    If listDemosOn > 0 Then
        Print #fn, "echo **"
        Print #fn, "echo ** Type listdemos to list demos"
        Print #fn, "alias listdemos " & Chr(34) & "exec " & TEMP_DEM_NAME & Chr(34)
        If listDemosOn = 1 Then DoDaDemos demoPath
    End If
    
    If listMapsOn > 0 Then
        Print #fn, "echo **"
        Print #fn, "echo ** Type listmaps to list maps"
        Print #fn, "alias listmaps " & Chr(34) & "exec " & TEMP_MAP_NAME & Chr(34)
        If listMapsOn = 1 Then DoDaMaps mapPath
    End If

    Print #fn, "echo **"
    
    Close fn
    
HACK_O_LICIOUS:
    
    If batFile <> "" Then
        fn = FreeFile
        Open batPath For Output As fn
        Print #fn, batFile
        Close fn
        commandLine = TEMP_BAT_NAME
    End If
    
    'Add this file to the list of files we're gonna gib when we exit
    AddToJunkList cfgPath
    AddToJunkList mapPath
    AddToJunkList demoPath
    AddToJunkList batPath
        
    If commandLineCheck And (Len(commandLine) > 127) Then
        MsgBox "On certain computers, certain versions of Quake will not function properly if the command line is too long.  Your command line may be too long.  You may disable this message in the settings window.", vbInformation, AppName
    End If
    
    result = Shell(commandLine, vbNormalFocus)
    
    'I'm runnin' the demo and map list making files AFTER
    'Quake is launched to try to be a suave multi-threaded p1mp...
    
    If Not hack Then
        If listDemosOn = 2 Then DoDaDemos demoPath
        If listMapsOn = 2 Then DoDaMaps mapPath
    End If
    
    sysTray.Icon = trayIcon.Picture
    
    Exit Sub
    
Hell:
    Select Case Err.Number
        Case 68:
            MsgBox "Sorry Dude, that drive's unavailable.", vbInformation, AppName
        Case 53:
            MsgBox "Sorry Dude, there's somethin' wrong with your executable name.", vbInformation, AppName
        Case 76: 'Path not found
            MsgBox "Sorry Dude, that's not a valid directory.", vbInformation, AppName
        Case Else:
            ReportError Err.Number, Err.Description, "<Trying to run Quake>"
    End Select
    
End Sub

Public Sub AddToJunkList(PieceOfTrash As String)

    With junkList
        .topRec = .topRec + 1
        ReDim Preserve .l(.topRec) As String
        junkList.l(.topRec) = PieceOfTrash
    End With

End Sub

Private Function listDemos(patchDir As String) As PopupList

    Dim tempList As PopupList
    Dim i As Integer
    Dim j As Integer
    Dim pakList As pakDir
    Dim fn As Integer
    Dim temp As String
    Dim numFiles As Integer
    
    On Error GoTo Hell
    
    numFiles = 0
    
    'let's get a list of demos
    File2.Path = patchDir
    File2.Pattern = "*.pak"
    File2.Refresh
    If File2.ListCount <> 0 Then
        For i = 0 To File2.ListCount - 1
            fn = FreeFile
            Open File2.Path & "\" & File2.List(i) For Binary As fn
            pakList = ListPak(fn, ".dem")
            Close fn
            If pakList.numFiles > 0 Then
                ReDim Preserve tempList.pList(numFiles + pakList.numFiles - 1) As String
                For j = 0 To pakList.numFiles - 1
                    temp = TokStrip(pakList.directory(j).Name, "/", tsLastTok, tsAfterTok)
                    temp = Left(temp, Len(temp) - 4)
                    tempList.pList(numFiles + j) = temp
                Next j
                numFiles = numFiles + pakList.numFiles
            End If
        Next i
    End If
    
    'build a list
    File2.Pattern = "*.dem"
    File2.Refresh
    
    If File2.ListCount = 0 Then
        If numFiles = 0 Then
            tempList.pName = DEMOS_NOT_FOUND
        End If
    Else
        ReDim Preserve tempList.pList(numFiles + File2.ListCount - 1) As String
        For i = 0 To (File2.ListCount - 1)
            tempList.pList(numFiles + i) = Left(File2.List(i), Len(File2.List(i)) - 4)
        Next i
    End If
    
    listDemos = tempList
    
    Exit Function
    
Hell:
    Select Case Err.Number
        Case 70:
            'File in use.
        Case Else:
            ReportError Err.Number, Err.Description, "<Getting a list of demos>"
    End Select

    tempList.pName = DEMOS_NOT_FOUND
    listDemos = tempList

End Function

'This function concats a couple o' demo lists, dude.
Private Function ConcatDemoLists(demList1 As PopupList, demList2 As PopupList) As PopupList

    Dim tempList As PopupList
    
    If demList1.pName <> DEMOS_NOT_FOUND Then
        If demList2.pName <> DEMOS_NOT_FOUND Then
            tempList = ConcatPopupList(demList1, demList2, PL_NO_DUPLICATES)
        Else
            tempList = demList1
        End If
    Else
        If demList2.pName <> DEMOS_NOT_FOUND Then
            tempList = demList2
        Else
            tempList.pName = DEMOS_NOT_FOUND
        End If
    End If
    
    ConcatDemoLists = tempList

End Function

Private Sub DoDaDemos(demoPath As String)

    Dim tempList As PopupList
    Dim demoCount As Integer
    Dim fn2 As Integer
    Dim i As Integer

    With qs
        If Dir(.quakeDir & "\" & .ddd & "\*.*") = "" Then
            tempList = listDemos(.quakeDir & "\" & .selectedPatch)
        Else
            tempList = ConcatDemoLists(listDemos(.quakeDir & "\" & .ddd), listDemos(.quakeDir & "\" & .selectedPatch))
        End If
        If tempList.pName <> DEMOS_NOT_FOUND Then

            demoCount = UBound(tempList.pList) + 1
            fn2 = FreeFile
            Open demoPath For Output As fn2
            Print #fn2, "echo ** Listing Available Demos"
            For i = 0 To demoCount - 1
                Print #fn2, "echo ** " & tempList.pList(i)
            Next i
            Close fn2

        End If
    End With

End Sub

Private Sub DoDaMaps(mapPath As String)

    Dim tempList As PopupList
    Dim temp As String
    Dim qdir As String
    Dim fn As Integer
    Dim i As Integer
    
    qdir = qs.quakeDir
    
    fn = FreeFile
    Open mapPath For Output As fn
    
    temp = qdir & "\" & qs.ddd & "\maps"
    If Dir(temp & "\*.bsp") <> "" Then
        tempList = DirBSPsToPopupList(temp)
        If tempList.pName <> MAP_NOT_FOUND Then
            For i = 0 To UBound(tempList.pList)
                Print #fn, "echo " & Chr(34) & tempList.pList(i) & Chr(34)
            Next i
        End If
    End If
    
    temp = qdir & "\" & qs.selectedPatch
    If Dir(temp & "\*.pak") <> "" Then
        tempList = DirPakBspsToPopupList(temp)
        If tempList.pName <> MAP_NOT_FOUND Then
            For i = 0 To UBound(tempList.pList)
                Print #fn, "echo " & Chr(34) & tempList.pList(i) & Chr(34)
            Next i
        End If
    End If
    
    temp = qdir & "\" & qs.selectedPatch & "\maps"
    If Dir(temp & "\*.bsp") <> "" Then
        tempList = DirBSPsToPopupList(temp)
        If tempList.pName <> MAP_NOT_FOUND Then
            For i = 0 To UBound(tempList.pList)
                Print #fn, "echo " & Chr(34) & tempList.pList(i) & Chr(34)
            Next i
        End If
    End If
    
    Close fn

End Sub

Public Sub LoadMyIniData()
    
    Dim i As Integer
    Dim iniSection As String
    Dim temp As String

    If Dir(myIniPath) = "" Then MakeNewINIFile
    
    'Read in the entire Main ini section
    iniSection = GetSection(myIniPath, "Main")
    lastIniFile = GetKey(iniSection, "LastIniFile", "QuakeOn.ini")
    defaultQuakeSet = GetKey(iniSection, "DefaultQuakeSet", "Default")
    trayDoubleClick = Val(GetKey(iniSection, "DoubleClickStylie", "0"))
    listDemosOn = Val(GetKey(iniSection, "ListDemos", "0"))
    listMapsOn = Val(GetKey(iniSection, "ListMaps", "0"))
    
End Sub

Public Sub SaveSettings()
    
    Dim fn As Integer
    
    fn = FreeFile
    
    Open myIniPath For Output As fn

    Print #fn, "[Main]"
    Print #fn, "LastIniFile=" & lastIniFile
    Print #fn, "DefaultQuakeSet=" & defaultQuakeSet
    Print #fn, "DoubleClickStylie=" & trayDoubleClick
    Print #fn, "ListDemos=" & listDemosOn
    Print #fn, "ListMaps=" & listMapsOn

    Close fn

End Sub

Private Sub UpdateMenus()

    Dim i As Integer
    
    For i = 0 To 2
        
        If listDemosOn = i Then
            muListDemos(i).Checked = True
        Else
            muListDemos(i).Checked = False
        End If
        
        If listMapsOn = i Then
            muListMaps(i).Checked = True
        Else
            muListMaps(i).Checked = False
        End If
        
        If i < 2 Then
            If trayDoubleClick = i Then
                muDoubleClick(i).Checked = True
            Else
                muDoubleClick(i).Checked = False
            End If
        End If
        
    Next i

End Sub

Public Sub InitializeFileMenu()

    Dim i As Integer
    Dim currentIni As String
    Dim temp As String

    currentIni = LCase(iniPath)
    currentIni = Left(currentIni, Len(currentIni) - 4)
    currentIni = TokStrip(currentIni, "\", tsLastTok, tsAfterTok)
    
    'I'd like to remove all the menu items and then
    'start over from scratch
    For i = 1 To (fileArrayCount - 1)
        Unload fMain.muFileArray(i)
    Next i
    
    lstTemp.Clear
    
    File2.Path = App.Path
    File2.Pattern = "*.ini"
    File2.Refresh
    
    For i = 0 To File2.ListCount - 1
        temp = File2.List(i)
        temp = Left(temp, Len(temp) - 4)
        If LCase(temp) <> "qtray" Then
            lstTemp.AddItem temp
        End If
    Next i
    
    fileArrayCount = lstTemp.ListCount
    
    If fileArrayCount <= 1 Then
        fileArrayCount = 1
        muSettingsFile.Visible = False
    Else
        For i = 0 To lstTemp.ListCount - 1
            muFileArray(i).Caption = lstTemp.List(i)
            If LCase(lstTemp.List(i)) = currentIni Then
                muFileArray(i).Checked = True
            Else
                muFileArray(i).Checked = False
            End If
            If (i + 1) <= (lstTemp.ListCount - 1) Then
                Load fMain!muFileArray(i + 1)
            End If
        Next i
    End If
    
    

End Sub
