Attribute VB_Name = "mUtilities"
'---------------------------------------------------------------------------
'Copyright 1997-1998 by Brian Kelly
'
'This program is free software; you can redistribute it and/or
'modify it under the terms of the GNU General Public License
'as published by the Free Software Foundation; either version 2
'of the License, or (at your option) any later version.
'
'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'See the GNU General Public License for more details.
'
'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'---------------------------------------------------------------------------
Option Explicit

'Here's the damn play sound api
Declare Function PlaySound Lib "winmm.dll" Alias "PlaySoundA" (ByVal lpszName As String, ByVal hModule As Long, ByVal dwFlags As Long) As Long

Public Const SND_ASYNC = &H1
Public Const SND_MEMORY = &H4
Public Const SND_LOOP = &H8

'------------
'ShellExecute
'------------
'Execute a program, open a document, print a file...

Public Enum seWindowStyle
    SW_SHOW = 5
    SW_SHOWDEFAULT = 10
    SW_SHOWMAXIMIZED = 3
    SW_SHOWMINIMIZED = 2
    SW_SHOWMINNOACTIVE = 7
    SW_SHOWNA = 8
    SW_SHOWNOACTIVATE = 4
    SW_SHOWNORMAL = 1
End Enum

Public Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As seWindowStyle) As Long

'--------------------------------------
'--------------------------------------


'Finds the specified thingie in the specified list.
'Returns the index, don'tcha know?
'CASE INSENSITIVE AS OF 05/20/97, DUDE
Public Function FindInList(o As Object, s As String) As Integer

    Dim i As Integer
    Dim done As Boolean
    
    i = 0
    done = False
    
    'MsgBox "FindInList Called for object:  " & o.name & ", searching for:  " & s
    
    Do Until ((done = True) Or (i = o.ListCount))
        If LCase(o.List(i)) = LCase(s) Then 'we found it!
            done = True
        Else
            i = i + 1
        End If
    Loop
    
    If done = True Then
        FindInList = i
    Else
        FindInList = -1
    End If

End Function

'This function takes a delimited list and adds the items
'to something that can use the AddItem method
'Only works if the delimiter is one character, of course
Public Sub ParseVals(s As String, Delimeter As String, obj As Object)

    Dim i As Integer
    Dim l As Integer
    Dim temp As String
    
    temp = ""
    
    For i = 1 To Len(s)
        If Mid(s, i, 1) = Delimeter Then
            obj.AddItem Trim(temp)
            temp = ""
        Else
            temp = temp & Mid(s, i, 1)
        End If
    Next i
    
    If temp <> "" Then obj.AddItem temp

End Sub

'------------
'BoolToString
'------------
'Converts a boolean value into a string ("true" or "false")
'You may specify the specific strings you want to signify true
'and false, otherwise it will return "true" and "false" (no caps)
Public Function BoolToString(BooleanValue As Boolean, Optional TrueString As String, Optional FalseString As String) As String

    Dim fComp As String
    Dim tComp As String
    
    If BooleanValue Then
        If TrueString = "" Then
            BoolToString = "true"
        Else
            BoolToString = TrueString
        End If
    Else
        If FalseString = "" Then
            BoolToString = "false"
        Else
            BoolToString = FalseString
        End If
    End If

End Function

'------------
'StringToBool
'------------
'Converts a string value to a boolean value
'If the string is "true" then it returns true, otherwise it returns false
'You may specify a "true" string
Public Function StringToBool(BoolString As String, Optional TrueString As String) As Boolean

    If TrueString = "" Then
        If BoolString = "true" Then
            StringToBool = True
        Else
            StringToBool = False
        End If
    Else
        If BoolString = TrueString Then
            StringToBool = True
        Else
            StringToBool = False
        End If
    End If

End Function
