#ifndef _GNU_H_WIN32Headers
#include <win.h>
#endif
#ifndef _LCC_ACM
#define _LCC_ACM
#if !defined(_LCC_MMREG) 
#ifndef RC_INVOKED
#error MMREG.H version 142 or greater must be included first
#endif
#endif

#ifndef RC_INVOKED
#pragma pack(1) /* Assume byte packing throughout */
#endif
#ifndef DRV_MAPPER_PREFERRED_INPUT_GET
#define DRV_MAPPER_PREFERRED_INPUT_GET (DRV_USER+0)
#endif
#ifndef DRV_MAPPER_PREFERRED_OUTPUT_GET
#define DRV_MAPPER_PREFERRED_OUTPUT_GET (DRV_USER+2)
#endif
#ifndef DRVM_MAPPER_STATUS
#define DRVM_MAPPER_STATUS (0x2000)
#endif
#ifndef WIDM_MAPPER_STATUS
#define WIDM_MAPPER_STATUS (DRVM_MAPPER_STATUS + 0)
#define WAVEIN_MAPPER_STATUS_DEVICE 0
#define WAVEIN_MAPPER_STATUS_MAPPED 1
#define WAVEIN_MAPPER_STATUS_FORMAT 2
#endif
#ifndef WODM_MAPPER_STATUS
#define WODM_MAPPER_STATUS (DRVM_MAPPER_STATUS + 0)
#define WAVEOUT_MAPPER_STATUS_DEVICE 0
#define WAVEOUT_MAPPER_STATUS_MAPPED 1
#define WAVEOUT_MAPPER_STATUS_FORMAT 2
#endif
#define ACMAPI WINAPI
DECLARE_HANDLE(HACMDRIVERID);
typedef HACMDRIVERID *PHACMDRIVERID;
typedef HACMDRIVERID *LPHACMDRIVERID;
DECLARE_HANDLE(HACMDRIVER);
typedef HACMDRIVER *PHACMDRIVER;
typedef HACMDRIVER *LPHACMDRIVER;
DECLARE_HANDLE(HACMSTREAM);
typedef HACMSTREAM *PHACMSTREAM;
typedef HACMSTREAM *LPHACMSTREAM;
DECLARE_HANDLE(HACMOBJ);
typedef HACMOBJ *PHACMOBJ;
typedef HACMOBJ *LPHACMOBJ;
#ifndef _MMRESULT_DEFINED
#define _MMRESULT_DEFINED
typedef UINT MMRESULT;
#endif
#define ACMERR_BASE (512)
#define ACMERR_NOTPOSSIBLE (ACMERR_BASE + 0)
#define ACMERR_BUSY (ACMERR_BASE + 1)
#define ACMERR_UNPREPARED (ACMERR_BASE + 2)
#define ACMERR_CANCELED (ACMERR_BASE + 3)
#define MM_ACM_OPEN (MM_STREAM_OPEN)
#define MM_ACM_CLOSE (MM_STREAM_CLOSE)
#define MM_ACM_DONE (MM_STREAM_DONE)
DWORD ACMAPI acmGetVersion(void);
MMRESULT ACMAPI acmMetrics(HACMOBJ,UINT,LPVOID);
#define ACM_METRIC_COUNT_DRIVERS 1
#define ACM_METRIC_COUNT_CODECS 2
#define ACM_METRIC_COUNT_CONVERTERS 3
#define ACM_METRIC_COUNT_FILTERS 4
#define ACM_METRIC_COUNT_DISABLED 5
#define ACM_METRIC_COUNT_HARDWARE 6
#define ACM_METRIC_COUNT_LOCAL_DRIVERS 20
#define ACM_METRIC_COUNT_LOCAL_CODECS 21
#define ACM_METRIC_COUNT_LOCAL_CONVERTERS 22
#define ACM_METRIC_COUNT_LOCAL_FILTERS 23
#define ACM_METRIC_COUNT_LOCAL_DISABLED 24
#define ACM_METRIC_HARDWARE_WAVE_INPUT 30
#define ACM_METRIC_HARDWARE_WAVE_OUTPUT 31
#define ACM_METRIC_MAX_SIZE_FORMAT 50
#define ACM_METRIC_MAX_SIZE_FILTER 51
#define ACM_METRIC_DRIVER_SUPPORT 100
#define ACM_METRIC_DRIVER_PRIORITY 101
typedef BOOL (CALLBACK *ACMDRIVERENUMCB)(HACMDRIVERID,DWORD,DWORD);
MMRESULT ACMAPI acmDriverEnum(ACMDRIVERENUMCB,DWORD,DWORD);
#define ACM_DRIVERENUMF_NOLOCAL 0x40000000L
#define ACM_DRIVERENUMF_DISABLED 0x80000000L
MMRESULT ACMAPI acmDriverID(HACMOBJ,LPHACMDRIVERID,DWORD);
MMRESULT ACMAPI acmDriverAddA(LPHACMDRIVERID,HINSTANCE,LPARAM,DWORD,DWORD);
MMRESULT ACMAPI acmDriverAddW(LPHACMDRIVERID,HINSTANCE,LPARAM,DWORD,DWORD);
#ifdef UNICODE
#define acmDriverAdd acmDriverAddW
#else
#define acmDriverAdd acmDriverAddA
#endif
#define ACM_DRIVERADDF_FUNCTION 3
#define ACM_DRIVERADDF_NOTIFYHWND 4
#define ACM_DRIVERADDF_TYPEMASK 7
#define ACM_DRIVERADDF_LOCAL 0
#define ACM_DRIVERADDF_GLOBAL 8
typedef LRESULT(CALLBACK *ACMDRIVERPROC)(DWORD,HACMDRIVERID,UINT,LPARAM,LPARAM);
typedef ACMDRIVERPROC *LPACMDRIVERPROC;
MMRESULT ACMAPI acmDriverRemove(HACMDRIVERID,DWORD);
MMRESULT ACMAPI acmDriverOpen(LPHACMDRIVER,HACMDRIVERID,DWORD);
MMRESULT ACMAPI acmDriverClose(HACMDRIVER,DWORD);
LRESULT ACMAPI acmDriverMessage(HACMDRIVER,UINT,LPARAM,LPARAM);
#define ACMDM_USER (DRV_USER + 0x0000)
#define ACMDM_RESERVED_LOW (DRV_USER + 0x2000)
#define ACMDM_RESERVED_HIGH (DRV_USER + 0x2FFF)
#define ACMDM_BASE ACMDM_RESERVED_LOW
#define ACMDM_DRIVER_ABOUT (ACMDM_BASE + 11)
MMRESULT ACMAPI acmDriverPriority(HACMDRIVERID,DWORD,DWORD);
#define ACM_DRIVERPRIORITYF_ENABLE 1
#define ACM_DRIVERPRIORITYF_DISABLE 2
#define ACM_DRIVERPRIORITYF_ABLEMASK 3
#define ACM_DRIVERPRIORITYF_BEGIN 0x10000L
#define ACM_DRIVERPRIORITYF_END 0x20000L
#define ACM_DRIVERPRIORITYF_DEFERMASK 0x30000L
#define ACMDRIVERDETAILS_SHORTNAME_CHARS 32
#define ACMDRIVERDETAILS_LONGNAME_CHARS 128
#define ACMDRIVERDETAILS_COPYRIGHT_CHARS 80
#define ACMDRIVERDETAILS_LICENSING_CHARS 128
#define ACMDRIVERDETAILS_FEATURES_CHARS 512
typedef struct tACMDRIVERDETAILSA {
	DWORD cbStruct;
	FOURCC fccType;
	FOURCC fccComp;
	WORD wMid;
	WORD wPid;
	DWORD vdwACM;
	DWORD vdwDriver;
	DWORD fdwSupport;
	DWORD cFormatTags;
	DWORD cFilterTags;
	HICON hicon;
	char szShortName[ACMDRIVERDETAILS_SHORTNAME_CHARS];
	char szLongName[ACMDRIVERDETAILS_LONGNAME_CHARS];
	char szCopyright[ACMDRIVERDETAILS_COPYRIGHT_CHARS];
	char szLicensing[ACMDRIVERDETAILS_LICENSING_CHARS];
	char szFeatures[ACMDRIVERDETAILS_FEATURES_CHARS];
} ACMDRIVERDETAILSA, *PACMDRIVERDETAILSA, *LPACMDRIVERDETAILSA;
typedef struct tACMDRIVERDETAILSW {
	DWORD cbStruct;
	FOURCC fccType;
	FOURCC fccComp;
	WORD wMid;
	WORD wPid;
	DWORD vdwACM;
	DWORD vdwDriver;
	DWORD fdwSupport;
	DWORD cFormatTags;
	DWORD cFilterTags;
	HICON hicon;
	WCHAR szShortName[ACMDRIVERDETAILS_SHORTNAME_CHARS];
	WCHAR szLongName[ACMDRIVERDETAILS_LONGNAME_CHARS];
	WCHAR szCopyright[ACMDRIVERDETAILS_COPYRIGHT_CHARS];
	WCHAR szLicensing[ACMDRIVERDETAILS_LICENSING_CHARS];
	WCHAR szFeatures[ACMDRIVERDETAILS_FEATURES_CHARS];
} ACMDRIVERDETAILSW, *PACMDRIVERDETAILSW, *LPACMDRIVERDETAILSW;
#ifdef UNICODE
#define ACMDRIVERDETAILS ACMDRIVERDETAILSW
#define PACMDRIVERDETAILS PACMDRIVERDETAILSW
#define LPACMDRIVERDETAILS LPACMDRIVERDETAILSW
#else
#define ACMDRIVERDETAILS ACMDRIVERDETAILSA
#define PACMDRIVERDETAILS PACMDRIVERDETAILSA
#define LPACMDRIVERDETAILS LPACMDRIVERDETAILSA
#endif
#define ACMDRIVERDETAILS_FCCTYPE_AUDIOCODEC mmioFOURCC('a', 'u', 'd', 'c')
#define ACMDRIVERDETAILS_FCCCOMP_UNDEFINED mmioFOURCC('\0', '\0', '\0', '\0')
#define ACMDRIVERDETAILS_SUPPORTF_CODEC 1
#define ACMDRIVERDETAILS_SUPPORTF_CONVERTER 2
#define ACMDRIVERDETAILS_SUPPORTF_FILTER 4
#define ACMDRIVERDETAILS_SUPPORTF_HARDWARE 8
#define ACMDRIVERDETAILS_SUPPORTF_ASYNC 0x10
#define ACMDRIVERDETAILS_SUPPORTF_LOCAL 0x40000000
#define ACMDRIVERDETAILS_SUPPORTF_DISABLED 0x80000000
MMRESULT ACMAPI acmDriverDetailsA(HACMDRIVERID,LPACMDRIVERDETAILSA,DWORD);
MMRESULT ACMAPI acmDriverDetailsW(HACMDRIVERID,LPACMDRIVERDETAILSW,DWORD);
#ifdef UNICODE
#define acmDriverDetails acmDriverDetailsW
#else
#define acmDriverDetails acmDriverDetailsA
#endif
#define ACMFORMATTAGDETAILS_FORMATTAG_CHARS 48
typedef struct _ACMFORMATTAGDETAILSA {
	DWORD cbStruct;
	DWORD dwFormatTagIndex;
	DWORD dwFormatTag;
	DWORD cbFormatSize;
	DWORD fdwSupport;
	DWORD cStandardFormats;
	char szFormatTag[ACMFORMATTAGDETAILS_FORMATTAG_CHARS];
} ACMFORMATTAGDETAILSA, *PACMFORMATTAGDETAILSA, *LPACMFORMATTAGDETAILSA;
typedef struct _ACMFORMATTAGDETAILSW {
	DWORD cbStruct;
	DWORD dwFormatTagIndex;
	DWORD dwFormatTag;
	DWORD cbFormatSize;
	DWORD fdwSupport;
	DWORD cStandardFormats;
	WCHAR szFormatTag[ACMFORMATTAGDETAILS_FORMATTAG_CHARS];
} ACMFORMATTAGDETAILSW, *PACMFORMATTAGDETAILSW, *LPACMFORMATTAGDETAILSW;

#ifdef UNICODE
#define ACMFORMATTAGDETAILS ACMFORMATTAGDETAILSW
#define PACMFORMATTAGDETAILS PACMFORMATTAGDETAILSW
#define LPACMFORMATTAGDETAILS LPACMFORMATTAGDETAILSW
#else
#define ACMFORMATTAGDETAILS ACMFORMATTAGDETAILSA
#define PACMFORMATTAGDETAILS PACMFORMATTAGDETAILSA
#define LPACMFORMATTAGDETAILS LPACMFORMATTAGDETAILSA
#endif
MMRESULT ACMAPI acmFormatTagDetailsA(HACMDRIVER,LPACMFORMATTAGDETAILSA,DWORD);
MMRESULT ACMAPI acmFormatTagDetailsW(HACMDRIVER,LPACMFORMATTAGDETAILSW,DWORD);
#ifdef UNICODE
#define acmFormatTagDetails acmFormatTagDetailsW
#else
#define acmFormatTagDetails acmFormatTagDetailsA
#endif
#define ACM_FORMATTAGDETAILSF_INDEX 0x00000000L
#define ACM_FORMATTAGDETAILSF_FORMATTAG 0x00000001L
#define ACM_FORMATTAGDETAILSF_LARGESTSIZE 0x00000002L
#define ACM_FORMATTAGDETAILSF_QUERYMASK 0x0000000FL
typedef BOOL(CALLBACK *ACMFORMATTAGENUMCBA)(HACMDRIVERID,LPACMFORMATTAGDETAILSA,DWORD,DWORD);
MMRESULT ACMAPI acmFormatTagEnumA(HACMDRIVER,LPACMFORMATTAGDETAILSA,ACMFORMATTAGENUMCBA,DWORD,DWORD);
typedef BOOL(CALLBACK *ACMFORMATTAGENUMCBW)(HACMDRIVERID,LPACMFORMATTAGDETAILSW,DWORD,DWORD);
MMRESULT ACMAPI acmFormatTagEnumW(HACMDRIVER,LPACMFORMATTAGDETAILSW,ACMFORMATTAGENUMCBW,DWORD,DWORD);
#ifdef UNICODE
#define ACMFORMATTAGENUMCB ACMFORMATTAGENUMCBW
#define acmFormatTagEnum acmFormatTagEnumW
#else
#define ACMFORMATTAGENUMCB ACMFORMATTAGENUMCBA
#define acmFormatTagEnum acmFormatTagEnumA
#endif
#define ACMFORMATDETAILS_FORMAT_CHARS 128
typedef struct _ACMFORMATDETAILSA {
	DWORD cbStruct;
	DWORD dwFormatIndex;
	DWORD dwFormatTag;
	DWORD fdwSupport;
	LPWAVEFORMATEX pwfx;
	DWORD cbwfx;
	char szFormat[ACMFORMATDETAILS_FORMAT_CHARS];
} ACMFORMATDETAILSA, *PACMFORMATDETAILSA, *LPACMFORMATDETAILSA;
typedef struct tACMFORMATDETAILSW {
	DWORD cbStruct;
	DWORD dwFormatIndex;
	DWORD dwFormatTag;
	DWORD fdwSupport;
	LPWAVEFORMATEX pwfx;
	DWORD cbwfx;
	WCHAR szFormat[ACMFORMATDETAILS_FORMAT_CHARS];
} ACMFORMATDETAILSW, *PACMFORMATDETAILSW, *LPACMFORMATDETAILSW;
#ifdef UNICODE
#define ACMFORMATDETAILS ACMFORMATDETAILSW
#define PACMFORMATDETAILS PACMFORMATDETAILSW
#define LPACMFORMATDETAILS LPACMFORMATDETAILSW
#else
#define ACMFORMATDETAILS ACMFORMATDETAILSA
#define PACMFORMATDETAILS PACMFORMATDETAILSA
#define LPACMFORMATDETAILS LPACMFORMATDETAILSA
#endif
MMRESULT ACMAPI acmFormatDetailsA(HACMDRIVER,LPACMFORMATDETAILSA,DWORD);
MMRESULT ACMAPI acmFormatDetailsW(HACMDRIVER,LPACMFORMATDETAILSW,DWORD);
#ifdef UNICODE
#define acmFormatDetails acmFormatDetailsW
#else
#define acmFormatDetails acmFormatDetailsA
#endif
#define ACM_FORMATDETAILSF_INDEX 0x00000000L
#define ACM_FORMATDETAILSF_FORMAT 0x00000001L
#define ACM_FORMATDETAILSF_QUERYMASK 0x0000000FL
typedef BOOL (CALLBACK *ACMFORMATENUMCBA)(HACMDRIVERID,LPACMFORMATDETAILSA,DWORD,DWORD);
MMRESULT ACMAPI acmFormatEnumA (HACMDRIVER,LPACMFORMATDETAILSA,ACMFORMATENUMCBA,DWORD, DWORD);
typedef BOOL (CALLBACK *ACMFORMATENUMCBW)(HACMDRIVERID,LPACMFORMATDETAILSW,DWORD,DWORD);
MMRESULT ACMAPI acmFormatEnumW
(
	HACMDRIVER had,
	LPACMFORMATDETAILSW pafd,
	ACMFORMATENUMCBW fnCallback,
	DWORD dwInstance, 
	DWORD fdwEnum
);

#ifdef UNICODE
#define ACMFORMATENUMCB ACMFORMATENUMCBW
#define acmFormatEnum acmFormatEnumW
#else
#define ACMFORMATENUMCB ACMFORMATENUMCBA
#define acmFormatEnum acmFormatEnumA
#endif
#define ACM_FORMATENUMF_WFORMATTAG 0x00010000L
#define ACM_FORMATENUMF_NCHANNELS 0x00020000L
#define ACM_FORMATENUMF_NSAMPLESPERSEC 0x00040000L
#define ACM_FORMATENUMF_WBITSPERSAMPLE 0x00080000L
#define ACM_FORMATENUMF_CONVERT 0x00100000L
#define ACM_FORMATENUMF_SUGGEST 0x00200000L
#define ACM_FORMATENUMF_HARDWARE 0x00400000L
#define ACM_FORMATENUMF_INPUT 0x00800000L
#define ACM_FORMATENUMF_OUTPUT 0x01000000L
MMRESULT ACMAPI acmFormatSuggest (HACMDRIVER,LPWAVEFORMATEX,LPWAVEFORMATEX,DWORD,DWORD);
#define ACM_FORMATSUGGESTF_WFORMATTAG 0x00010000L
#define ACM_FORMATSUGGESTF_NCHANNELS 0x00020000L
#define ACM_FORMATSUGGESTF_NSAMPLESPERSEC 0x00040000L
#define ACM_FORMATSUGGESTF_WBITSPERSAMPLE 0x00080000L
#define ACM_FORMATSUGGESTF_TYPEMASK 0x00FF0000L
#define ACMHELPMSGSTRINGA "acmchoose_help"
#define ACMHELPMSGSTRINGW L"acmchoose_help"
#define ACMHELPMSGCONTEXTMENUA "acmchoose_contextmenu"
#define ACMHELPMSGCONTEXTMENUW L"acmchoose_contextmenu"
#define ACMHELPMSGCONTEXTHELPA "acmchoose_contexthelp"
#define ACMHELPMSGCONTEXTHELPW L"acmchoose_contexthelp"
#ifdef UNICODE
#define ACMHELPMSGSTRING ACMHELPMSGSTRINGW
#define ACMHELPMSGCONTEXTMENU ACMHELPMSGCONTEXTMENUW
#define ACMHELPMSGCONTEXTHELP ACMHELPMSGCONTEXTHELPW
#else
#define ACMHELPMSGSTRING ACMHELPMSGSTRINGA
#define ACMHELPMSGCONTEXTMENU ACMHELPMSGCONTEXTMENUA
#define ACMHELPMSGCONTEXTHELP ACMHELPMSGCONTEXTHELPA
#endif
#define MM_ACM_FORMATCHOOSE (0x8000)
#define FORMATCHOOSE_MESSAGE 0
#define FORMATCHOOSE_FORMATTAG_VERIFY (FORMATCHOOSE_MESSAGE+0)
#define FORMATCHOOSE_FORMAT_VERIFY (FORMATCHOOSE_MESSAGE+1)
#define FORMATCHOOSE_CUSTOM_VERIFY (FORMATCHOOSE_MESSAGE+2)
typedef UINT (CALLBACK *ACMFORMATCHOOSEHOOKPROCA)(HWND,UINT,WPARAM,LPARAM);
typedef UINT (CALLBACK *ACMFORMATCHOOSEHOOKPROCW)(HWND,UINT,WPARAM,LPARAM);
#ifdef UNICODE
#define ACMFORMATCHOOSEHOOKPROC ACMFORMATCHOOSEHOOKPROCW
#else
#define ACMFORMATCHOOSEHOOKPROC ACMFORMATCHOOSEHOOKPROCA
#endif
typedef struct tACMFORMATCHOOSEA
{
	DWORD cbStruct; 
	DWORD fdwStyle; 
	HWND hwndOwner; 
	LPWAVEFORMATEX pwfx; 
	DWORD cbwfx; 
	LPCSTR pszTitle; 
	char szFormatTag[ACMFORMATTAGDETAILS_FORMATTAG_CHARS];
	char szFormat[ACMFORMATDETAILS_FORMAT_CHARS]; 
	LPSTR pszName; 
	DWORD cchName; 
	DWORD fdwEnum; 
	LPWAVEFORMATEX pwfxEnum; 
	HINSTANCE hInstance; 
	LPCSTR pszTemplateName; 
	LPARAM lCustData; 
	ACMFORMATCHOOSEHOOKPROCA pfnHook; 
} ACMFORMATCHOOSEA, *PACMFORMATCHOOSEA, *LPACMFORMATCHOOSEA;
typedef struct tACMFORMATCHOOSEW
{
	DWORD cbStruct; 
	DWORD fdwStyle; 
	HWND hwndOwner; 
	LPWAVEFORMATEX pwfx; 
	DWORD cbwfx; 
	LPCWSTR pszTitle; 
	WCHAR szFormatTag[ACMFORMATTAGDETAILS_FORMATTAG_CHARS];
	WCHAR szFormat[ACMFORMATDETAILS_FORMAT_CHARS]; 
	LPWSTR pszName; 
	DWORD cchName; 
	DWORD fdwEnum; 
	LPWAVEFORMATEX pwfxEnum; 
	HINSTANCE hInstance; 
	LPCWSTR pszTemplateName; 
	LPARAM lCustData; 
	ACMFORMATCHOOSEHOOKPROCW pfnHook; 
} ACMFORMATCHOOSEW, *PACMFORMATCHOOSEW, *LPACMFORMATCHOOSEW;
#ifdef UNICODE
#define ACMFORMATCHOOSE ACMFORMATCHOOSEW
#define PACMFORMATCHOOSE PACMFORMATCHOOSEW
#define LPACMFORMATCHOOSE LPACMFORMATCHOOSEW
#else
#define ACMFORMATCHOOSE ACMFORMATCHOOSEA
#define PACMFORMATCHOOSE PACMFORMATCHOOSEA
#define LPACMFORMATCHOOSE LPACMFORMATCHOOSEA
#endif
#define ACMFORMATCHOOSE_STYLEF_SHOWHELP 0x00000004L
#define ACMFORMATCHOOSE_STYLEF_ENABLEHOOK 0x00000008L
#define ACMFORMATCHOOSE_STYLEF_ENABLETEMPLATE 0x00000010L
#define ACMFORMATCHOOSE_STYLEF_ENABLETEMPLATEHANDLE 0x00000020L
#define ACMFORMATCHOOSE_STYLEF_INITTOWFXSTRUCT 0x00000040L
#define ACMFORMATCHOOSE_STYLEF_CONTEXTHELP 0x00000080L
MMRESULT ACMAPI acmFormatChooseA(LPACMFORMATCHOOSEA);
MMRESULT ACMAPI acmFormatChooseW(LPACMFORMATCHOOSEW);
#ifdef UNICODE
#define acmFormatChoose acmFormatChooseW
#else
#define acmFormatChoose acmFormatChooseA
#endif
#define ACMFILTERTAGDETAILS_FILTERTAG_CHARS 48
typedef struct _ACMFILTERTAGDETAILSA {
	DWORD cbStruct;
	DWORD dwFilterTagIndex;
	DWORD dwFilterTag;
	DWORD cbFilterSize;
	DWORD fdwSupport;
	DWORD cStandardFilters;
	char szFilterTag[ACMFILTERTAGDETAILS_FILTERTAG_CHARS];
} ACMFILTERTAGDETAILSA, *PACMFILTERTAGDETAILSA, *LPACMFILTERTAGDETAILSA;
typedef struct tACMFILTERTAGDETAILSW {
	DWORD cbStruct;
	DWORD dwFilterTagIndex;
	DWORD dwFilterTag;
	DWORD cbFilterSize;
	DWORD fdwSupport;
	DWORD cStandardFilters;
	WCHAR szFilterTag[ACMFILTERTAGDETAILS_FILTERTAG_CHARS];
} ACMFILTERTAGDETAILSW, *PACMFILTERTAGDETAILSW, *LPACMFILTERTAGDETAILSW;
#ifdef UNICODE
#define ACMFILTERTAGDETAILS ACMFILTERTAGDETAILSW
#define PACMFILTERTAGDETAILS PACMFILTERTAGDETAILSW
#define LPACMFILTERTAGDETAILS LPACMFILTERTAGDETAILSW
#else
#define ACMFILTERTAGDETAILS ACMFILTERTAGDETAILSA
#define PACMFILTERTAGDETAILS PACMFILTERTAGDETAILSA
#define LPACMFILTERTAGDETAILS LPACMFILTERTAGDETAILSA
#endif
MMRESULT ACMAPI acmFilterTagDetailsA(HACMDRIVER,LPACMFILTERTAGDETAILSA,DWORD);
MMRESULT ACMAPI acmFilterTagDetailsW(HACMDRIVER,LPACMFILTERTAGDETAILSW,DWORD);
#ifdef UNICODE
#define acmFilterTagDetails acmFilterTagDetailsW
#else
#define acmFilterTagDetails acmFilterTagDetailsA
#endif
#define ACM_FILTERTAGDETAILSF_INDEX 0x00000000L
#define ACM_FILTERTAGDETAILSF_FILTERTAG 0x00000001L
#define ACM_FILTERTAGDETAILSF_LARGESTSIZE 0x00000002L
#define ACM_FILTERTAGDETAILSF_QUERYMASK 0x0000000FL
typedef BOOL (CALLBACK *ACMFILTERTAGENUMCBA)(HACMDRIVERID,LPACMFILTERTAGDETAILSA,DWORD,DWORD);
MMRESULT ACMAPI acmFilterTagEnumA(HACMDRIVER,LPACMFILTERTAGDETAILSA,ACMFILTERTAGENUMCBA,DWORD,DWORD);
typedef BOOL (CALLBACK *ACMFILTERTAGENUMCBW) (HACMDRIVERID,LPACMFILTERTAGDETAILSW,DWORD,DWORD);
MMRESULT ACMAPI acmFilterTagEnumW(HACMDRIVER,LPACMFILTERTAGDETAILSW,ACMFILTERTAGENUMCBW,DWORD,DWORD);
#ifdef UNICODE
#define ACMFILTERTAGENUMCB ACMFILTERTAGENUMCBW
#define acmFilterTagEnum acmFilterTagEnumW
#else
#define ACMFILTERTAGENUMCB ACMFILTERTAGENUMCBA
#define acmFilterTagEnum acmFilterTagEnumA
#endif
#define ACMFILTERDETAILS_FILTER_CHARS 128
typedef struct _ACMFILTERDETAILSA {
	DWORD cbStruct;
	DWORD dwFilterIndex;
	DWORD dwFilterTag;
	DWORD fdwSupport;
	LPWAVEFILTER pwfltr;
	DWORD cbwfltr;
	char szFilter[ACMFILTERDETAILS_FILTER_CHARS];
} ACMFILTERDETAILSA, *PACMFILTERDETAILSA, *LPACMFILTERDETAILSA;
typedef struct tACMFILTERDETAILSW {
	DWORD cbStruct;
	DWORD dwFilterIndex;
	DWORD dwFilterTag;
	DWORD fdwSupport;
	LPWAVEFILTER pwfltr;
	DWORD cbwfltr;
	WCHAR szFilter[ACMFILTERDETAILS_FILTER_CHARS];
} ACMFILTERDETAILSW, *PACMFILTERDETAILSW, *LPACMFILTERDETAILSW;
#ifdef UNICODE
#define ACMFILTERDETAILS ACMFILTERDETAILSW
#define PACMFILTERDETAILS PACMFILTERDETAILSW
#define LPACMFILTERDETAILS LPACMFILTERDETAILSW
#else
#define ACMFILTERDETAILS ACMFILTERDETAILSA
#define PACMFILTERDETAILS PACMFILTERDETAILSA
#define LPACMFILTERDETAILS LPACMFILTERDETAILSA
#endif
MMRESULT ACMAPI acmFilterDetailsA(HACMDRIVER,LPACMFILTERDETAILSA,DWORD);
MMRESULT ACMAPI acmFilterDetailsW(HACMDRIVER,LPACMFILTERDETAILSW,DWORD);
#ifdef UNICODE
#define acmFilterDetails acmFilterDetailsW
#else
#define acmFilterDetails acmFilterDetailsA
#endif
#define ACM_FILTERDETAILSF_INDEX 0x00000000L
#define ACM_FILTERDETAILSF_FILTER 0x00000001L
#define ACM_FILTERDETAILSF_QUERYMASK 0x0000000FL
typedef BOOL (CALLBACK *ACMFILTERENUMCBA)(HACMDRIVERID,LPACMFILTERDETAILSA,DWORD,DWORD);
MMRESULT ACMAPI acmFilterEnumA(HACMDRIVER,LPACMFILTERDETAILSA,ACMFILTERENUMCBA,DWORD,DWORD);
typedef BOOL (CALLBACK *ACMFILTERENUMCBW)(HACMDRIVERID,LPACMFILTERDETAILSW,DWORD,DWORD);
MMRESULT ACMAPI acmFilterEnumW(HACMDRIVER,LPACMFILTERDETAILSW,ACMFILTERENUMCBW,DWORD,DWORD);
#ifdef UNICODE
#define ACMFILTERENUMCB ACMFILTERENUMCBW
#define acmFilterEnum acmFilterEnumW
#else
#define ACMFILTERENUMCB ACMFILTERENUMCBA
#define acmFilterEnum acmFilterEnumA
#endif
#define ACM_FILTERENUMF_DWFILTERTAG 0x00010000L
#define MM_ACM_FILTERCHOOSE (0x8000)
#define FILTERCHOOSE_MESSAGE 0
#define FILTERCHOOSE_FILTERTAG_VERIFY (FILTERCHOOSE_MESSAGE+0)
#define FILTERCHOOSE_FILTER_VERIFY (FILTERCHOOSE_MESSAGE+1)
#define FILTERCHOOSE_CUSTOM_VERIFY (FILTERCHOOSE_MESSAGE+2)
typedef UINT (CALLBACK *ACMFILTERCHOOSEHOOKPROCA)(HWND,UINT,WPARAM,LPARAM);
typedef UINT (CALLBACK *ACMFILTERCHOOSEHOOKPROCW)(HWND,UINT,WPARAM,LPARAM);
#ifdef UNICODE
#define ACMFILTERCHOOSEHOOKPROC ACMFILTERCHOOSEHOOKPROCW
#else
#define ACMFILTERCHOOSEHOOKPROC ACMFILTERCHOOSEHOOKPROCA
#endif
typedef struct _ACMFILTERCHOOSEA {
	DWORD cbStruct; 
	DWORD fdwStyle; 
	HWND hwndOwner; 
	LPWAVEFILTER pwfltr; 
	DWORD cbwfltr; 
	LPCSTR pszTitle;
	char szFilterTag[ACMFILTERTAGDETAILS_FILTERTAG_CHARS];
	char szFilter[ACMFILTERDETAILS_FILTER_CHARS];
	LPSTR pszName; 
	DWORD cchName; 
	DWORD fdwEnum; 
	LPWAVEFILTER pwfltrEnum; 
	HINSTANCE hInstance; 
	LPCSTR pszTemplateName; 
	LPARAM lCustData; 
	ACMFILTERCHOOSEHOOKPROCA pfnHook; 
} ACMFILTERCHOOSEA, *PACMFILTERCHOOSEA, *LPACMFILTERCHOOSEA;
typedef struct _ACMFILTERCHOOSEW {
	DWORD cbStruct; 
	DWORD fdwStyle; 
	HWND hwndOwner; 
	LPWAVEFILTER pwfltr; 
	DWORD cbwfltr; 
	LPCWSTR pszTitle;
	WCHAR szFilterTag[ACMFILTERTAGDETAILS_FILTERTAG_CHARS];
	WCHAR szFilter[ACMFILTERDETAILS_FILTER_CHARS];
	LPWSTR pszName; 
	DWORD cchName; 
	DWORD fdwEnum; 
	LPWAVEFILTER pwfltrEnum; 
	HINSTANCE hInstance; 
	LPCWSTR pszTemplateName; 
	LPARAM lCustData; 
	ACMFILTERCHOOSEHOOKPROCW pfnHook; 
} ACMFILTERCHOOSEW, *PACMFILTERCHOOSEW, *LPACMFILTERCHOOSEW;
#ifdef UNICODE
#define ACMFILTERCHOOSE ACMFILTERCHOOSEW
#define PACMFILTERCHOOSE PACMFILTERCHOOSEW
#define LPACMFILTERCHOOSE LPACMFILTERCHOOSEW
#else
#define ACMFILTERCHOOSE ACMFILTERCHOOSEA
#define PACMFILTERCHOOSE PACMFILTERCHOOSEA
#define LPACMFILTERCHOOSE LPACMFILTERCHOOSEA
#endif
#define ACMFILTERCHOOSE_STYLEF_SHOWHELP 0x00000004L
#define ACMFILTERCHOOSE_STYLEF_ENABLEHOOK 0x00000008L
#define ACMFILTERCHOOSE_STYLEF_ENABLETEMPLATE 0x00000010L
#define ACMFILTERCHOOSE_STYLEF_ENABLETEMPLATEHANDLE 0x00000020L
#define ACMFILTERCHOOSE_STYLEF_INITTOFILTERSTRUCT 0x00000040L
#define ACMFILTERCHOOSE_STYLEF_CONTEXTHELP 0x00000080L
MMRESULT ACMAPI acmFilterChooseA(LPACMFILTERCHOOSEA);
MMRESULT ACMAPI acmFilterChooseW(LPACMFILTERCHOOSEW);
#ifdef UNICODE
#define acmFilterChoose acmFilterChooseW
#else
#define acmFilterChoose acmFilterChooseA
#endif
typedef struct _ACMSTREAMHEADER {
	DWORD cbStruct; 
	DWORD fdwStatus; 
	DWORD dwUser; 
	LPBYTE pbSrc;
	DWORD cbSrcLength;
	DWORD cbSrcLengthUsed;
	DWORD dwSrcUser; 
	LPBYTE pbDst;
	DWORD cbDstLength;
	DWORD cbDstLengthUsed;
	DWORD dwDstUser; 
	DWORD dwReservedDriver[10]; 
} ACMSTREAMHEADER, *PACMSTREAMHEADER, *LPACMSTREAMHEADER;
#define ACMSTREAMHEADER_STATUSF_DONE 0x00010000L
#define ACMSTREAMHEADER_STATUSF_PREPARED 0x00020000L
#define ACMSTREAMHEADER_STATUSF_INQUEUE 0x00100000L
MMRESULT ACMAPI acmStreamOpen(LPHACMSTREAM,HACMDRIVER,LPWAVEFORMATEX,LPWAVEFORMATEX,LPWAVEFILTER,DWORD,DWORD,DWORD);
#define ACM_STREAMOPENF_QUERY 1
#define ACM_STREAMOPENF_ASYNC 2
#define ACM_STREAMOPENF_NONREALTIME 4
MMRESULT ACMAPI acmStreamClose(HACMSTREAM,DWORD);
MMRESULT ACMAPI acmStreamSize(HACMSTREAM,DWORD,LPDWORD,DWORD);
#define ACM_STREAMSIZEF_SOURCE 0
#define ACM_STREAMSIZEF_DESTINATION 1
#define ACM_STREAMSIZEF_QUERYMASK 0xF
MMRESULT ACMAPI acmStreamReset(HACMSTREAM,DWORD);
MMRESULT ACMAPI acmStreamMessage(HACMSTREAM,UINT,LPARAM,LPARAM );
MMRESULT ACMAPI acmStreamConvert(HACMSTREAM,LPACMSTREAMHEADER,DWORD);
#define ACM_STREAMCONVERTF_BLOCKALIGN 0x00000004
#define ACM_STREAMCONVERTF_START 0x00000010
#define ACM_STREAMCONVERTF_END 0x00000020
MMRESULT ACMAPI acmStreamPrepareHeader(HACMSTREAM,LPACMSTREAMHEADER,DWORD);
MMRESULT ACMAPI acmStreamUnprepareHeader(HACMSTREAM,LPACMSTREAMHEADER,DWORD);
#endif
