// Extended favorites and autolast favorites by Doug.
// Lets you set alternate favorites or extra favorites
// for current favorite keys. Also buys the last favorite
// you bought when you enter an inventory station.
// Heavily modified from Writer's OneTap Grenade script.
// --------
// This script is to allow you to set alternate favorite keys to what your current keys
// are set to. For instance my first favorite key buys me scout armor with an 
// Inteceptor Pack, I could set the alternate to be Scout armor with various weapons.
// --------
// To set an alternate favorite, simply hold the key you wish the alternate to be bound to
// for the time you set, to save frustration, hold it for double the time you set it for.
// Then simply buy/sell and click Mark Favorite, and your alternate favorite will be marked.
// Your alternate favorite will be marked to your favorite number + your total favorites.
// Meaning if you mark fav 2, and you have a total of 6, it will be saved to favorite 8.
// You can also do this if you aren't at an INV station, so you can set your next favorite to 
// bought.
// --------
// Set your variables below
// -----------------------------------------------------------------------------------------
// =========================================================================================
function ToggleFav()
{
	if ($togglefav == "on")
	{
		$togglefav = "off";
	Client::centerPrint("<f1>Autobuy Favorites <f0>Off\n<f2>", 1); 
    	schedule("Client::centerPrint(\"\", 1);", $textdelay);
	}
	else if ($togglefav == "off")
	{
		$togglefav = "on";
	Client::centerPrint("<f1>Autobuy Favorites <f0>On\n<f2>", 1); 
    	schedule("Client::centerPrint(\"\", 1);", $textdelay);
	}
}
function ToggleCleanSell()
{
	if ($togglecleansell == "on")
	{
		$togglecleansell = "off";
	Client::centerPrint("<f1>Automatically sell useless ammo <f0>Off\n<f2>", 1); 
    	schedule("Client::centerPrint(\"\", 1);", $textdelay);
	}
	else if ($togglecleansell == "off")
	{
		$togglecleansell = "on";
	Client::centerPrint("<f1>Automatically sell useless ammo <f0>On\n<f2>", 1); 
    	schedule("Client::centerPrint(\"\", 1);", $textdelay);
	}
}

$stationaccess = "off";

function extFav(%on, $favnum)
{
    	if(%on)
	{
   		 $WithinFavTapTime = 1;
                
   		 schedule("$WithinFavTapTime=0;", $delaytime);
   		 
	}
    	else if($WithinFavTapTime)
        {	
		if ($stationaccess == "on")
		{
    				if ($togglecleansell == "on")
    				{
    					schedule("CleanUpSell();",$cleandelay);
       					CmdInventoryGui::buyFavorites($favnum);
       					$last = $favnum;
    				}
    	    			else if ($togglecleansell == "off")
    				{
       					CmdInventoryGui::buyFavorites($favnum);
       					$last = $favnum;
    				}
		}
		else if ($stationaccess == "off")
		{
			$last = $favnum;
		}
        }
        else
        {
		if ($stationaccess == "on")
		{
		    		if ($togglecleansell == "on")
    				{
    					schedule("CleanUpSell();",$cleandelay);
       					CmdInventoryGui::buyFavorites($favnum + $totalfav);
       					$last = $favnum + $totalfav;
    				}
    	    			else if ($togglecleansell == "off")
    				{
       					CmdInventoryGui::buyFavorites($favnum + $totalfav);
       					$last = $favnum + $totalfav;
    				}
		}
		else if ($stationaccess == "off")
		{
			$last = $favnum + $totalfav;
		}

	}
}

function LastFav::parseForLastFav(%client, %msg)
{
	if(%client)
        return;
        
    if (String::findSubStr(%msg, "Station Access On") != -1)
    {
    	if ($togglefav == "on")
    	{
    		if ($togglecleansell == "on")
    		{
    			schedule("CleanUpSell();",$cleandelay);
       			CmdInventoryGui::buyFavorites($last);
    		}
    	    	else if ($togglecleansell == "off")
    		{
       			CmdInventoryGui::buyFavorites($last);
    		}
    		
    	}
    	else if ($togglefav == "off")
    	{
    		schedule("remoteEval(2048, playAnim, 11);",1.5);
    	}
    	$stationaccess = "on";
    }
    if (String::findSubStr(%msg, "Station Access Off") != -1)
    {
    	$stationaccess = "off";
    }
}
Event::Attach(eventClientMessage, LastFav::parseForLastFav);

// =========================================================================================
// extFav(1, 5); The 1 means you will activate it, 0 means deactivate.
// The 5 stands for what favorite you wish to bind. So extFav(1, 12); 
// would buy favorite # 12
// -----------------------------------------------------------------------------------------
EditActionMap("playMap.sae"); 
bindCommand(keyboard0, make, $favkey1, TO, "extFav(1, 1);");
bindCommand(keyboard0, break, $favkey1, TO, "extFav(0, 1);");
bindCommand(keyboard0, make, $favkey2, TO, "extFav(1, 2);");
bindCommand(keyboard0, break, $favkey2, TO, "extFav(0, 2);");
bindCommand(keyboard0, make, $favkey3, TO, "extFav(1, 3);");
bindCommand(keyboard0, break, $favkey3, TO, "extFav(0, 3);");
bindCommand(keyboard0, make, $favkey4, TO, "extFav(1, 4);");
bindCommand(keyboard0, break, $favkey4, TO, "extFav(0, 4);");
bindCommand(keyboard0, make, $favkey5, TO, "extFav(1, 5);");
bindCommand(keyboard0, break, $favkey5, TO, "extFav(0, 5);");
bindCommand(keyboard0, make, $favkey6, TO, "extFav(1, 6);");
bindCommand(keyboard0, break, $favkey6, TO, "extFav(0, 6);");
bindCommand(keyboard0, make, $togglekey, TO, "ToggleFav();");
bindCommand(keyboard0, make, $togglecleankey, TO, "ToggleCleanSell();");
