/***
*
*	Copyright (c) 1999, Valve LLC. All rights reserved.
*	
*	This product contains software technology licensed from Id 
*	Software, Inc. ("Id Technology").  Id Technology (c) 1996 Id Software, Inc. 
*	All Rights Reserved.
*
*   Use, distribution, and modification of this source code and/or resulting
*   object code is restricted to non-commercial enhancements to products from
*   Valve LLC.  All other use, distribution, or modification is prohibited
*   without written permission from Valve LLC.
*
****/
//
// teamplay_gamerules.h
//

#define MAX_TEAMNAME_LENGTH	16
#define MAX_TEAMS			32

#define TEAMPLAY_TEAMLISTLENGTH		MAX_TEAMS*MAX_TEAMNAME_LENGTH

#define HMCTF_TEAM1_NAME "Blue"
#define HMCTF_TEAM2_NAME "Red"

typedef enum {
	HMCTF_STATE_START,
	HMCTF_STATE_PLAYING
} hmctfstate_t;

#define HMCTF_FLAG_RESETTIME 30 //the time that a dropped flag lays in the world before respawning

#define HMCTF_CAPTUREPOINTS 15 //the ammount of frags the capturer gets
#define HMCTF_TEAMCAPTUREPOINTS 10 //the ammount of points his teammates get

class CHalfLifeHMCTF : public CHalfLifeMultiplay
{
public:
	CHalfLifeHMCTF();

	virtual BOOL ClientCommand( CBasePlayer *pPlayer, const char *pcmd );
	virtual void ClientUserInfoChanged( CBasePlayer *pPlayer, char *infobuffer );
	virtual BOOL IsTeamplay( void );
	virtual BOOL FPlayerCanTakeDamage( CBasePlayer *pPlayer, CBaseEntity *pAttacker );
	virtual int PlayerRelationship( CBaseEntity *pPlayer, CBaseEntity *pTarget );
	virtual const char *GetTeamID( CBaseEntity *pEntity );
	virtual BOOL ShouldAutoAim( CBasePlayer *pPlayer, edict_t *target );
	virtual int IPointsForKill( CBasePlayer *pAttacker, CBasePlayer *pKilled );
	virtual void InitHUD( CBasePlayer *pl );
	virtual void DeathNotice( CBasePlayer *pVictim, entvars_t *pKiller, entvars_t *pevInflictor );
	virtual const char *GetGameDescription( void ) { return "HL Teamplay"; }  // this is the game name that gets seen in the server browser
	virtual void UpdateGameMode( CBasePlayer *pPlayer );  // the client needs to be informed of the current game mode
	virtual void PlayerKilled( CBasePlayer *pVictim, entvars_t *pKiller, entvars_t *pInflictor );
	virtual void Think ( void );
	virtual int GetTeamIndex( const char *pTeamName );
	virtual const char *GetIndexedTeamName( int teamIndex );
	virtual BOOL IsValidTeam( const char *pTeamName );
	const char *SetDefaultPlayerTeam( CBasePlayer *pPlayer );
	virtual void ChangePlayerTeam( CBasePlayer *pPlayer, const char *pTeamName, BOOL bKill, BOOL bGib );
	virtual void JoinTeam(CBasePlayer *pPlayer, const char *pTeamName);
	
private:
	void RecountTeams( void );
	const char *TeamWithFewestPlayers( void );

	BOOL m_DisableDeathMessages;
	BOOL m_DisableDeathPenalty;
	BOOL m_teamLimit;				// This means the server set only some teams as valid
	char m_szTeamList[TEAMPLAY_TEAMLISTLENGTH];

	void ShowMenu (CBasePlayer *pPlayer, int bitsValidSlots, int nDisplayTime, BOOL fNeedMore, char *pszText);
};

//=========================================================
// Flags
//=========================================================
class CItemFlag : public CBaseEntity
{
public:
	void Spawn( void );

	BOOL Dropped;
	char pTeamName [1024];
	float NextReset;

private:
	void Precache ( void );
	void Capture(CBasePlayer *pPlayer, const char *pTeamName);
	void ResetFlag(const char *pTeamName);
	void Materialize( void );
	void FlagTouch( CBaseEntity *pOther );
	BOOL MyTouch( CBasePlayer *pPlayer );
	void Think( void );
};

//=========================================================
// Carried Flag
//=========================================================
class CCarriedFlag : public CBaseEntity
{
public:
	void Spawn( void );

	CBasePlayer *Owner;
	char pTeamName [1024];

private:
	void Precache ( void );
	void Think( void );
};
