/***
*
*	Copyright (c) 1999, Valve LLC. All rights reserved.
*	
*	This product contains software technology licensed from Id 
*	Software, Inc. ("Id Technology").  Id Technology (c) 1996 Id Software, Inc. 
*	All Rights Reserved.
*
*   Use, distribution, and modification of this source code and/or resulting
*   object code is restricted to non-commercial enhancements to products from
*   Valve LLC.  All other use, distribution, or modification is prohibited
*   without written permission from Valve LLC.
*
****/
//
// hmctf.cpp
//
// implementation of CHudHMCTFScores class
//

#include "hud.h"
#include "util.h"
#include <string.h>
#include <stdio.h>
#include "parsemsg.h"

DECLARE_MESSAGE(m_HMCTFScores, HMCTFScores )


int CHudHMCTFScores::Init(void)
{
	HOOK_MESSAGE( HMCTFScores );

	HMCTF_Team1_Captures = HMCTF_Team2_Captures = 0;
	m_Team1FlagStolen = m_Team2FlagStolen = 0;

	m_iFlags |= HUD_ACTIVE;
	gHUD.AddHudElem(this);

	return 1;
};

int CHudHMCTFScores::VidInit(void)
{
	m_hSprite_Team1Logo = 0;
	m_hSprite_Team2Logo = 0;

	return 1;
};

int CHudHMCTFScores::Draw(float fTime)
{
	if ( gHUD.m_iHideHUDDisplay & HIDEHUD_HEALTH )
		return 1;

	if (gHUD.m_iWeaponBits & (1<<(WEAPON_SUIT)))
	{
		if ( !m_hSprite_Team1Logo )
		{
			int HUD_logo_team1 = gHUD.GetSpriteIndex( "logo_team1" );
			m_hSprite_Team1Logo = gHUD.GetSprite(HUD_logo_team1);
		}
		if ( !m_hSprite_Team2Logo )
		{
			int HUD_logo_team2 = gHUD.GetSpriteIndex( "logo_team2" );
			m_hSprite_Team2Logo = gHUD.GetSprite(HUD_logo_team2);
		}

		int SPR_Team1Logo_Width = gHUD.GetSpriteRect(gHUD.GetSpriteIndex( "logo_team1" )).right - gHUD.GetSpriteRect(gHUD.GetSpriteIndex( "logo_team1" )).left;
		int SPR_Team1Logo_Height = gHUD.GetSpriteRect(gHUD.GetSpriteIndex( "logo_team1" )).bottom - gHUD.GetSpriteRect(gHUD.GetSpriteIndex( "logo_team1" )).top;
		int SPR_Team2Logo_Width = gHUD.GetSpriteRect(gHUD.GetSpriteIndex( "logo_team2" )).right - gHUD.GetSpriteRect(gHUD.GetSpriteIndex( "logo_team2" )).left;
		int SPR_Team2Logo_Height = gHUD.GetSpriteRect(gHUD.GetSpriteIndex( "logo_team2" )).bottom - gHUD.GetSpriteRect(gHUD.GetSpriteIndex( "logo_team2" )).top;

		int r, g, b, x, y;

		UnpackRGB(r,g,b, RGB_HMCTF_TEAM1);
		ScaleColors(r, g, b, 215);
		SPR_Set(m_hSprite_Team1Logo, r, g, b );

		y = (ScreenHeight - gHUD.m_iFontHeight - gHUD.m_iFontHeight / 2) - SPR_Team1Logo_Height - 3;
		x = ScreenWidth / 2;

		if (m_Team1FlagStolen == 0)
			SPR_DrawAdditive( 0,  x, y, &gHUD.GetSpriteRect(gHUD.GetSpriteIndex( "logo_team1" )));
		else
			FillRGBA( x, y, SPR_Team1Logo_Width, SPR_Team1Logo_Height, r, g, b, MIN_ALPHA);

		UnpackRGB(r,g,b, RGB_YELLOWISH);
		ScaleColors(r, g, b, MIN_ALPHA);
		if (HMCTF_Team1_Captures < 10)
			gHUD.DrawHudNumber(x + 1.2*SPR_Team1Logo_Width, y + 4, DHN_DRAWZERO | DHN_DRAWZERO, HMCTF_Team1_Captures, r, g, b);
		else if (10 >= HMCTF_Team1_Captures && HMCTF_Team1_Captures < 100)
			gHUD.DrawHudNumber(x + 1.2*SPR_Team1Logo_Width, y + 4, DHN_2DIGITS | DHN_DRAWZERO, HMCTF_Team1_Captures, r, g, b);
		else
			gHUD.DrawHudNumber(x + 1.2*SPR_Team1Logo_Width, y + 4, DHN_3DIGITS | DHN_DRAWZERO, HMCTF_Team1_Captures, r, g, b);

		//draw a yellow box around the sprites
		FillRGBA( x-2, y-2, 1, SPR_Team1Logo_Height+4, 255, 140, 0, MIN_ALPHA);
		FillRGBA( x-1, y-2, SPR_Team1Logo_Width+3, 1, 255, 140, 0, MIN_ALPHA);
		FillRGBA( x+SPR_Team1Logo_Width+2, y-2, 1, SPR_Team1Logo_Height+4, 255, 140, 0, MIN_ALPHA);
		FillRGBA( x-1, y+SPR_Team1Logo_Height+1, SPR_Team1Logo_Width+3, 1, 255, 140, 0, MIN_ALPHA);

		UnpackRGB(r,g,b, RGB_HMCTF_TEAM2);
		ScaleColors(r, g, b, 215);
		SPR_Set(m_hSprite_Team2Logo, r, g, b );

		// This should show up just under the previous one
		y = ScreenHeight - gHUD.m_iFontHeight - gHUD.m_iFontHeight / 2;
		x = ScreenWidth / 2;

		if (m_Team2FlagStolen == 0)
			SPR_DrawAdditive( 0,  x, y, &gHUD.GetSpriteRect(gHUD.GetSpriteIndex( "logo_team2" )));
		else
			FillRGBA( x, y, SPR_Team2Logo_Width, SPR_Team1Logo_Height, r, g, b, MIN_ALPHA);

		//draw a yellow box around the sprites
		FillRGBA( x-2, y-1, 1, SPR_Team2Logo_Height+3, 255, 140, 0, MIN_ALPHA);
		FillRGBA( x+SPR_Team2Logo_Width+2, y-1, 1, SPR_Team2Logo_Height+3, 255, 140, 0, MIN_ALPHA);
		FillRGBA( x-1, y+SPR_Team2Logo_Height+1, SPR_Team2Logo_Width+3, 1, 255, 140, 0, MIN_ALPHA);

		UnpackRGB(r,g,b, RGB_YELLOWISH);
		ScaleColors(r, g, b, MIN_ALPHA);
		if (HMCTF_Team2_Captures < 10)
			gHUD.DrawHudNumber(x + 1.2*SPR_Team2Logo_Width, y + 4, DHN_DRAWZERO | DHN_DRAWZERO, HMCTF_Team2_Captures, r, g, b);
		else if (10 >= HMCTF_Team2_Captures && HMCTF_Team2_Captures < 100)
			gHUD.DrawHudNumber(x + 1.2*SPR_Team2Logo_Width, y + 4, DHN_2DIGITS | DHN_DRAWZERO, HMCTF_Team2_Captures, r, g, b);
		else
			gHUD.DrawHudNumber(x + 1.2*SPR_Team2Logo_Width, y + 4, DHN_3DIGITS | DHN_DRAWZERO, HMCTF_Team2_Captures, r, g, b);

		return 1;
	}

	return 1;
}

// Message handler for HMCTFScores message
// accepts five values:
//		byte   : 0 = reset, 1 = update
//		byte   : team1 flag state
//		byte   : team2 flag state
//		long   : team1 capture count
//		long   : team2 capture count

int CHudHMCTFScores::MsgFunc_HMCTFScores(const char *pszName,  int iSize, void *pbuf)
{
	BEGIN_READ( pbuf, iSize );

	// Update HMCTFScores data
	int Cmd = READ_BYTE();

	switch (Cmd)
	{
	case 0:
		// Reset
		HMCTF_Team1_Captures = HMCTF_Team2_Captures = 0;
		m_Team1FlagStolen = m_Team2FlagStolen = 0;
		break;

	case 1:
		// Update
		m_Team1FlagStolen = READ_BYTE();
		m_Team2FlagStolen = READ_BYTE();
		HMCTF_Team1_Captures = READ_LONG();
		HMCTF_Team2_Captures = READ_LONG();
		break;
	}

	m_iFlags |= HUD_ACTIVE;

	return 1;
}