//===========================================================================
//
// Name:         script.c
// Function:     script examples
// Programmer:   Mr Elusive (MrElusive@demigod.demon.nl)
// Last update:  1999-02-10
// Tab Size:     3
//===========================================================================

/*

//===========================================================================
// ask the user for a folder, the "string" message will be displayed to the
// user, the retrieved folder can be accessed in the script using the folder
// label
//===========================================================================
AskFolder(folderlabel, "string");

//===========================================================================
// the "string" message is displayed to the user
//===========================================================================
Message("string");

//===========================================================================
// when this is found somewhere in the script WinBSPC will automatically
// close when all files are converted and/or extracted
//===========================================================================
Exit();

//===========================================================================
// execute the script with the given filename
//===========================================================================
Script("filename");

//===========================================================================
// convert a bsp file to a map file
//===========================================================================
bsp2map("pakfile":"bspfile", outputfoler)

//===========================================================================
// convert a bsp file to an aas file
//===========================================================================
bsp2aas("pakfile":"bspfile", outputfoler)

//===========================================================================
// extract files from a .pak or .sin file
//===========================================================================
extract("pakfile":"file", outputfolder)


//*/

//NOTE: usage of the scripted sequences below is NOT legal (read the legal
//      stuff in the winbspc.htm)
//      they are only listed here as script examples

Message("This script will extract all your Quake2 textures");
AskFolder(quake2folder, "Please enter your Quake2 folder");
AskFolder(outputfolder, "Please enter the folder to store the textures");
extract(quake2folder"baseq2\\pak?.pak":"*.wal", outputfolder);

Message("This script will convert all your Quake2 BSP files to MAP files");
AskFolder(quake2folder, "Please enter your Quake2 folder");
AskFolder(outputfolder, "Please enter the folder to store the MAP files");
bsp2map(quake2folder"baseq2\\pak?.pak":"maps/*.bsp", outputfolder);

Message("This script will convert all your Quake1 BSP files to MAP files");
AskFolder(quake1folder, "Please enter your Quake1 folder");
AskFolder(outputfolder, "Please enter the folder to store the MAP files");
bsp2map(quake1folder"id1\\pak?.pak":"maps/*.bsp", outputfolder);

Message("This script will convert all your Half-Life BSP files to MAP files");
AskFolder(halflifefolder, "Please enter your Half-Life folder");
AskFolder(outputfolder, "Please enter the folder to store the MAP files");
bsp2map(halflifefolder"valve\\pak0.pak":"maps/*.bsp", outputfolder);

Message("This script will convert all your Sin BSP files to MAP files");
AskFolder(sinfolder, "Please enter your Sin folder");
AskFolder(outputfolder, "Please enter the folder to store the MAP files");
bsp2map(sinfolder"base\\pak?.sin":"maps/*.bsp", outputfolder);

//*/

