/*
**  simple VECTOR class
**
**  (c) 1997, mike warren
**  mikeBot
**
**
*/


#include "vector.h"
#include <math.h>		// for sqrt()
#include <stdio.h>

//
//  scale : makes the vector x units in length
//
//  TODO : make me better?
//

void vector::scale( int a )
{
  normalize();
  (*this) *= (float) a;
}

//
//  makeFromPY : initializes the vector from the pitch, yaw passed
//

void vector::setFromPY( float p, float yy )
{
  float yaw = yy;
  float pitch = p;

  yaw += (float)180.0;
  yaw = (float)fmod( yaw, (float)360.0 );
  yaw = ((float)_PI/(float)180.0)*yaw;
  pitch = ((float)_PI/(float)180.0)*pitch;

  y = (float)sin( yaw );
  x = (float)cos( yaw );
  z = (float)0.0;

}


//
// print() to stdout
//

void vector::print()
{
  printf("(%f, %f, %f)", x, y, z);
}

//
//  operator + () : add two vectors
//

vector vector::operator + (vector & rhs)
{
  vector r;

  r.x = x+rhs.x;
  r.y = y+rhs.y;
  r.z = z+rhs.z;

  return r;
}

//
//  operator - () : substract *this from rhs
//

vector vector::operator - (vector & rhs)
{
  vector r;

  r.x = x - rhs.x;
  r.y = y - rhs.y;
  r.z = z - rhs.z;

  return r;
}

//
//  operator - () : negate vector
//


vector vector::operator - ( )
{
  return vector( -x, -y, -z );
}


//
//  operator * () : dot product
//

float vector::operator * (const vector & rhs)
{
  float r=(float)0;

  r += x * rhs.x;
  r += y * rhs.y;
  r += z * rhs.z;

  return r;
}


//
//  X() : return cross product of *this and rhs
//

vector vector::X( vector & rhs )
{
  vector r;

  r.x = (y * rhs.z) - (z * rhs.y);
  r.y = -((x * rhs.z) - (z * rhs.x));
  r.z = (x * rhs.y) - (y * rhs.x);

  return r;
}


//
// normalize() : normalized the current vector. no return value.
//

void vector::normalize()
{
  float length = this->length();

  x = x / length;
  y = y / length;
  z = z / length;
}

void vector::operator /= ( float n )
{
  if( n==0.0)
    return;
  x /= n;
  y /= n;
  z /= n;
}

void vector::operator += ( vector & v )
{
  x += v.x;
  y += v.y;
  z += v.z;
}

void vector::operator -= ( vector & v )
{
  x -= v.x;
  y -= v.y;
  z -= v.z;
}
  


//
// length() : duh
//

float vector::length()
{
  float length;
  length = x*x + y*y + z*z;
  length = (float)sqrt(length);
  return length;
}

float vector::length2()
{
  return x*x+y*y+z*z;
}

//
//  getYaw : returns yaw represented by vector. thanks to the terminator 
//	     code :)
//

float vector::getYaw()
{

  float yaw;
  int flipv=TRUE;
  int fliph=TRUE;
  float X=x,Y=y;

  if(Y<0) Y=-Y; else flipv=FALSE;
  if(X<0) X=-X; else fliph=FALSE;

  if(X<Y)        yaw = (float)_PI2 - (float)atan(X/Y);
  else if(X>0.0) yaw = (float)atan(Y/X);
  else           yaw = (float)0;
  if(fliph==TRUE) yaw = (float)_PI - yaw;
  if(flipv==TRUE) yaw = -yaw;
  yaw = (float)fmod(yaw, 2*(float)_PI);
  yaw = ((float)180/(float)_PI)*yaw;

	yaw += (float)180.0;
	yaw = (float)fmod( yaw, (float)360.0 );

  return yaw;

}

//
//  getPitch : returns the pitch represented by the vector. terminator again
//

float vector::getPitch()
{ 
  float tilt;
  int flipv=TRUE;
  float X=(float)sqrt(x*x+y*y);
  float Z=z;

  if(Z<0) Z=-Z; else flipv=FALSE;
  if(X<0) X=-X;
  if(X<Z)        tilt = (float)_PI2 - (float)atan(X/Z);
  else if(X>0.0) tilt = (float)atan(Z/X);
  else           tilt = (float)0;
  if(flipv==TRUE) tilt = -tilt;

  return ((float)180/(float)_PI) * tilt;

}

