/*
**
**  QCS handles client-server communication
**
**  (c) mike warren, 1997
**  mikeBot
**
**  ``send'' functions; sendDisconnect() <--- use qcs::disconnect() instead!!
**  sendMovement(), etc. not for human consumption
**
*/


#include "defines.h"
#include "qcs.h"
#include "vector.h"
#include <stdlib.h>
#include <math.h>


/*
**  send : sends an arbitrary packet; correctly waits for acks on reliable 
**
*/

int qcs::send( qpacket & qp )
{
   if( qp.getType() != qpacket::reliableEnd && 
     qp.getType() != qpacket::reliableFragment )
    {
      return qp.send( sock );
    }
  else
    {
	return ackQueue.addPacket( qp, sock );
    }

}

/*
**  sendKeepalive : sends a no op (unreliable) aka client to server keepalive
**
*/

int qcs::sendKeepalive()
{
#if QCS_SAFESEND
  if( !connected() )
    return 0;
#endif
	
  outPacket.reset();
  outPacket.addBEint( outgoingUnreliable++ );
  outPacket.addByte( CS_KEEPALIVE );
  outPacket.changeType( qpacket::unreliable );
  return send( outPacket );
}

/*
**  sendDisconnect : send a disconnect packet (unreliable)
**
*/

int qcs::sendDisconnect()
{

  if( !connected() )
    return 0;

  outPacket.reset();
  outPacket.addBEint( outgoingUnreliable++ );
  outPacket.addByte( CS_DISCONNECT );
  outPacket.changeType( qpacket::unreliable );
	
  return send ( outPacket );
}

/*
**  sendMovement : sends the current movement values 
**  ---> IN mbot
*/

int qcs::sendMovement()
{
  if( signonLevel < 3 )		// not connected
    return FALSE;

  printf("ERROR: qcs::sendMovement() not overriden\n");
  return FALSE;

}



/*
**  sendConsole : sends a console command. MAKE SURE THERE IS A NEWLINE AT THE
**  END!! (i think...;) )
**
*/

int qcs::sendConsole( char * st )
{
#if QCS_SAFESEND
  if( !connected() )
    {
      printf("qcs::sendConsole(): not connected\n");
      return 0;
    }
#endif

  outPacket.reset();
  outPacket.addBEint( outgoingReliable++ );
  outPacket.addByte( CS_CONSOLE );
  outPacket.addString( st );
  outPacket.changeType( qpacket::reliableEnd );
	
  return send ( outPacket );
}


