/*
**
**  MBNAV class 
**
**  (c) 1997, mike warren
**  mikeBot
**
**
**  handles navigation : has complete control over idealSpeeds, which are
**  changed to actual speeds after facing is determined (by mbfire). Also 
**  controls jumping. (unused, basically)
**
** TODO : pretty much everything :)
**
*/

#ifndef _MBNAV_H_
#define _MBNAV_H_

#include "mbfire.h"
#include "stack.h"

class mbnav : public mbfire
{
protected:

  vector mbn_facing;		// where nav system wants to go
  float mbn_velocity;		// target speed

  int mbn_jump;			// turned off after send

  float orbitAngle;		// for circle-strafe around players
  float roamAngle;
  float targetAngle;
  float deltaAngle;
  float wallDist;

  int roaming;			// bool
  int avoiding;			// bool
  int orbit;			// bool

  int mbn_oldTarget;		// previous target
  int mbn_targetLeaf;		// which leaf target is in
  vector mbn_targetOrigin;
  int mbn_wayTarget;
  int pathTarget;

  stack< int > * path;

  float targetTimestamp;
  float stoppedTimestamp;		// how long ago mikeBot stoped moving

  void jump() { if( mbn_jump == 10) mbn_jump = 9; }

  int aimAt( int );		// aims at an entity (sets mbn_facing)
  int aimAt( vector & );	// faces the point
  int aquireTarget( int );	// gets a new target

  void selectTarget();
  void bendFacing();		// bends to avoid lava, projectiles
				// can also play with mbn_velocity
  void roamFacing();		// runs around avoiding walls
  void adjustFacing();		// avoids walls (when targeting something)

public:

  mbnav();
  ~mbnav() { }
  
  void forceJump() { jump(); }
  void mbn_printTarget() { if( mbn_target != -1 ) printf("`%s'", modeltable[ entities[mbn_target].index ]); else printf("`none'"); }
  void dumpPath();


  void update();

};





#endif

