/*

**  packFile class : interface

**  (c) 1997 mike warren

**

**  this code is *not* freeware; please see the file ``README'' or 

**  contact mbwarren@acs.ucalgary.ca

**

**  opens and returns mFile objects from a .PAK file

**

*/







#ifndef _MPACK_H_

#define _MPACK_H_



#include "defines.h"

#include "mfile.h"

#include <string.h>


class packEntry

{

  char * filename;

  int offset;

  int size;



  packEntry(){}



public:

  

  packEntry( mFile & mf ) { filename=0; read( mf ); }

  ~packEntry(){ delete filename; }



  void read( mFile & mf ) { filename=(char *)mf.readChunk(0x38); offset=mf.readLEint(); size=mf.readLEint(); }



  const char * getFilename() { return filename; }

  int getOffset() { return offset; }

  int getSize() { return size; }



};



class packHeader

{

  int magic;

  int directoryOffset;

  int directorySize;



  packHeader(){};



public:



  packHeader( mFile & mf ) { read( mf ); }



  void read( mFile & mf ) { magic=mf.readLEint(); directoryOffset=mf.readLEint(); directorySize=mf.readLEint(); if( magic != 0x4b434150 ) printf("not pack file\n"); }



  int getOffset() { return directoryOffset; }

  int getSize() { return directorySize; }



};



class packFile

{

  int fd;			// file descriptor



  packHeader * ph;

  packEntry ** entries;

  int numDirEntries;



  packFile(){}



public:

  

  packFile( char * fname );

  ~packFile(){ delete ph; for( int i=0; i < numDirEntries; i++) delete entries[i]; delete entries; }



  mFile * getFile( char * );

  int getNum() { return numDirEntries; }



  void dumpDirectory(); 



};

  

#endif

