
/*
**
**  miscelasneous functions 
**
**  (c) 1997 mike warren
**  mikeBot
**
**
**
*/

#include "defines.h"
#include <ctype.h>
#include <stdio.h>
#include "qstruct.h"

/*
**  parseName : removes newlines and maps special characters to
**		"real" (i.e. ASCII < 128) ones for stoopid names.
**
*/

void parseName ( unsigned char * n )
{
  int i=0;
  while( n[ i ] )
    {
      n[i] = n[i] % 128;
      if( n[i] < 32 && n[i] > 0)
	n[i] = '_';
      i++;
    }
}

void parseString( char * n )
{
  for( int i=0; n[i]; i++ )
    {
      n[i] &= 0x7F;
      if( n[i] == '\n' )
	;
      else if ( n[i] == 1 )	// MBTALK depends on this
	;
      else if ( n[i] >= 18 && n[i] < 28 )
	n[i] += 30;
      else if( n[i] < 32 )
	n[i]='_';
    }
}

/*
**  printDefines : prints out which preprocessor #define's were active when
**		   compiling
**
*/

void printDefines()
{
#if UNIX
  printf("UNIX, ");
#endif
#if AIX
  printf("AIX, ");
#endif
#if WIN32
  printf("WIN32 (Windows 95), ");
#endif
#ifdef MIKEBOT
  printf("MIKEBOT, ");
#endif
#ifdef QBIG_ENDIAN
  printf("BIG-ENDIAN (Motorola), ");
#endif
#ifdef QLITTLE_ENDIAN
  printf("LITTLE-ENDIAN (Intel), ");
#endif
#if QTHROW
  printf("QTHROW, ");
#endif
#if QPROXY
  printf("QPROXY, ");
#endif

#if DEBUG
  printf("DEBUG : ");
#if DEBUG & DQP
  printf("qpacket ");
#endif
#if DEBUG & DQS
  printf("qsocket ");
#endif
#if DEBUG & DQCS
  printf("qcs ");
#endif
#if DEBUG & DQACK
  printf("qacknowledge ");
#endif
#if DEBUG & DMBF
  printf("mbfire ");
#endif
#if DEBUG & DMBN
  printf("mbnav ");
#endif
#if DEBUG & DMB
  printf("mbot ");
#endif
#if DEBUG & DQX
  printf("qproxy ");
#endif
#if DEBUG & MBM
  printf("mapping ");
#endif
#if DEBUG & MBT
  printf("mbtalk ");
#endif
#endif				// DEBUG

  printf("\n");

}
			
