/*
**
**  MBOTBASE for mbfire, mbears, mbtalk and others
**
**  (c) 1997 mike warren
**  mikeBot
**
**  TODO : sound stuff (isPlayerSound(), etc.)
**
*/

#ifndef _MBOTBASE_H_
#define _MBOTBASE_H_

#include "defines.h"
#include "qcs.h"
#include "graph.h"

class mbotbase : public qcs
{
protected:

  bspGraph map;

  int mbf_target;		// index entities[]; here for mbtalk so
  int mbn_target;		// he can tell people who he's targeting

  char flags[ QCS_MAX_ENTITIES ];
  char oldFlags[ QCS_MAX_ENTITIES ];

  int health, oldHealth;
  int armour, oldArmour;
  int cells, shells, rockets, nails;
  int weapons;			// bitmask; what weapons do i have? (and items)
  int weapon;			// current weapon

  int maxHate;
  int maxFrags;

  int lastDamage;		// playernumber

public:

  mbotbase() { init(); }
  ~mbotbase() { erase(); }

  void init();
  void erase();
  void reinit() { erase(); init(); qcs::reinit(); }


  int isVisible( int x ) { return (flags[x]&FLAG_VISIBLE); }
  int isDead( int x ) { return ((flags[x]&FLAG_DEAD)||modeltypes[entities[x].index]&ET_M_BODY); }
  int isPlayer( int x ) { return (x > 0 && x <= info.maxPlayers); }
  int isMe( int x ) { return (x == myEntityNumber); }
  int died( int x ) { return (!wasDead(x)&&isDead(x)); }
  int vanished( int x ) { return !(flags[x]&FLAG_VISIBLE)&&(oldFlags[x]&FLAG_VISIBLE); }

  int wasVisible( int x ) { return (oldFlags[x]&FLAG_VISIBLE); }
  int wasDead( int x ) { return ((oldFlags[x]&FLAG_DEAD)||modeltypes[entities[x].index]&ET_M_BODY); }

  int isWeapon( int x ) { return (modeltypes[entities[x].index]&ET_WEAPON); }

  int isLG( int x ) { return (modeltypes[entities[x].index]==ET_W_LG); }
  int isRL( int x ) { return (modeltypes[entities[x].index]==ET_W_RL); }
  int isNG( int x ) { return (modeltypes[entities[x].index]==ET_W_NG); }
  int isSNG( int x ) { return (modeltypes[entities[x].index]==ET_W_SNG); }
  int isSSG( int x ) { return (modeltypes[entities[x].index]==ET_W_SSG); }
  int haveLG() { return (weapons&W_LG); }
  int haveRL() { return (weapons&W_RL); }
  int haveNG() { return (weapons&W_NG); }
  int haveSNG() { return (weapons&W_SNG); }
  int haveSSG() { return (weapons&W_SSG); }

  int isShells( int x ) { return (modeltypes[entities[x].index]==ET_A_SHELLS); }
  int isCells( int x ) { return (modeltypes[entities[x].index]==ET_A_CELLS); }
  int isNails( int x ) { return (modeltypes[entities[x].index]==ET_A_NAILS); }
  int isRockets( int x ) { return (modeltypes[entities[x].index]==ET_A_ROCKETS); }
  int isArmour( int x ) { return (m_modeltypes[entities[x].index]==ET_ARMOR); }
  int isHealth( int x ) { return (m_modeltypes[entities[x].index]==ET_HEALTH); }
  int isAmmo( int x ) { return (m_modeltypes[entities[x].index]==ET_AMMO); }
  int isPowerup( int x ) { return (m_modeltypes[entities[x].index]==ET_ITEM); }
  int isProjectile( int x ) { return (m_modeltypes[entities[x].index]==ET_PROJECTILE); }
  int isBackpack( int x ) { return (modeltypes[entities[x].index]==ET_I_BACKPACK); }
  int isGrenade( int x ) { return (modeltypes[entities[x].index]==ET_P_GRENADE); }

  void increaseHate( int, int );

public:

				// overrides of QCS

  void timestampChanged( float );
  void entityUpdated( int );
  virtual void entityChanged( int x ) { printf("MBB:new entity %s\n", modeltable[entities[x].index] ); }
  void receivedDamage( int, vector & );
  void centerPrint( char * x ) { if( !opts.get("no-print-center")) printf(x); }

  void updateHealth( int x ) { oldHealth=health; health=x; }
  void updateArmour( int x ) { oldArmour=armour; armour=x; }
  void updateCells( int x ) { cells=x; }
  void updateShells( int x ) { shells=x;}
  void updateRockets( int x ) { rockets=x; }
  void updateNails( int x ) { nails=x; }
  void updateWeapon( int x ) { weapon=x; }
  void updateItems( int x ) { weapons=x; }

  void changedLevel( char * fname );
  void update() { qcs::update(); }

				// handy output functions

  void printPlayerEntities();
  void printVisibleEntities();
  void printAmmo() { printf(" %d%% %d%% %d %d %d %d [%08x] %d ", armour, health, shells, nails, rockets, cells, weapons, weapon ); 
		     if( haveLG() ) printf("LG ");
		     if( haveNG() ) printf("NG ");
		     if( haveSNG() ) printf("SNG ");
		     if( haveSSG() ) printf("SSG "); 
		     if( haveRL() ) printf("RL ");
		     printf("\n"); }

				// play with the options

  void set( char * x, int v ) { opts.set( x, v ); }
  int get( char * x ) { return opts.get( x ); }

};

#endif
