
#include <string.h>
#include <stdio.h>
#include "mbotbase.h"
#include <memory.h>		// memcpy()

/*
**  init/erase : initialize and delete stuff
**
*/

void mbotbase::init()
{
  for( int i=0; i < QCS_MAX_ENTITIES; i++ )
    {
      flags[i]=0; 
      oldFlags[i]=0;
    }
  health=oldHealth=0;
  armour=oldArmour=0;
  cells=shells=rockets=nails=0;
  weapons=0;
  weapon=0;
  lastDamage=-1;

  maxHate=0;
  maxFrags=0;

}

void mbotbase::erase()
{
}
  


/* 
**  changedLevel : overrides QCS; tries to load map
**
*/

void mbotbase::changedLevel( char * fname )
{ 

  if( opts.get( "send-greeting" ) )
     {
       sendConsole( "say "QCS_GREETING1"" );
       sendConsole( "say "QCS_GREETING2"" );
       sendConsole( "say "QCS_GREETING3"" );
     }

  if( !map.newMap( fname, opts.get( "no-graph" )) )
    {
      if( opts.get( "send-greeting" ) )
	sendConsole( "say level not loaded; i'm blind" );
    }
  else
    {
    }

}


/*
**  timestampChanged : invalidates flags
**
*/

void mbotbase::timestampChanged( float time )
{
  if( time < newTimestamp )
    {
#if DEBUG & DBASE
      printf("mbotbase::timestampChanged(): time %f, not %f\n", time,newTimestamp);
#endif
      return;
    }
  memcpy( oldFlags, flags, QCS_MAX_ENTITIES );
  memset( flags, 0, QCS_MAX_ENTITIES );
}

/*
**  entityUpdated : overrides QCS
**
*/

void mbotbase::entityUpdated( int x )
{
  flags[ x ] |= FLAG_VISIBLE;
  if( x >0 && x <= info.maxPlayers)
    if( entities[ x ].frame >= 48 && entities[ x ].frame < 103 )
      flags[ x ] |= FLAG_DEAD;
}



/*
**  printVisibleEntities
**
*/

void mbotbase::printVisibleEntities()
{
  for( int i=info.maxPlayers+1; i < QCS_MAX_ENTITIES; i++ )
    {
      if( isVisible( i ) )
	{
	  printf("'%s' : ", modeltable[ entities[ i ].index ] );
	  entities[ i ].origin.print();
//	  entities[ i ].velocity.print();
	  printf("[ %d ]", entities[i].rate );
	  printf(" : %f\n", entities[i].velocity.length() );
	}
    }
}
	     


/*
**  printPlayerEntities : prints first maxPlayers+2 entities
**
*/

void mbotbase::printPlayerEntities()
{
  int i=0;

  for( i=1; i <= info.maxPlayers; i++ )
    {
	if( isVisible( i ) )
	  printf("V");
	else
	  printf(".");
	if( isDead( i ) )
	  printf("D");
	else
	  printf(".");
	printf(" ");
	printf("%s : ", modeltable[ entities[ i ].index ] );
	printf("`%s' : ", players[ i-1 ].name );
//	entities[ i ].facing.print();
        entities[ i ].origin.print();
//	entities[ i ].velocity.print();
//	printf(" : %f ", entities[i].velocity.length() );
	printf(" %d", players[i-1].hate );
      printf("\n");
    }
}

/*
**  damage : tries to guess who hit me
**
*/

void mbotbase::receivedDamage( int amount, vector & origin )
{

  char temp[100];

  if( !opts.get( "no-print-damage" ) )
    {
      printf("Damage : %d from ", amount);
      origin.print();
     }

  float best=(float)100000.0;
  int bestIndex=0;
  float t;
  int i;

  for( i=1; i <= info.maxPlayers; i++ )
    {
      if( wasVisible( i ) && !isMe( i ) && !wasDead( i ) )
	{
	  t=(origin - entities[i].origin).length();
	  if( t < best )
	    {
	      best = t;
	      bestIndex=i;
	    }
	}
    }

  increaseHate( bestIndex-1, amount );

  maxHate=0;
  maxFrags=0;
  for( i=0; i < info.maxPlayers; i++ )
    {
      if( players[i].hate > maxHate )
	maxHate = players[i].hate;
      if( players[i].frags > maxFrags )
	maxFrags = players[i].frags;
    }

  if( !opts.get( "no-print-damage" ) )
    {
      if( bestIndex )
	printf(" `%s' %d\n", players[ bestIndex-1 ].name, players[bestIndex-1].hate );
      else
	printf(" no suspect\n");
    }

  if( bestIndex )
    {
      sprintf( temp, "damage from %s (%d)", players[ bestIndex-1 ].name, players[bestIndex-1 ].hate );
      lastDamage = bestIndex-1;
    }
  else
    sprintf( temp, "damage from `no suspect'" );

}


/*
** increaseHate : increases hate of platerNumber x. If x < 0, increases
**                everyones hate. If current hate of player x < 0, doesn't
**                touch it.
*/

void mbotbase::increaseHate( int x, int amt )
{
  int i;

  if( x < 0 )
    {
      for( i=0; i < info.maxPlayers; i++ )
	if( !isMe( i+1 ) )
	  if( players[i].hate >= 0 )
	    players[ i ].hate += amt;
    }
  else
    players[x].hate += amt;
}
      
      

