/***************************************************************************

    M.A.M.E.32  -  Multiple Arcade Machine Emulator for Win32
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
    
    This file is part of MAME32, and may only be used, modified and
    distributed under the terms of the MAME license, in "readme.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

#ifndef __JOYSTICK_H__
#define __JOYSTICK_H__

#include "osdepend.h"

struct OSDJoystick
{
    int         (*init)(options_type *options);
    void        (*exit)(void);
    void        (*poll_joysticks)(void);
    int         (*joy_pressed)(int joycode);
    const char* (*joy_name)(int joycode);
    void        (*analogjoy_read)(int player, int *analog_x, int *analog_y);
    int         (*standard_analog_read)(int player, int axis);

    BOOL        (*Available)(int nJoyStick);
    BOOL        (*OnMessage)(HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam, LRESULT* pResult);
};

extern struct OSDJoystick Joystick;

#endif
