/* Mame32 Jpeg routines */
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include "jpeglib.h"
#include <setjmp.h>
#include "osdepend.h"
#include "FilePrivate.h"

static int  copy_size = 0;
static char *pixel_ptr = 0;
static int  row = 0;
static int  effWidth;

BOOL AllocateBMP( struct jpeg_decompress_struct cinfo, HGLOBAL *phDIB, HPALETTE  *pPal );

void store_pixels(char *buf, int len)
{
#ifdef USING_STOCK_JPEGLIB
    /* BMP files store 24 bit color as BGR although the documentation
     * says otherwise, The stock JPEG lib stores RGB triplets in
     * RGB order so this translation is needed in order to properly
     * copy the data to a DIB buffer
     */
    int i = 0;
    char *ptr, tmp;

    ptr = buf;
    while(i < len)
    {
        tmp = *ptr & 0xFF;
        *ptr = ptr[2] & 0xFF;
        ptr[2] = tmp & 0xFF;
        ptr += 3;
        i += 3;
    }
#endif
    /* Using our supplied header files to compile the JPEG lib
     * no DIB translation of pixel data is needed.
     */
    if (pixel_ptr && copy_size)
    {
        memcpy(&pixel_ptr[row * effWidth], buf, len);
        row--;
        copy_size -= len;
    }
}


struct my_error_mgr {
    struct jpeg_error_mgr pub;	/* "public" fields */
    
    jmp_buf setjmp_buffer;	/* for return to caller */
};

typedef struct my_error_mgr * my_error_ptr;

/*
* Here's the routine that will replace the standard error_exit method:
*/

void my_error_exit (j_common_ptr cinfo)
{
    /* cinfo->err really points to a my_error_mgr struct, so coerce pointer */
    my_error_ptr myerr = (my_error_ptr) cinfo->err;
    
    /* Always display the message. */
    /* We could postpone this until after returning, if we chose. */
    (*cinfo->err->output_message) (cinfo);
    
    /* Return control to the setjmp point */
    longjmp(myerr->setjmp_buffer, 1);
}

void jpeg_zip_src (j_decompress_ptr cinfo, mame_file *mfp);

/* Read a JPEG a turn it into a DIB */
BOOL LoadJPEG (LPVOID mfile, HGLOBAL *phDIB, HPALETTE  *pPal )
{
    struct jpeg_decompress_struct cinfo;
    
    struct my_error_mgr jerr;
    JSAMPARRAY buffer;	/* Output row buffer */
    int row_stride;		/* physical row width in output buffer */
    mame_file *mfp = (mame_file *)mfile;

//    if ((mfp = osd_fopen(filename, "", OSD_FILETYPE_JPEG, 0)) == NULL)
//        return FALSE; 
    
    /* Step 1: allocate and initialize JPEG decompression object */
    
    /* We set up the normal JPEG error routines, then override error_exit. */
    cinfo.err = jpeg_std_error(&jerr.pub);
    jerr.pub.error_exit = my_error_exit;
    if (setjmp(jerr.setjmp_buffer)) {
    /* If we get here, the JPEG code has signaled an error.
     * We need to clean up the JPEG object, close the input file, and return.
     */
        jpeg_destroy_decompress(&cinfo);
        // osd_fclose(mfp);
        return 0;
    }
    /* Now we can initialize the JPEG decompression object. */
    jpeg_create_decompress(&cinfo);
    
    /* Step 2: specify data source (eg, a file) */
    
    if (mfp->access_type == ACCESS_ZIP)
        jpeg_zip_src(&cinfo, mfp);
    else
        jpeg_stdio_src( &cinfo, mfp->fptr);
    
    /* Step 3: read file parameters with jpeg_read_header() */
    
    (void) jpeg_read_header(&cinfo, TRUE);
    
    /* Step 4: set parameters for decompression */
    
    /* we don't need to change any of the defaults set by
    * jpeg_read_header(), so we do nothing here.
    */
    
    /* Step 5: Start decompressor */
    
    (void) jpeg_start_decompress(&cinfo);
    
    
    /* allocate space for a our Bitmap and
    * fill in a BITMAPINFOHEADER header.
    */
    AllocateBMP( cinfo, phDIB, pPal);
    
    /* JSAMPLEs per row in output buffer */
    row_stride = cinfo.output_width * cinfo.output_components;
    /* Make a one-row-high sample array that will go away when done with image */
    buffer = (*cinfo.mem->alloc_sarray)
        ((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);
    
    /* Step 6: while (scan lines remain to be read) */
    /*           jpeg_read_scanlines(...); */
    
    /* Here we use the library's state variable cinfo.output_scanline as the
    * loop counter, so that we don't have to keep track ourselves.
    */
    while (cinfo.output_scanline < cinfo.output_height)
    {
        /* jpeg_read_scanlines expects an array of pointers to scanlines. */
        (void) jpeg_read_scanlines(&cinfo, buffer, 1);
        /* Assume put_scanline_someplace wants a pointer and sample count. */
        store_pixels(buffer[0], row_stride);
    }
    
    /* Step 7: Finish decompression */
    
    (void) jpeg_finish_decompress(&cinfo);
    
    /* Step 8: Release JPEG decompression object */
    
    /* This is an important step since it will release a good deal of memory. */
    jpeg_destroy_decompress(&cinfo);
    
    /* After finish_decompress, we can close the input file. */
    // osd_fclose(mfp);
    
    /* And we're done! */
    return 1;
}


BOOL AllocateBMP( struct jpeg_decompress_struct cinfo, HGLOBAL *phDIB, HPALETTE  *pPal )
{
    int                 dibSize;
    HGLOBAL             hDIB;
    BITMAPINFOHEADER    bi;
    LPBITMAPINFOHEADER  lpbi;
    LPVOID              lpDIBBits = 0;
    int                 lineWidth = 0;

    copy_size = 0;
    pixel_ptr = 0;
    row       = cinfo.image_height - 1;
    lineWidth = cinfo.image_width;


    bi.biSize           = sizeof(BITMAPINFOHEADER); 
    bi.biWidth          = cinfo.image_width;
    bi.biHeight         = cinfo.image_height;
    bi.biPlanes         = 1; 
    bi.biBitCount       = 8 * cinfo.output_components; // 24

    bi.biCompression    = BI_RGB; 
    bi.biSizeImage      = 0; 
    bi.biXPelsPerMeter  = 0; 
    bi.biYPelsPerMeter  = 0; 
    bi.biClrUsed        = 0; // NumColors
    bi.biClrImportant   = 0; // NumColors

    effWidth = (long)(((long)lineWidth*bi.biBitCount + 31) / 32) * 4;

    dibSize = (effWidth * bi.biHeight) * cinfo.output_components;
    hDIB = GlobalAlloc(GMEM_FIXED, bi.biSize + dibSize);
    if (! hDIB)
    {
        return FALSE;
    }
    lpbi = (LPVOID)hDIB;
    memcpy(lpbi, &bi, sizeof(BITMAPINFOHEADER));
    lpDIBBits = (LPVOID)((LPSTR)lpbi + bi.biSize );

    // Create a halftone palette if colors > 256. 
    {
        HDC hDC = CreateCompatibleDC(0); // Desktop DC
        *pPal = CreateHalftonePalette( hDC );
        DeleteDC(hDC);
    }

    copy_size = dibSize;
    pixel_ptr = lpDIBBits;
    
    *phDIB = hDIB;
    return TRUE;
}


/* Custom JPEG IO source */
typedef struct {
    struct jpeg_source_mgr pub;
    mame_file *file;
} my_source_mgr;

typedef my_source_mgr *my_src_ptr;

void init_source (j_decompress_ptr cinfo)
{
    // my_src_ptr src = (my_src_ptr) cinfo->src;
    /* Do nothing ... */
   
}

boolean fill_input_buffer (j_decompress_ptr cinfo)
{
    //my_src_ptr src = (my_src_ptr) cinfo->src;
    /* We need to do nothing */
    return TRUE;
}

void skip_input_data (j_decompress_ptr cinfo, long num_bytes)
{
    my_src_ptr src = (my_src_ptr) cinfo->src;
    /* Move the input pointer forward */
    src->pub.next_input_byte += num_bytes;
}

void term_source (j_decompress_ptr cinfo)
{
    // my_src_ptr src = (my_src_ptr) cinfo->src;
    /* Do nothing ... */
}

/* Fill in our structure with all the needed functions and data */
void jpeg_zip_src (j_decompress_ptr cinfo, mame_file *mfp)
{
    my_src_ptr src;

    if (cinfo->src == NULL)
        cinfo->src = (struct jpeg_source_mgr *)
        (*cinfo->mem->alloc_small) ((j_common_ptr)cinfo, JPOOL_PERMANENT,
        sizeof(my_source_mgr));

    src = (my_src_ptr) cinfo->src;
    src->pub.init_source = init_source;
    src->pub.fill_input_buffer = fill_input_buffer;
    src->pub.skip_input_data = skip_input_data;
    src->pub.resync_to_restart = jpeg_resync_to_restart;
    src->pub.term_source = term_source;
    src->file = mfp;
    src->pub.bytes_in_buffer = mfp->file_length;
    src->pub.next_input_byte = mfp->file_data;
}

