\name{ImportImageFilter}
\alias{ImportImageFilter}
\title{ImportImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Compose a 2D or 3D image and return a smart pointer to a SimpleITK
image.
ImportImageFilter}
\details{
This filter is intended to interface SimpleITK to other image
processing libraries and applications that may have their own
representation of an image class. It creates a SimpleITK image which
shares the bulk data buffer as what is set. SimpleITK will not
responsible to delete the buffer afterwards, and it buffer must remain
valid while in use.
See:
ImportAsInt8, ImportAsUInt8, ImportAsInt16, ImportAsUInt16, ImportAsInt32, ImportAsUInt32, ImportAsInt64, ImportAsUInt64, ImportAsFloat, ImportAsDouble for the procedural interfaces.
ImportImageFilter}
%C++ includes: sitkImportImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute() override:}{
Set/Get The output PixelType of the image.
By default the value is sitkUnknown, which enable the output pixel
type to be same as the file. If the pixel type is specified then the itk::ConvertPixelBuffer will be used to convert the pixels.
}
\item{const std::vector< double > & GetDirection() const:}{}
\item{std::string GetName() const override:}{
return user readable name of the filter
}
\item{const std::vector< double > & GetOrigin() const:}{}
\item{const std::vector< unsigned int > & GetSize() const:}{}
\item{const std::vector< double > & GetSpacing() const:}{}
\item{ ImportImageFilter():}{}
\item{Self SetBufferAsDouble(double *buffer, unsigned int numberOfComponents=1):}{}
\item{Self SetBufferAsFloat(float *buffer, unsigned int numberOfComponents=1):}{}
\item{Self SetBufferAsInt16(int16_t *buffer, unsigned int numberOfComponents=1):}{}
\item{Self SetBufferAsInt32(int32_t *buffer, unsigned int numberOfComponents=1):}{}
\item{Self SetBufferAsInt64(int64_t *buffer, unsigned int numberOfComponents=1):}{}
\item{Self SetBufferAsInt8(int8_t *buffer, unsigned int numberOfComponents=1):}{}
\item{Self SetBufferAsUInt16(uint16_t *buffer, unsigned int numberOfComponents=1):}{}
\item{Self SetBufferAsUInt32(uint32_t *buffer, unsigned int numberOfComponents=1):}{}
\item{Self SetBufferAsUInt64(uint64_t *buffer, unsigned int numberOfComponents=1):}{}
\item{Self SetBufferAsUInt8(uint8_t *buffer, unsigned int numberOfComponents=1):}{}
\item{Self SetDirection(const std::vector< double > &direction):}{}
\item{Self SetOrigin(const std::vector< double > &origin):}{}
\item{Self SetSize(const std::vector< unsigned int > &size):}{}
\item{Self SetSpacing(const std::vector< double > &spacing):}{}
\item{std::string ToString() const override:}{
Print ourselves to string
}
\item{ ~ImportImageFilter() override:}{}
}
}
