/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jsampler.CC;
import org.jsampler.LSConsoleModel;
import org.jsampler.SamplerChannelModel;
import org.jsampler.Server;
import org.jsampler.event.SamplerChannelListEvent;
import org.jsampler.event.SamplerChannelListListener;
import org.jsampler.view.JSChannel;
import org.jsampler.view.JSChannelsPane;
import org.jsampler.view.JSViewConfig;
import org.jsampler.view.SessionViewConfig;

public abstract class JSMainFrame
extends JFrame {
    private final Vector<JSChannelsPane> chnPaneList = new Vector();
    private boolean autoUpdateChannelListUI = true;
    protected Vector<ListSelectionListener> channelsPaneListeners = new Vector();

    public JSMainFrame() {
        super("JSampler 0.9");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JSMainFrame.this.onWindowClose();
            }
        });
        CC.getSamplerModel().addSamplerChannelListListener(new EventHandler());
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(71, 3), "RunGarbageCollector");
        this.getRootPane().getActionMap().put("RunGarbageCollector", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.gc();
            }
        });
    }

    public void onWindowClose() {
        CC.cleanExit();
    }

    public abstract void installJSamplerHome();

    public abstract void showDetailedErrorMessage(Frame var1, String var2, String var3);

    public abstract void showDetailedErrorMessage(Dialog var1, String var2, String var3);

    public abstract void handleConnectionFailure();

    public void addChannelsPaneSelectionListener(ListSelectionListener listSelectionListener) {
        this.channelsPaneListeners.add(listSelectionListener);
    }

    public void removeChannelsPaneSelectionListener(ListSelectionListener listSelectionListener) {
        this.channelsPaneListeners.remove(listSelectionListener);
    }

    protected void fireChannelsPaneSelectionChanged() {
        int n = this.getChannelsPaneIndex(this.getSelectedChannelsPane());
        ListSelectionEvent listSelectionEvent = new ListSelectionEvent(this, n, n, false);
        for (ListSelectionListener listSelectionListener : this.channelsPaneListeners) {
            listSelectionListener.valueChanged(listSelectionEvent);
        }
    }

    public Vector<JSChannelsPane> getChannelsPaneList() {
        return this.chnPaneList;
    }

    public JSChannelsPane getChannelsPane(int n) {
        return this.chnPaneList.get(n);
    }

    public void addChannelsPane(JSChannelsPane jSChannelsPane) {
        this.chnPaneList.add(jSChannelsPane);
    }

    public boolean removeChannelsPane(JSChannelsPane jSChannelsPane) {
        return this.chnPaneList.remove(jSChannelsPane);
    }

    public int getChannelsPaneCount() {
        return this.chnPaneList.size();
    }

    public int getChannelsPaneIndex(JSChannelsPane jSChannelsPane) {
        return this.chnPaneList.indexOf(jSChannelsPane);
    }

    public abstract void insertChannelsPane(JSChannelsPane var1, int var2);

    public abstract JSChannelsPane getSelectedChannelsPane();

    public abstract Server getServer();

    public abstract Server getServer(boolean var1);

    public LSConsoleModel getLSConsoleModel() {
        return null;
    }

    public abstract void setSelectedChannelsPane(JSChannelsPane var1);

    public JSChannel findChannel(int n) {
        if (n < 0) {
            return null;
        }
        for (JSChannelsPane jSChannelsPane : this.getChannelsPaneList()) {
            for (JSChannel jSChannel : jSChannelsPane.getChannels()) {
                if (jSChannel.getChannelId() != n) continue;
                return jSChannel;
            }
        }
        return null;
    }

    public JSChannel removeChannel(int n) {
        if (n < 0) {
            return null;
        }
        for (JSChannelsPane jSChannelsPane : this.getChannelsPaneList()) {
            for (JSChannel jSChannel : jSChannelsPane.getChannels()) {
                if (jSChannel.getChannelId() != n) continue;
                jSChannelsPane.removeChannel(jSChannel);
                return jSChannel;
            }
        }
        return null;
    }

    public int getChannelNumber(SamplerChannelModel samplerChannelModel) {
        if (samplerChannelModel == null) {
            return -1;
        }
        for (int i = 0; i < this.getChannelsPaneCount(); ++i) {
            JSChannelsPane jSChannelsPane = this.getChannelsPane(i);
            for (int j = 0; j < jSChannelsPane.getChannelCount(); ++j) {
                if (jSChannelsPane.getChannel(j).getChannelId() != samplerChannelModel.getChannelId()) continue;
                return j;
            }
        }
        return -1;
    }

    public String getChannelPath(SamplerChannelModel samplerChannelModel) {
        if (samplerChannelModel == null) {
            return null;
        }
        for (int i = 0; i < this.getChannelsPaneCount(); ++i) {
            JSChannelsPane jSChannelsPane = this.getChannelsPane(i);
            for (int j = 0; j < jSChannelsPane.getChannelCount(); ++j) {
                if (jSChannelsPane.getChannel(j).getChannelId() != samplerChannelModel.getChannelId()) continue;
                return i + 1 + "." + (j + 1);
            }
        }
        return null;
    }

    public int getChannelsPaneNumber(SamplerChannelModel samplerChannelModel) {
        if (samplerChannelModel == null) {
            return -1;
        }
        for (int i = 0; i < this.getChannelsPaneCount(); ++i) {
            JSChannelsPane jSChannelsPane = this.getChannelsPane(i);
            for (int j = 0; j < jSChannelsPane.getChannelCount(); ++j) {
                if (jSChannelsPane.getChannel(j).getChannelId() != samplerChannelModel.getChannelId()) continue;
                return i;
            }
        }
        return -1;
    }

    public abstract void runScript(String var1);

    public boolean getAutoUpdateChannelListUI() {
        return this.autoUpdateChannelListUI;
    }

    public void setAutoUpdateChannelListUI(boolean bl) {
        if (bl == this.autoUpdateChannelListUI) {
            return;
        }
        this.autoUpdateChannelListUI = bl;
        for (JSChannelsPane jSChannelsPane : this.getChannelsPaneList()) {
            jSChannelsPane.setAutoUpdate(bl);
        }
    }

    public void updateChannelListUI() {
        for (JSChannelsPane jSChannelsPane : this.getChannelsPaneList()) {
            jSChannelsPane.updateChannelListUI();
        }
    }

    private class EventHandler
    implements SamplerChannelListListener {
        private EventHandler() {
        }

        @Override
        public void channelAdded(SamplerChannelListEvent samplerChannelListEvent) {
            if (samplerChannelListEvent.getChannelModel() == null) {
                return;
            }
            Integer n = samplerChannelListEvent.getChannelModel().getChannelId();
            if (JSMainFrame.this.findChannel(n) != null) {
                CC.getLogger().log(Level.WARNING, "JSMainFrame.channelExist!", n);
                return;
            }
            SessionViewConfig.ChannelConfig channelConfig = null;
            JSViewConfig jSViewConfig = CC.getViewConfig();
            if (jSViewConfig != null && jSViewConfig.getSessionViewConfig() != null) {
                channelConfig = jSViewConfig.getSessionViewConfig().pollChannelConfig();
            }
            if (channelConfig == null) {
                JSMainFrame.this.getSelectedChannelsPane().addChannel(samplerChannelListEvent.getChannelModel());
            } else {
                int n2 = channelConfig.channelsPanel;
                if (n2 >= 0 && n2 < JSMainFrame.this.getChannelsPaneCount()) {
                    JSMainFrame.this.getChannelsPane(n2).addChannel(samplerChannelListEvent.getChannelModel(), channelConfig);
                } else {
                    JSMainFrame.this.getSelectedChannelsPane().addChannel(samplerChannelListEvent.getChannelModel(), channelConfig);
                }
            }
        }

        @Override
        public void channelRemoved(SamplerChannelListEvent samplerChannelListEvent) {
            JSMainFrame.this.removeChannel(samplerChannelListEvent.getChannelModel().getChannelId());
        }
    }
}

