/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import java.util.Vector;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.AudioDeviceModel;
import org.jsampler.CC;
import org.jsampler.DefaultAudioDeviceModel;
import org.jsampler.DefaultMidiDeviceModel;
import org.jsampler.DefaultSamplerChannelModel;
import org.jsampler.MidiDeviceModel;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.SamplerChannelModel;
import org.jsampler.SamplerModel;
import org.jsampler.event.ListEvent;
import org.jsampler.event.ListListener;
import org.jsampler.event.MidiDeviceListEvent;
import org.jsampler.event.MidiDeviceListListener;
import org.jsampler.event.SamplerChannelListEvent;
import org.jsampler.event.SamplerChannelListListener;
import org.jsampler.event.SamplerEvent;
import org.jsampler.event.SamplerListener;
import org.jsampler.task.Audio;
import org.jsampler.task.Channel;
import org.jsampler.task.Global;
import org.jsampler.task.Midi;
import org.linuxsampler.lscp.AudioOutputDevice;
import org.linuxsampler.lscp.AudioOutputDriver;
import org.linuxsampler.lscp.MidiInputDevice;
import org.linuxsampler.lscp.MidiInputDriver;
import org.linuxsampler.lscp.MidiInstrumentInfo;
import org.linuxsampler.lscp.Parameter;
import org.linuxsampler.lscp.SamplerChannel;
import org.linuxsampler.lscp.SamplerEngine;
import org.linuxsampler.lscp.ServerInfo;

public class DefaultSamplerModel
implements SamplerModel {
    private ServerInfo serverInfo = null;
    private AudioOutputDriver[] aoDrvS = null;
    private MidiInputDriver[] miDrvS = null;
    private SamplerEngine[] engines = null;
    private int totalStreamCount = 0;
    private int totalVoiceCount = 0;
    private int totalVoiceCountMax = 0;
    private float volume = 1.0f;
    private MidiInstrumentMap defaultMidiInstrumentMap;
    private final Vector<SamplerChannelModel> channelModels = new Vector();
    private final Vector<AudioDeviceModel> audioDeviceModels = new Vector();
    private final Vector<MidiDeviceModel> midiDeviceModels = new Vector();
    private final Vector<MidiInstrumentMap> midiInstrMaps = new Vector();
    private final Vector<SamplerListener> listeners = new Vector();
    private final Vector<ListListener<MidiInstrumentMap>> mapsListeners = new Vector();
    private final EventListenerList listenerList = new EventListenerList();
    private boolean channelListIsAdjusting = false;
    private boolean modified = false;
    private final Handler handler = new Handler();

    public DefaultSamplerModel() {
        this.addMidiInstrumentMapListListener(this.getHandler());
    }

    @Override
    public void addSamplerListener(SamplerListener samplerListener) {
        this.listeners.add(samplerListener);
    }

    @Override
    public void removeSamplerListener(SamplerListener samplerListener) {
        this.listeners.remove(samplerListener);
    }

    @Override
    public void addAudioDeviceListListener(ListListener<AudioDeviceModel> listListener) {
        this.listenerList.add(ListListener.class, listListener);
    }

    @Override
    public void removeAudioDeviceListListener(ListListener<AudioDeviceModel> listListener) {
        this.listenerList.remove(ListListener.class, listListener);
    }

    @Override
    public void addMidiDeviceListListener(MidiDeviceListListener midiDeviceListListener) {
        this.listenerList.add(MidiDeviceListListener.class, midiDeviceListListener);
    }

    @Override
    public void removeMidiDeviceListListener(MidiDeviceListListener midiDeviceListListener) {
        this.listenerList.remove(MidiDeviceListListener.class, midiDeviceListListener);
    }

    @Override
    public void addMidiInstrumentMapListListener(ListListener<MidiInstrumentMap> listListener) {
        this.mapsListeners.add(listListener);
    }

    @Override
    public void removeMidiInstrumentMapListListener(ListListener<MidiInstrumentMap> listListener) {
        this.mapsListeners.remove(listListener);
    }

    @Override
    public void addSamplerChannelListListener(SamplerChannelListListener samplerChannelListListener) {
        this.listenerList.add(SamplerChannelListListener.class, samplerChannelListListener);
    }

    @Override
    public void removeSamplerChannelListListener(SamplerChannelListListener samplerChannelListListener) {
        this.listenerList.remove(SamplerChannelListListener.class, samplerChannelListListener);
    }

    @Override
    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public void setServerInfo(ServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    @Override
    public AudioOutputDriver[] getAudioOutputDrivers() {
        return this.aoDrvS;
    }

    public void setAudioOutputDrivers(AudioOutputDriver[] audioOutputDriverArray) {
        this.aoDrvS = audioOutputDriverArray;
    }

    @Override
    public AudioDeviceModel getAudioDevice(int n) {
        return this.audioDeviceModels.get(n);
    }

    @Override
    public AudioDeviceModel getAudioDeviceById(int n) {
        for (AudioDeviceModel audioDeviceModel : this.audioDeviceModels) {
            if (audioDeviceModel.getDeviceId() != n) continue;
            return audioDeviceModel;
        }
        return null;
    }

    @Override
    public int getAudioDeviceCount() {
        return this.audioDeviceModels.size();
    }

    @Override
    public AudioDeviceModel[] getAudioDevices() {
        return this.audioDeviceModels.toArray(new AudioDeviceModel[this.audioDeviceModels.size()]);
    }

    @Override
    public void addAudioDevice(AudioOutputDevice audioOutputDevice) {
        DefaultAudioDeviceModel defaultAudioDeviceModel = new DefaultAudioDeviceModel(audioOutputDevice);
        this.audioDeviceModels.add(defaultAudioDeviceModel);
        this.fireAudioDeviceAdded(defaultAudioDeviceModel);
    }

    @Override
    public boolean removeAudioDeviceById(int n) {
        for (int i = 0; i < this.audioDeviceModels.size(); ++i) {
            AudioDeviceModel audioDeviceModel = this.audioDeviceModels.get(i);
            if (audioDeviceModel.getDeviceId() != n) continue;
            this.audioDeviceModels.remove(i);
            this.fireAudioDeviceRemoved(audioDeviceModel);
            return true;
        }
        return false;
    }

    @Override
    public void removeBackendAudioDevice(int n) {
        CC.getTaskQueue().add(new Audio.DestroyDevice(n));
    }

    @Override
    public MidiInputDriver[] getMidiInputDrivers() {
        return this.miDrvS;
    }

    public void setMidiInputDrivers(MidiInputDriver[] midiInputDriverArray) {
        this.miDrvS = midiInputDriverArray;
    }

    @Override
    public MidiDeviceModel getMidiDevice(int n) {
        return this.midiDeviceModels.get(n);
    }

    @Override
    public MidiDeviceModel getMidiDeviceById(int n) {
        for (MidiDeviceModel midiDeviceModel : this.midiDeviceModels) {
            if (midiDeviceModel.getDeviceId() != n) continue;
            return midiDeviceModel;
        }
        return null;
    }

    @Override
    public int getMidiDeviceCount() {
        return this.midiDeviceModels.size();
    }

    @Override
    public MidiDeviceModel[] getMidiDevices() {
        return this.midiDeviceModels.toArray(new MidiDeviceModel[this.midiDeviceModels.size()]);
    }

    @Override
    public void addMidiDevice(MidiInputDevice midiInputDevice) {
        DefaultMidiDeviceModel defaultMidiDeviceModel = new DefaultMidiDeviceModel(midiInputDevice);
        this.midiDeviceModels.add(defaultMidiDeviceModel);
        this.fireMidiDeviceAdded(defaultMidiDeviceModel);
    }

    @Override
    public void addBackendMidiDevice(String string, Parameter ... parameterArray) {
        CC.getTaskQueue().add(new Midi.CreateDevice(string, parameterArray));
    }

    @Override
    public boolean removeMidiDeviceById(int n) {
        for (int i = 0; i < this.midiDeviceModels.size(); ++i) {
            MidiDeviceModel midiDeviceModel = this.midiDeviceModels.get(i);
            if (midiDeviceModel.getDeviceId() != n) continue;
            this.midiDeviceModels.remove(i);
            this.fireMidiDeviceRemoved(midiDeviceModel);
            return true;
        }
        return false;
    }

    @Override
    public void removeBackendMidiDevice(int n) {
        CC.getTaskQueue().add(new Midi.DestroyDevice(n));
    }

    @Override
    public MidiInstrumentMap getMidiInstrumentMapById(int n) {
        for (MidiInstrumentMap midiInstrumentMap : this.midiInstrMaps) {
            if (midiInstrumentMap.getMapId() != n) continue;
            return midiInstrumentMap;
        }
        return null;
    }

    @Override
    public MidiInstrumentMap getMidiInstrumentMap(int n) {
        return this.midiInstrMaps.get(n);
    }

    @Override
    public int getMidiInstrumentMapCount() {
        return this.midiInstrMaps.size();
    }

    @Override
    public MidiInstrumentMap[] getMidiInstrumentMaps() {
        return this.midiInstrMaps.toArray(new MidiInstrumentMap[this.midiInstrMaps.size()]);
    }

    @Override
    public int getMidiInstrumentMapIndex(MidiInstrumentMap midiInstrumentMap) {
        if (midiInstrumentMap == null) {
            return -1;
        }
        for (int i = 0; i < this.getMidiInstrumentMapCount(); ++i) {
            if (this.getMidiInstrumentMap(i) != midiInstrumentMap) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addMidiInstrumentMap(MidiInstrumentMap midiInstrumentMap) {
        if (midiInstrumentMap == null) {
            throw new IllegalArgumentException("map should be non-null!");
        }
        this.midiInstrMaps.add(midiInstrumentMap);
        this.fireMidiInstrumentMapAdded(midiInstrumentMap);
    }

    @Override
    public void addBackendMidiInstrumentMap(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name should be non-null!");
        }
        CC.getTaskQueue().add(new Midi.AddInstrumentMap(string));
    }

    @Override
    public boolean removeMidiInstrumentMapById(int n) {
        for (int i = 0; i < this.midiInstrMaps.size(); ++i) {
            MidiInstrumentMap midiInstrumentMap = this.getMidiInstrumentMap(i);
            if (midiInstrumentMap.getMapId() != n) continue;
            this.midiInstrMaps.remove(i);
            this.fireMidiInstrumentMapRemoved(midiInstrumentMap);
            return true;
        }
        return false;
    }

    public boolean removeMidiInstrumentMap(MidiInstrumentMap midiInstrumentMap) {
        boolean bl = this.midiInstrMaps.removeElement(midiInstrumentMap);
        if (bl) {
            this.fireMidiInstrumentMapRemoved(midiInstrumentMap);
        }
        return bl;
    }

    @Override
    public void removeAllMidiInstrumentMaps() {
        for (int i = this.midiInstrMaps.size() - 1; i >= 0; --i) {
            MidiInstrumentMap midiInstrumentMap = this.midiInstrMaps.get(i);
            this.midiInstrMaps.removeElementAt(i);
            this.fireMidiInstrumentMapRemoved(midiInstrumentMap);
        }
    }

    @Override
    public void removeBackendMidiInstrumentMap(int n) {
        CC.getTaskQueue().add(new Midi.RemoveInstrumentMap(n));
    }

    @Override
    public void setBackendMidiInstrumentMapName(final int n, String string) {
        final Midi.SetInstrumentMapInfo setInstrumentMapInfo = new Midi.SetInstrumentMapInfo(n, string);
        setInstrumentMapInfo.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (setInstrumentMapInfo.doneWithErrors()) {
                    Midi.UpdateInstrumentMapInfo updateInstrumentMapInfo = new Midi.UpdateInstrumentMapInfo(n);
                    CC.getTaskQueue().add(updateInstrumentMapInfo);
                }
            }
        });
        CC.getTaskQueue().add(setInstrumentMapInfo);
    }

    @Override
    public MidiInstrumentMap getDefaultMidiInstrumentMap() {
        return this.defaultMidiInstrumentMap;
    }

    private MidiInstrumentMap findDefaultMidiInstrumentMap() {
        for (int i = 0; i < this.getMidiInstrumentMapCount(); ++i) {
            MidiInstrumentMap midiInstrumentMap = this.getMidiInstrumentMap(i);
            if (!midiInstrumentMap.getInfo().isDefault()) continue;
            return midiInstrumentMap;
        }
        return null;
    }

    @Override
    public void mapBackendMidiInstrument(int n, int n2, int n3, MidiInstrumentInfo midiInstrumentInfo) {
        CC.getTaskQueue().add(new Midi.MapInstrument(n, n2, n3, midiInstrumentInfo));
    }

    @Override
    public void unmapBackendMidiInstrument(int n, int n2, int n3) {
        CC.getTaskQueue().add(new Midi.UnmapInstrument(n, n2, n3));
    }

    @Override
    public SamplerEngine[] getEngines() {
        return this.engines;
    }

    public void setEngines(SamplerEngine[] samplerEngineArray) {
        this.engines = samplerEngineArray;
    }

    @Override
    public SamplerChannelModel getChannel(int n) {
        return this.channelModels.get(n);
    }

    @Override
    public SamplerChannelModel getChannelById(int n) {
        for (SamplerChannelModel samplerChannelModel : this.channelModels) {
            if (samplerChannelModel.getChannelId() != n) continue;
            return samplerChannelModel;
        }
        return null;
    }

    @Override
    public int getChannelIndex(SamplerChannelModel samplerChannelModel) {
        if (samplerChannelModel == null) {
            return -1;
        }
        for (int i = 0; i < this.channelModels.size(); ++i) {
            if (this.channelModels.get(i).getChannelId() != samplerChannelModel.getChannelId()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getChannelCount() {
        return this.channelModels.size();
    }

    @Override
    public SamplerChannelModel[] getChannels() {
        return this.channelModels.toArray(new SamplerChannelModel[this.channelModels.size()]);
    }

    @Override
    public void addBackendChannel() {
        CC.getTaskQueue().add(new Channel.Add());
    }

    @Override
    public void addChannel(SamplerChannel samplerChannel) {
        DefaultSamplerChannelModel defaultSamplerChannelModel;
        DefaultSamplerChannelModel defaultSamplerChannelModel2 = defaultSamplerChannelModel = samplerChannel == null ? null : new DefaultSamplerChannelModel(samplerChannel);
        if (defaultSamplerChannelModel != null) {
            this.channelModels.add(defaultSamplerChannelModel);
        }
        this.fireSamplerChannelAdded(defaultSamplerChannelModel);
    }

    @Override
    public void updateChannel(SamplerChannel samplerChannel) {
        for (SamplerChannelModel samplerChannelModel : this.channelModels) {
            if (samplerChannelModel.getChannelId() != samplerChannel.getChannelId()) continue;
            samplerChannelModel.setChannelInfo(samplerChannel);
            return;
        }
        CC.getLogger().log(Level.WARNING, "DefaultSamplerModel.unknownChannel!", samplerChannel.getChannelId());
    }

    @Override
    public synchronized boolean getChannelListIsAdjusting() {
        return this.channelListIsAdjusting;
    }

    @Override
    public synchronized void setChannelListIsAdjusting(boolean bl) {
        this.channelListIsAdjusting = bl;
    }

    @Override
    public boolean removeChannelById(int n) {
        for (int i = 0; i < this.channelModels.size(); ++i) {
            SamplerChannelModel samplerChannelModel = this.channelModels.get(i);
            if (samplerChannelModel.getChannelId() != n) continue;
            this.channelModels.remove(i);
            this.fireSamplerChannelRemoved(samplerChannelModel);
            return true;
        }
        return false;
    }

    @Override
    public void removeAllChannels() {
        if (this.channelModels.size() == 0) {
            return;
        }
        this.setChannelListIsAdjusting(true);
        for (int i = this.channelModels.size() - 1; i > 0; --i) {
            SamplerChannelModel samplerChannelModel = this.channelModels.get(i);
            this.channelModels.remove(i);
            this.fireSamplerChannelRemoved(samplerChannelModel);
        }
        this.setChannelListIsAdjusting(false);
        SamplerChannelModel samplerChannelModel = this.channelModels.get(0);
        this.channelModels.remove(0);
        this.fireSamplerChannelRemoved(samplerChannelModel);
    }

    @Override
    public void removeBackendChannel(int n) {
        CC.getTaskQueue().add(new Channel.Remove(n));
    }

    @Override
    public void editBackendInstrument(int n) {
        CC.getTaskQueue().add(new Channel.EditInstrument(n));
    }

    @Override
    public boolean hasSoloChannel() {
        for (SamplerChannelModel samplerChannelModel : this.channelModels) {
            if (!samplerChannelModel.getChannelInfo().isSoloChannel()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getSoloChannelCount() {
        int n = 0;
        for (SamplerChannelModel samplerChannelModel : this.channelModels) {
            if (!samplerChannelModel.getChannelInfo().isSoloChannel()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getMutedChannelCount() {
        int n = 0;
        for (SamplerChannelModel samplerChannelModel : this.channelModels) {
            if (!samplerChannelModel.getChannelInfo().isMuted()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getMutedBySoloChannelCount() {
        int n = 0;
        for (SamplerChannelModel samplerChannelModel : this.channelModels) {
            if (!samplerChannelModel.getChannelInfo().isMutedBySolo()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getTotalStreamCount() {
        return this.totalStreamCount;
    }

    @Override
    public int getTotalVoiceCount() {
        return this.totalVoiceCount;
    }

    @Override
    public int getTotalVoiceCountMax() {
        return this.totalVoiceCountMax;
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public void setVolume(float f) {
        if (this.volume == f) {
            return;
        }
        this.volume = f;
        this.fireVolumeChanged();
    }

    @Override
    public void setBackendVolume(float f) {
        CC.getTaskQueue().add(new Global.SetVolume(f));
    }

    @Override
    public void resetBackend() {
        CC.getTaskQueue().add(new Global.ResetSampler());
    }

    @Override
    public void updateActiveStreamsInfo(int n) {
        if (this.totalStreamCount == n) {
            return;
        }
        this.totalStreamCount = n;
        this.fireTotalStreamCountChanged();
    }

    @Override
    public void updateActiveVoiceInfo(int n, int n2) {
        if (this.totalVoiceCount == n && this.totalVoiceCountMax == n2) {
            return;
        }
        this.totalVoiceCount = n;
        this.totalVoiceCountMax = n2;
        this.fireTotalVoiceCountChanged();
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void setModified(boolean bl) {
        this.modified = bl;
    }

    @Override
    public void reset() {
        Object object;
        int n;
        this.removeAllMidiInstrumentMaps();
        for (n = this.channelModels.size() - 1; n >= 0; --n) {
            object = this.channelModels.get(n);
            this.channelModels.remove(n);
            this.fireSamplerChannelRemoved((SamplerChannelModel)object);
        }
        for (n = this.midiDeviceModels.size() - 1; n >= 0; --n) {
            object = this.midiDeviceModels.get(n);
            this.midiDeviceModels.remove(n);
            this.fireMidiDeviceRemoved((MidiDeviceModel)object);
        }
        for (n = this.audioDeviceModels.size() - 1; n >= 0; --n) {
            object = this.audioDeviceModels.get(n);
            this.audioDeviceModels.remove(n);
            this.fireAudioDeviceRemoved((AudioDeviceModel)object);
        }
        this.setServerInfo(null);
        this.setAudioOutputDrivers(null);
        this.setMidiInputDrivers(null);
        this.setEngines(null);
        this.setVolume(0.0f);
        this.setModified(false);
        this.totalStreamCount = 0;
        this.totalVoiceCount = 0;
        this.totalVoiceCountMax = 0;
        this.fireTotalStreamCountChanged();
        this.fireTotalVoiceCountChanged();
        this.fireDefaultMapChanged();
    }

    private void fireSamplerChannelAdded(SamplerChannelModel samplerChannelModel) {
        final SamplerChannelListEvent samplerChannelListEvent = new SamplerChannelListEvent(this, samplerChannelModel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSamplerModel.this.fireSamplerChannelAdded(samplerChannelListEvent);
            }
        });
    }

    private void fireSamplerChannelAdded(SamplerChannelListEvent samplerChannelListEvent) {
        this.setModified(true);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SamplerChannelListListener.class) continue;
            ((SamplerChannelListListener)objectArray[i + 1]).channelAdded(samplerChannelListEvent);
        }
    }

    private void fireSamplerChannelRemoved(SamplerChannelModel samplerChannelModel) {
        final SamplerChannelListEvent samplerChannelListEvent = new SamplerChannelListEvent(this, samplerChannelModel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSamplerModel.this.fireSamplerChannelRemoved(samplerChannelListEvent);
            }
        });
    }

    private void fireSamplerChannelRemoved(SamplerChannelListEvent samplerChannelListEvent) {
        this.setModified(true);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != SamplerChannelListListener.class) continue;
            ((SamplerChannelListListener)objectArray[i + 1]).channelRemoved(samplerChannelListEvent);
        }
    }

    private void fireMidiDeviceAdded(MidiDeviceModel midiDeviceModel) {
        final MidiDeviceListEvent midiDeviceListEvent = new MidiDeviceListEvent(this, midiDeviceModel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSamplerModel.this.fireMidiDeviceAdded(midiDeviceListEvent);
            }
        });
    }

    private void fireMidiDeviceAdded(MidiDeviceListEvent midiDeviceListEvent) {
        this.setModified(true);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MidiDeviceListListener.class) continue;
            ((MidiDeviceListListener)objectArray[i + 1]).deviceAdded(midiDeviceListEvent);
        }
    }

    private void fireMidiDeviceRemoved(MidiDeviceModel midiDeviceModel) {
        final MidiDeviceListEvent midiDeviceListEvent = new MidiDeviceListEvent(this, midiDeviceModel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSamplerModel.this.fireMidiDeviceRemoved(midiDeviceListEvent);
            }
        });
    }

    private void fireMidiDeviceRemoved(MidiDeviceListEvent midiDeviceListEvent) {
        this.setModified(true);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != MidiDeviceListListener.class) continue;
            ((MidiDeviceListListener)objectArray[i + 1]).deviceRemoved(midiDeviceListEvent);
        }
    }

    private void fireAudioDeviceAdded(AudioDeviceModel audioDeviceModel) {
        final ListEvent<AudioDeviceModel> listEvent = new ListEvent<AudioDeviceModel>(this, audioDeviceModel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSamplerModel.this.fireAudioDeviceAdded(listEvent);
            }
        });
    }

    private void fireAudioDeviceAdded(ListEvent<AudioDeviceModel> listEvent) {
        this.setModified(true);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListListener.class) continue;
            ((ListListener)objectArray[i + 1]).entryAdded(listEvent);
        }
    }

    private void fireAudioDeviceRemoved(AudioDeviceModel audioDeviceModel) {
        final ListEvent<AudioDeviceModel> listEvent = new ListEvent<AudioDeviceModel>(this, audioDeviceModel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSamplerModel.this.fireAudioDeviceRemoved(listEvent);
            }
        });
    }

    private void fireAudioDeviceRemoved(ListEvent<AudioDeviceModel> listEvent) {
        this.setModified(true);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ListListener.class) continue;
            ((ListListener)objectArray[i + 1]).entryRemoved(listEvent);
        }
    }

    private void fireMidiInstrumentMapAdded(MidiInstrumentMap midiInstrumentMap) {
        final ListEvent<MidiInstrumentMap> listEvent = new ListEvent<MidiInstrumentMap>(this, midiInstrumentMap);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSamplerModel.this.fireMidiInstrumentMapAdded(listEvent);
            }
        });
    }

    private void fireMidiInstrumentMapAdded(ListEvent<MidiInstrumentMap> listEvent) {
        this.setModified(true);
        for (ListListener<MidiInstrumentMap> listListener : this.mapsListeners) {
            listListener.entryAdded(listEvent);
        }
    }

    private void fireMidiInstrumentMapRemoved(MidiInstrumentMap midiInstrumentMap) {
        final ListEvent<MidiInstrumentMap> listEvent = new ListEvent<MidiInstrumentMap>(this, midiInstrumentMap);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSamplerModel.this.fireMidiInstrumentMapRemoved(listEvent);
            }
        });
    }

    private void fireMidiInstrumentMapRemoved(ListEvent<MidiInstrumentMap> listEvent) {
        this.setModified(true);
        for (ListListener<MidiInstrumentMap> listListener : this.mapsListeners) {
            listListener.entryRemoved(listEvent);
        }
    }

    private void fireVolumeChanged() {
        final SamplerEvent samplerEvent = new SamplerEvent(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSamplerModel.this.fireVolumeChanged(samplerEvent);
            }
        });
    }

    private void fireVolumeChanged(SamplerEvent samplerEvent) {
        this.setModified(true);
        for (SamplerListener samplerListener : this.listeners) {
            samplerListener.volumeChanged(samplerEvent);
        }
    }

    private void fireTotalStreamCountChanged() {
        final SamplerEvent samplerEvent = new SamplerEvent(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSamplerModel.this.fireTotalStreamCountChanged(samplerEvent);
            }
        });
    }

    private void fireTotalStreamCountChanged(SamplerEvent samplerEvent) {
        for (SamplerListener samplerListener : this.listeners) {
            samplerListener.totalStreamCountChanged(samplerEvent);
        }
    }

    private void fireTotalVoiceCountChanged() {
        final SamplerEvent samplerEvent = new SamplerEvent(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSamplerModel.this.fireTotalVoiceCountChanged(samplerEvent);
            }
        });
    }

    private void fireTotalVoiceCountChanged(SamplerEvent samplerEvent) {
        for (SamplerListener samplerListener : this.listeners) {
            samplerListener.totalVoiceCountChanged(samplerEvent);
        }
    }

    private void fireDefaultMapChanged() {
        SamplerEvent samplerEvent = new SamplerEvent(this);
        for (SamplerListener samplerListener : this.listeners) {
            samplerListener.defaultMapChanged(samplerEvent);
        }
    }

    private Handler getHandler() {
        return this.handler;
    }

    private class Handler
    implements ListListener<MidiInstrumentMap> {
        private Handler() {
        }

        @Override
        public void entryAdded(ListEvent<MidiInstrumentMap> listEvent) {
            this.updateDefaultMap();
        }

        @Override
        public void entryRemoved(ListEvent<MidiInstrumentMap> listEvent) {
            this.updateDefaultMap();
        }

        private void updateDefaultMap() {
            if (DefaultSamplerModel.this.getDefaultMidiInstrumentMap() != DefaultSamplerModel.this.findDefaultMidiInstrumentMap()) {
                DefaultSamplerModel.this.defaultMidiInstrumentMap = DefaultSamplerModel.this.findDefaultMidiInstrumentMap();
                DefaultSamplerModel.this.fireDefaultMapChanged();
            }
        }
    }
}

