/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import java.util.ArrayList;
import tim.prune.cmd.AppendRangeCmd;
import tim.prune.cmd.Command;
import tim.prune.data.DataPoint;
import tim.prune.data.TrackInfo;

public class DeleteFinalRangeCmd
extends Command {
    private final int _numPointsToDelete;

    public DeleteFinalRangeCmd(int n) {
        this(null, n);
    }

    protected DeleteFinalRangeCmd(Command command, int n) {
        super(command);
        this._numPointsToDelete = n;
    }

    @Override
    public int getUpdateFlags() {
        return 1;
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        if (this._numPointsToDelete < 0 || this._numPointsToDelete > trackInfo.getTrack().getNumPoints()) {
            return false;
        }
        trackInfo.getTrack().cropTo(trackInfo.getTrack().getNumPoints() - this._numPointsToDelete);
        trackInfo.getSelection().clearAll();
        return true;
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        int n;
        ArrayList<DataPoint> arrayList = new ArrayList<DataPoint>();
        int n2 = trackInfo.getTrack().getNumPoints();
        int n3 = n = n2 - this._numPointsToDelete;
        while (n3 < n2) {
            arrayList.add(trackInfo.getTrack().getPoint(n3));
            ++n3;
        }
        return new AppendRangeCmd(this, arrayList);
    }
}

